package cronapp.framework.api;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;

import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;

/**
 * Classe que representa ...
 * 
 * @author Rodrigo Reis
 * @version 1.0
 * @since 2018-05-16
 *
 */

public class RecaptchaValidator {

	private static String GOOGLE_VERIFY_URL = "https://www.google.com/recaptcha/api/siteverify";

	/**
	 * Construtor
	 **/
	public RecaptchaValidator() {
	}

	public static boolean validate(String secret_key, String client_token, String ip) {
		try {
			HttpClient httpclient = HttpClients.createDefault();
			HttpPost httppost = new HttpPost(GOOGLE_VERIFY_URL);

			// Request parameters and other properties.
			List<NameValuePair> params = new ArrayList<NameValuePair>(2);
			params.add(new BasicNameValuePair("secret", secret_key));
			params.add(new BasicNameValuePair("response", client_token));
			params.add(new BasicNameValuePair("ip", ip));

			httppost.setEntity(new UrlEncodedFormEntity(params, "UTF-8"));

			//Execute and get the response.
			HttpResponse response = httpclient.execute(httppost);
			HttpEntity entity = response.getEntity();
			if (entity != null) {
				InputStream instream = entity.getContent();
				try {
					// do something useful
					Scanner scanner = new Scanner(entity.getContent(), "UTF-8");
					String resposta = "";
					try {
						resposta = scanner.useDelimiter("\\A").next();
						scanner.close();
						instream.close();
						JsonParser parser = new JsonParser();
            JsonObject o = parser.parse(resposta).getAsJsonObject();
						return o.get("success").getAsBoolean();
					} catch (Exception e) {
				  	scanner.close();
					}
					scanner.close();
				} finally {
					instream.close();
				}
			}
		} catch (Exception e) {
			return false;
		}
		return false;
	}

}
