package cronapp.framework.authentication;

import cronapi.Var;
import cronapi.database.DatabaseQueryManager;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

/**
 * Controller responsável por gerir a troca de
 * senha do usuário através de serviço REST
 *
 * @author Techne
 */
@RestController
@RequestMapping(value = "/changeTheme")
public class ChangeTheme {

    @SuppressWarnings("unchecked")
    @ResponseStatus(HttpStatus.OK)
    @RequestMapping(method = RequestMethod.POST)
    public void post(String theme) throws Exception {
        User userDetails = (User) SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        DatabaseQueryManager getManager = new DatabaseQueryManager("auth");
        Var queryResult = getManager.get(userDetails.getUsername());
        if (queryResult.size() > 0) {
            Var userObject = queryResult.get(0);
            userObject.setField("theme", theme);
            DatabaseQueryManager putManager = new DatabaseQueryManager("updatePassword");
            putManager.update(userObject);
        } else {
            throw new UsernameNotFoundException("Usuário não encontrado!");
        }
    }
}
