package cronapp.framework.authentication;

import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;

@Component
@Scope(proxyMode = ScopedProxyMode.TARGET_CLASS, value = "session")
public class TenantComponent {

    private final Map<String, String> contextIds = new HashMap<>();

    public TenantComponent() {
    }

    public Object getId(String contextKey) {
        return contextIds.get(contextKey);
    }

    public void setId(String contextKey, String id) {
        contextIds.put(contextKey, id);
    }

    public Map<String, String> getContextIds() {
        return contextIds;
    }
}