/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.customization.diagram.model;

import cronapp.framework.customization.diagram.model.DiagramColumn;
import cronapp.framework.customization.diagram.model.DiagramUniqueKey;
import java.util.UUID;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

@Entity
@Table(name="CRONAPP_UNIQUE_KEY_COLUMN")
public class DiagramUniqueKeyColumn {
    @Id
    @Column(name="unique_key_column_id", length=36)
    private String id;
    @ManyToOne(optional=false)
    @JoinColumn(name="column_id", referencedColumnName="column_id")
    private DiagramColumn column;
    @Column(name="position")
    private Integer position;
    @ManyToOne(optional=false)
    @JoinColumn(name="unique_key_id", referencedColumnName="unique_key_id")
    private DiagramUniqueKey uniqueKey;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public DiagramColumn getColumn() {
        return this.column;
    }

    public void setColumn(DiagramColumn column) {
        this.column = column;
    }

    public Integer getPosition() {
        return this.position;
    }

    public void setPosition(Integer position) {
        this.position = position;
    }

    public DiagramUniqueKey getUniqueKey() {
        return this.uniqueKey;
    }

    public void setUniqueKey(DiagramUniqueKey uniqueKey) {
        this.uniqueKey = uniqueKey;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private String id = UUID.randomUUID().toString();
        private DiagramColumn column;
        private Integer position;

        private Builder() {
        }

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public Builder setColumn(DiagramColumn column) {
            this.column = column;
            return this;
        }

        public Builder setPosition(Integer position) {
            this.position = position;
            return this;
        }

        public DiagramUniqueKeyColumn build() {
            DiagramUniqueKeyColumn diagramUniqueKeyColumn = new DiagramUniqueKeyColumn();
            diagramUniqueKeyColumn.setId(this.id);
            diagramUniqueKeyColumn.setColumn(this.column);
            diagramUniqueKeyColumn.setPosition(this.position);
            return diagramUniqueKeyColumn;
        }
    }
}

