/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.customization.diagram.model;

import cronapp.framework.customization.diagram.model.DiagramTable;
import cronapp.framework.customization.diagram.model.DiagramUniqueKeyColumn;
import java.util.Collection;
import java.util.HashSet;
import java.util.UUID;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;

@Entity
@Table(name="CRONAPP_UNIQUE_KEY")
public class DiagramUniqueKey {
    @Id
    @Column(name="unique_key_id", length=36)
    private String id;
    @ManyToOne(optional=false)
    @JoinColumn(name="table_id", referencedColumnName="table_id")
    private DiagramTable table;
    @Column(name="name")
    private String name;
    @OneToMany(mappedBy="uniqueKey", cascade={CascadeType.PERSIST})
    private Collection<DiagramUniqueKeyColumn> uniqueColumns;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public DiagramTable getTable() {
        return this.table;
    }

    public void setTable(DiagramTable table) {
        this.table = table;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Collection<DiagramUniqueKeyColumn> getUniqueColumns() {
        return this.uniqueColumns;
    }

    public void setUniqueColumns(Collection<DiagramUniqueKeyColumn> uniqueColumns) {
        this.uniqueColumns = uniqueColumns;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private String id = UUID.randomUUID().toString();
        private String name;
        private final Collection<DiagramUniqueKeyColumn> uniqueColumns = new HashSet<DiagramUniqueKeyColumn>();

        private Builder() {
        }

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder addUniqueColumn(DiagramUniqueKeyColumn uniqueColumn) {
            if (uniqueColumn.getPosition() == 0) {
                uniqueColumn.setPosition(this.uniqueColumns.size());
            }
            this.uniqueColumns.add(uniqueColumn);
            return this;
        }

        public DiagramUniqueKey build() {
            DiagramUniqueKey diagramUniqueKey = new DiagramUniqueKey();
            this.uniqueColumns.forEach(uniqueColumn -> uniqueColumn.setUniqueKey(diagramUniqueKey));
            diagramUniqueKey.setId(this.id);
            diagramUniqueKey.setName(this.name);
            diagramUniqueKey.setUniqueColumns(this.uniqueColumns);
            return diagramUniqueKey;
        }
    }
}

