/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.customization.diagram.model;

import cronapp.framework.customization.diagram.model.DiagramColumn;
import cronapp.framework.customization.diagram.model.DiagramForeignKey;
import cronapp.framework.customization.diagram.model.DiagramPrimaryKey;
import cronapp.framework.customization.diagram.model.DiagramSchema;
import cronapp.framework.customization.diagram.model.DiagramUniqueKey;
import java.util.Collection;
import java.util.HashSet;
import java.util.UUID;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;

@Entity
@Table(name="CRONAPP_TABLE")
public class DiagramTable {
    @Id
    @Column(name="table_id", length=36)
    private String id;
    @ManyToOne
    @JoinColumn(name="schema_id", referencedColumnName="schema_id")
    private DiagramSchema schema;
    @Column(name="table_name")
    private String tableName;
    @Column(name="entity_name")
    private String entityName;
    @OneToMany(mappedBy="table", cascade={CascadeType.PERSIST})
    private Collection<DiagramColumn> columns;
    @OneToOne(mappedBy="table", cascade={CascadeType.PERSIST})
    private DiagramPrimaryKey primaryKey;
    @OneToMany(mappedBy="table", cascade={CascadeType.PERSIST})
    private Collection<DiagramUniqueKey> uniqueKeys;
    @OneToMany(mappedBy="table", cascade={CascadeType.PERSIST})
    private Collection<DiagramForeignKey> foreignKeys;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public DiagramSchema getSchema() {
        return this.schema;
    }

    public void setSchema(DiagramSchema schema) {
        this.schema = schema;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public void setEntityName(String entityName) {
        this.entityName = entityName;
    }

    public Collection<DiagramColumn> getColumns() {
        return this.columns;
    }

    public void setColumns(Collection<DiagramColumn> columns) {
        this.columns = columns;
    }

    public DiagramPrimaryKey getPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(DiagramPrimaryKey primaryKey) {
        this.primaryKey = primaryKey;
    }

    public Collection<DiagramUniqueKey> getUniqueKeys() {
        return this.uniqueKeys;
    }

    public void setUniqueKeys(Collection<DiagramUniqueKey> uniqueKeys) {
        this.uniqueKeys = uniqueKeys;
    }

    public Collection<DiagramForeignKey> getForeignKeys() {
        return this.foreignKeys;
    }

    public void setForeignKeys(Collection<DiagramForeignKey> foreignKeys) {
        this.foreignKeys = foreignKeys;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private String id = UUID.randomUUID().toString();
        private String tableName;
        private String entityName;
        private DiagramPrimaryKey primaryKey;
        private final Collection<DiagramColumn> columns = new HashSet<DiagramColumn>();
        private final Collection<DiagramUniqueKey> uniqueKeys = new HashSet<DiagramUniqueKey>();
        private final Collection<DiagramForeignKey> foreignKeys = new HashSet<DiagramForeignKey>();

        private Builder() {
        }

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public Builder setTableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public Builder setEntityName(String entityName) {
            this.entityName = entityName;
            return this;
        }

        public Builder addColumn(DiagramColumn column) {
            if (column.getPosition() == null) {
                column.setPosition(this.columns.size());
            }
            this.columns.add(column);
            return this;
        }

        public Builder setPrimaryKey(DiagramPrimaryKey primaryKey) {
            this.primaryKey = primaryKey;
            return this;
        }

        public Builder addUniqueKey(DiagramUniqueKey uniqueKey) {
            this.uniqueKeys.add(uniqueKey);
            return this;
        }

        public Builder addForeignKey(DiagramForeignKey foreignKey) {
            this.foreignKeys.add(foreignKey);
            return this;
        }

        public DiagramTable build() {
            DiagramTable diagramTable = new DiagramTable();
            if (this.primaryKey != null) {
                this.primaryKey.setTable(diagramTable);
            }
            this.columns.forEach(column -> column.setTable(diagramTable));
            this.uniqueKeys.forEach(uniqueKey -> uniqueKey.setTable(diagramTable));
            this.foreignKeys.forEach(foreignKey -> foreignKey.setTable(diagramTable));
            diagramTable.setId(this.id);
            diagramTable.setTableName(this.tableName);
            diagramTable.setEntityName(this.entityName);
            diagramTable.setColumns(this.columns);
            diagramTable.setPrimaryKey(this.primaryKey);
            diagramTable.setUniqueKeys(this.uniqueKeys);
            diagramTable.setForeignKeys(this.foreignKeys);
            return diagramTable;
        }
    }
}

