/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.customization.diagram.model;

import cronapp.framework.customization.diagram.model.DiagramSchema;
import java.util.Collection;
import java.util.HashSet;
import java.util.UUID;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;

@Entity
@Table(name="CRONAPP_SCHEMA_GROUP")
public class DiagramSchemaGroup {
    @Id
    @Column(name="schema_group_id", length=36)
    private String id;
    @Column(name="name")
    private String name;
    @OneToMany(mappedBy="schemaGroup", cascade={CascadeType.PERSIST})
    private Collection<DiagramSchema> schemas;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Collection<DiagramSchema> getSchemas() {
        return this.schemas;
    }

    public void setSchemas(Collection<DiagramSchema> schemas) {
        this.schemas = schemas;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private String id = UUID.randomUUID().toString();
        private String name;
        private Collection<DiagramSchema> schemas = new HashSet<DiagramSchema>();

        private Builder() {
        }

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder addSchema(DiagramSchema schema) {
            this.schemas.add(schema);
            return this;
        }

        public DiagramSchemaGroup build() {
            DiagramSchemaGroup diagramSchemaGroup = new DiagramSchemaGroup();
            this.schemas.forEach(schema -> schema.setSchemaGroup(diagramSchemaGroup));
            diagramSchemaGroup.setId(this.id);
            diagramSchemaGroup.setName(this.name);
            diagramSchemaGroup.setSchemas(this.schemas);
            return diagramSchemaGroup;
        }
    }
}

