/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.customization.diagram.model;

import cronapp.framework.customization.diagram.model.DiagramSchemaGroup;
import cronapp.framework.customization.diagram.model.DiagramTable;
import java.util.Collection;
import java.util.HashSet;
import java.util.UUID;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;

@Entity
@Table(name="CRONAPP_SCHEMA")
public class DiagramSchema {
    @Id
    @Column(name="schema_id", length=36)
    private String id;
    @Column(name="name")
    private String name;
    @ManyToOne
    @JoinColumn(name="schema_group_id", referencedColumnName="schema_group_id")
    private DiagramSchemaGroup schemaGroup;
    @OneToMany(mappedBy="schema", cascade={CascadeType.PERSIST})
    private Collection<DiagramTable> tables;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public DiagramSchemaGroup getSchemaGroup() {
        return this.schemaGroup;
    }

    public void setSchemaGroup(DiagramSchemaGroup schemaGroup) {
        this.schemaGroup = schemaGroup;
    }

    public Collection<DiagramTable> getTables() {
        return this.tables;
    }

    public void setTables(Collection<DiagramTable> tables) {
        this.tables = tables;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private String id = UUID.randomUUID().toString();
        private String name;
        private final Collection<DiagramTable> tables = new HashSet<DiagramTable>();

        private Builder() {
        }

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder addTable(DiagramTable table) {
            this.tables.add(table);
            return this;
        }

        public DiagramSchema build() {
            DiagramSchema diagramSchema = new DiagramSchema();
            this.tables.forEach(table -> table.setSchema(diagramSchema));
            diagramSchema.setId(this.id);
            diagramSchema.setName(this.name);
            diagramSchema.setTables(this.tables);
            return diagramSchema;
        }
    }
}

