/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.customization.diagram.model;

import cronapp.framework.customization.diagram.model.DiagramPrimaryKeyColumn;
import cronapp.framework.customization.diagram.model.DiagramTable;
import java.util.Collection;
import java.util.HashSet;
import java.util.UUID;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;

@Entity
@Table(name="CRONAPP_PRIMARY_KEY")
public class DiagramPrimaryKey {
    @Id
    @Column(name="primary_key_id", length=36)
    private String id;
    @Column(name="name")
    private String name;
    @OneToOne
    @JoinColumn(name="table_id", referencedColumnName="table_id")
    private DiagramTable table;
    @OneToMany(mappedBy="primaryKey", cascade={CascadeType.PERSIST})
    private Collection<DiagramPrimaryKeyColumn> columns;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public DiagramTable getTable() {
        return this.table;
    }

    public void setTable(DiagramTable table) {
        this.table = table;
    }

    public Collection<DiagramPrimaryKeyColumn> getColumns() {
        return this.columns;
    }

    public void setColumns(Collection<DiagramPrimaryKeyColumn> columns) {
        this.columns = columns;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private String id = UUID.randomUUID().toString();
        private String name;
        private Collection<DiagramPrimaryKeyColumn> columns = new HashSet<DiagramPrimaryKeyColumn>();

        private Builder() {
        }

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder addColumn(DiagramPrimaryKeyColumn column) {
            if (column.getPosition() == null) {
                column.setPosition(this.columns.size());
            }
            this.columns.add(column);
            return this;
        }

        public DiagramPrimaryKey build() {
            DiagramPrimaryKey diagramPrimaryKey = new DiagramPrimaryKey();
            this.columns.forEach(column -> column.setPrimaryKey(diagramPrimaryKey));
            diagramPrimaryKey.setId(this.id);
            diagramPrimaryKey.setName(this.name);
            diagramPrimaryKey.setColumns(this.columns);
            return diagramPrimaryKey;
        }
    }
}

