/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.customization.diagram.model;

import cronapp.framework.customization.diagram.model.DiagramForeignKeyAction;
import cronapp.framework.customization.diagram.model.DiagramForeignKeyColumn;
import cronapp.framework.customization.diagram.model.DiagramForeignKeyReference;
import cronapp.framework.customization.diagram.model.DiagramTable;
import java.util.Collection;
import java.util.HashSet;
import java.util.UUID;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;

@Entity
@Table(name="CRONAPP_FOREIGN_KEY")
public class DiagramForeignKey {
    @Id
    @Column(name="foreign_key_id", length=36)
    private String id;
    @Column(name="name")
    private String name;
    @Column(name="delete_action")
    @Enumerated(value=EnumType.STRING)
    private DiagramForeignKeyAction deleteAction;
    @Column(name="update_action")
    @Enumerated(value=EnumType.STRING)
    private DiagramForeignKeyAction updateAction;
    @ManyToOne
    @JoinColumn(name="table_id", referencedColumnName="table_id")
    private DiagramTable table;
    @ManyToOne
    @JoinColumn(name="referenced_table_id", referencedColumnName="table_id")
    private DiagramTable referencedTable;
    @OneToMany(mappedBy="foreignKey", cascade={CascadeType.PERSIST})
    private Collection<DiagramForeignKeyColumn> columns;
    @OneToMany(mappedBy="foreignKey", cascade={CascadeType.PERSIST})
    private Collection<DiagramForeignKeyReference> references;

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public DiagramForeignKeyAction getDeleteAction() {
        return this.deleteAction;
    }

    public void setDeleteAction(DiagramForeignKeyAction deleteAction) {
        this.deleteAction = deleteAction;
    }

    public DiagramForeignKeyAction getUpdateAction() {
        return this.updateAction;
    }

    public void setUpdateAction(DiagramForeignKeyAction updateAction) {
        this.updateAction = updateAction;
    }

    public DiagramTable getTable() {
        return this.table;
    }

    public void setTable(DiagramTable table) {
        this.table = table;
    }

    public DiagramTable getReferencedTable() {
        return this.referencedTable;
    }

    public void setReferencedTable(DiagramTable referencedTable) {
        this.referencedTable = referencedTable;
    }

    public Collection<DiagramForeignKeyColumn> getColumns() {
        return this.columns;
    }

    public void setColumns(Collection<DiagramForeignKeyColumn> columns) {
        this.columns = columns;
    }

    public Collection<DiagramForeignKeyReference> getReferences() {
        return this.references;
    }

    public void setReferences(Collection<DiagramForeignKeyReference> references) {
        this.references = references;
    }

    public static final class Builder {
        private String id = UUID.randomUUID().toString();
        private String name;
        private DiagramForeignKeyAction deleteAction;
        private DiagramForeignKeyAction updateAction;
        private DiagramTable referencedTable;
        private final Collection<DiagramForeignKeyColumn> columns = new HashSet<DiagramForeignKeyColumn>();
        private final Collection<DiagramForeignKeyReference> references = new HashSet<DiagramForeignKeyReference>();

        private Builder() {
        }

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setDeleteAction(DiagramForeignKeyAction deleteAction) {
            this.deleteAction = deleteAction;
            return this;
        }

        public Builder setUpdateAction(DiagramForeignKeyAction updateAction) {
            this.updateAction = updateAction;
            return this;
        }

        public Builder setReferencedTable(DiagramTable referencedTable) {
            this.referencedTable = referencedTable;
            return this;
        }

        public Builder addColumn(DiagramForeignKeyColumn column) {
            if (column.getPosition() == null) {
                column.setPosition(this.columns.size());
            }
            this.columns.add(column);
            return this;
        }

        public Builder addReference(DiagramForeignKeyReference reference) {
            if (reference.getPosition() == null) {
                reference.setPosition(this.references.size());
            }
            this.references.add(reference);
            return this;
        }

        public DiagramForeignKey build() {
            DiagramForeignKey diagramForeignKey = new DiagramForeignKey();
            this.columns.forEach(column -> column.setForeignKey(diagramForeignKey));
            this.references.forEach(reference -> reference.setForeignKey(diagramForeignKey));
            diagramForeignKey.setId(this.id);
            diagramForeignKey.setName(this.name);
            diagramForeignKey.setDeleteAction(this.deleteAction);
            diagramForeignKey.setUpdateAction(this.updateAction);
            diagramForeignKey.setReferencedTable(this.referencedTable);
            diagramForeignKey.setColumns(this.columns);
            diagramForeignKey.setReferences(this.references);
            return diagramForeignKey;
        }
    }
}

