/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.customization.diagram;

import com.google.common.base.CaseFormat;
import cronapp.framework.core.CronappConfiguration;
import cronapp.framework.core.CronappFrameworkException;
import cronapp.framework.customization.diagram.DiagramCustomizationClassLoader;
import cronapp.framework.customization.diagram.model.DiagramColumn;
import cronapp.framework.customization.diagram.model.DiagramPrimaryKey;
import cronapp.framework.customization.diagram.model.DiagramPrimaryKeyColumn;
import cronapp.framework.customization.diagram.model.DiagramSchemaGroup;
import cronapp.framework.customization.diagram.model.DiagramTable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.IllegalFormatException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ClassFile;
import javassist.bytecode.ConstPool;
import javassist.bytecode.FieldInfo;
import javassist.bytecode.annotation.Annotation;
import javassist.bytecode.annotation.MemberValue;
import javassist.bytecode.annotation.StringMemberValue;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Id;
import javax.persistence.Table;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.EntityAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.XMLAttributes;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.BasicAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.IdAccessor;
import org.eclipse.persistence.internal.jpa.metadata.columns.ColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.tables.TableMetadata;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;
import org.eclipse.persistence.jpa.metadata.MetadataSource;
import org.eclipse.persistence.logging.SessionLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiagramCustomizationMetadataSource
implements MetadataSource {
    private static final Method defineClassMethod;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final XMLEntityMappings xmlEntityMappings = new XMLEntityMappings();

    public DiagramCustomizationMetadataSource() {
        this.initializeXMLEntityMappingLists();
    }

    private static String getJavaType(DiagramColumn diagramColumn) {
        Integer type = diagramColumn.getSqlType();
        Integer size = diagramColumn.getSize();
        Integer decimals = diagramColumn.getDecimals();
        switch (type) {
            case 1: {
                if (size == 1) {
                    return Character.class.getName();
                }
            }
            case -1: 
            case 12: 
            case 2005: {
                return String.class.getName();
            }
            case -7: 
            case 16: {
                return Boolean.class.getName();
            }
            case -6: {
                return Byte.class.getName();
            }
            case 5: {
                return Short.class.getName();
            }
            case 4: {
                return Integer.class.getName();
            }
            case -5: {
                return Long.class.getName();
            }
            case 6: 
            case 7: {
                return Float.class.getName();
            }
            case 2: 
            case 8: {
                return Double.class.getName();
            }
            case 3: {
                if (decimals == 0 && size < 10) {
                    return Integer.class.getName();
                }
                if (decimals == 0) {
                    return Long.class.getName();
                }
                return Double.class.getName();
            }
            case 91: 
            case 92: 
            case 93: {
                return Date.class.getName();
            }
        }
        return Object.class.getName();
    }

    private static void processDiagramTableCustomization(DiagramTable diagramTable) throws CronappFrameworkException {
        String className = diagramTable.getSchema().getSchemaGroup().getName() + ".entity." + diagramTable.getEntityName();
        if (DiagramCustomizationClassLoader.hasCustomization(className)) {
            return;
        }
        try {
            CtClass classClass;
            ClassPool pool = ClassPool.getDefault();
            if (pool.find(className) == null) {
                classClass = pool.makeClass(className);
                ClassFile classFile = classClass.getClassFile();
                ConstPool classConstPool = classFile.getConstPool();
                Annotation entityAnnotation = new Annotation(Entity.class.getName(), classConstPool);
                Annotation tableAnnotation = new Annotation(Table.class.getName(), classConstPool);
                Annotation securityAnnotation = new Annotation("cronapi.rest.security.CronappSecurity", classConstPool);
                tableAnnotation.addMemberValue("name", (MemberValue)new StringMemberValue(diagramTable.getTableName(), classConstPool));
                AnnotationsAttribute annotationsAttribute = new AnnotationsAttribute(classConstPool, "RuntimeVisibleAnnotations");
                annotationsAttribute.setAnnotations(new Annotation[]{entityAnnotation, tableAnnotation, securityAnnotation});
                classFile.addAttribute((AttributeInfo)annotationsAttribute);
            } else {
                classClass = pool.getCtClass(className);
            }
            if (classClass.isFrozen()) {
                return;
            }
            DiagramPrimaryKey primaryKey = diagramTable.getPrimaryKey();
            List<Object> primaryKeyColumns = primaryKey != null ? diagramTable.getPrimaryKey().getColumns().stream().map(DiagramPrimaryKeyColumn::getColumn).map(DiagramColumn::getId).collect(Collectors.toList()) : new ArrayList();
            for (DiagramColumn diagramColumn : diagramTable.getColumns()) {
                CtClass fieldType = pool.get(DiagramCustomizationMetadataSource.getJavaType(diagramColumn));
                String fieldName = DiagramCustomizationMetadataSource.detectCaseFormat(diagramColumn.getPropertyName()).to(CaseFormat.LOWER_CAMEL, diagramColumn.getPropertyName());
                String fieldColumnName = diagramColumn.getColumnName();
                String fieldPropertyName = diagramColumn.getPropertyName();
                CtField field = new CtField(fieldType, fieldName, classClass);
                FieldInfo fieldInfo = field.getFieldInfo();
                ConstPool constPool = fieldInfo.getConstPool();
                ArrayList<Annotation> annotations = new ArrayList<Annotation>();
                Annotation columnAnnotation = new Annotation(Column.class.getName(), constPool);
                columnAnnotation.addMemberValue("name", (MemberValue)new StringMemberValue(fieldColumnName, constPool));
                annotations.add(columnAnnotation);
                if (primaryKeyColumns.contains(diagramColumn.getId())) {
                    Annotation idAnnotation = new Annotation(Id.class.getName(), constPool);
                    annotations.add(idAnnotation);
                }
                AnnotationsAttribute annotationsAttribute = new AnnotationsAttribute(constPool, "RuntimeVisibleAnnotations");
                annotationsAttribute.setAnnotations(annotations.toArray(new Annotation[0]));
                fieldInfo.setAccessFlags(2);
                fieldInfo.addAttribute((AttributeInfo)annotationsAttribute);
                CtMethod customFieldGetter = CtNewMethod.getter((String)("get" + fieldPropertyName), (CtField)field);
                CtMethod customFieldSetter = CtNewMethod.setter((String)("set" + fieldPropertyName), (CtField)field);
                classClass.addField(field);
                classClass.addMethod(customFieldGetter);
                classClass.addMethod(customFieldSetter);
            }
            byte[] classBytes = classClass.toBytecode();
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            defineClassMethod.invoke((Object)classLoader, className, classBytes, 0, classBytes.length);
            DiagramCustomizationClassLoader.registerCustomization(className, classBytes);
        }
        catch (Exception e) {
            throw new CronappFrameworkException((Throwable)e);
        }
    }

    private static CaseFormat detectCaseFormat(String s) throws IllegalFormatException {
        if (s.contains("_")) {
            if (s.toUpperCase().equals(s)) {
                return CaseFormat.UPPER_UNDERSCORE;
            }
            if (s.toLowerCase().equals(s)) {
                return CaseFormat.LOWER_UNDERSCORE;
            }
        } else if (s.contains("-")) {
            if (s.toLowerCase().equals(s)) {
                return CaseFormat.LOWER_HYPHEN;
            }
        } else {
            if (Character.isLowerCase(s.charAt(0)) && s.matches("([a-z]+[A-Z]+\\w+)+")) {
                return CaseFormat.LOWER_CAMEL;
            }
            if (s.matches("([A-Z]+[a-z]+\\w+)+")) {
                return CaseFormat.UPPER_CAMEL;
            }
            if (s.toLowerCase().equals(s)) {
                return CaseFormat.LOWER_CAMEL;
            }
            if (s.toUpperCase().equals(s)) {
                return CaseFormat.UPPER_UNDERSCORE;
            }
        }
        throw new IllegalArgumentException("Couldn't find the case format of the given string.");
    }

    private void generateXmlEntityMappings(String schemaGroupName) {
        EntityManagerFactory entityManagerFactory = (EntityManagerFactory)CronappConfiguration.getBean((String)"cronappEntityManagerFactory", EntityManagerFactory.class);
        EntityManager entityManager = entityManagerFactory.createEntityManager();
        try {
            List diagramSchemaGroups = entityManager.createQuery("SELECT sg FROM DiagramSchemaGroup sg where sg.name = :schemaGroupName", DiagramSchemaGroup.class).setParameter("schemaGroupName", (Object)schemaGroupName).getResultList();
            if (!diagramSchemaGroups.isEmpty()) {
                DiagramSchemaGroup diagramSchemaGroup = (DiagramSchemaGroup)diagramSchemaGroups.get(0);
                diagramSchemaGroup.getSchemas().stream().flatMap(diagramSchema -> diagramSchema.getTables().stream()).forEach(this::processDiagramTable);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void processDiagramTable(DiagramTable diagramTable) {
        EntityAccessor entity = new EntityAccessor();
        this.initializeXMLAttributeLists((ClassAccessor)entity);
        String className = diagramTable.getSchema().getSchemaGroup().getName() + ".entity." + diagramTable.getEntityName();
        entity.setClassName(className);
        TableMetadata table = new TableMetadata();
        table.setName(diagramTable.getTableName());
        entity.setTable(table);
        DiagramPrimaryKey primaryKey = diagramTable.getPrimaryKey();
        List<Object> primaryKeyColumns = primaryKey != null ? diagramTable.getPrimaryKey().getColumns().stream().map(DiagramPrimaryKeyColumn::getColumn).map(DiagramColumn::getId).collect(Collectors.toList()) : new ArrayList();
        for (DiagramColumn diagramColumn : diagramTable.getColumns()) {
            IdAccessor attribute;
            if (primaryKeyColumns.contains(diagramColumn.getId())) {
                attribute = new IdAccessor();
                entity.getAttributes().getIds().add(attribute);
            } else {
                attribute = new BasicAccessor();
                entity.getAttributes().getBasics().add(attribute);
            }
            String propertyName = diagramColumn.getPropertyName();
            attribute.setName(Character.toLowerCase(propertyName.charAt(0)) + propertyName.substring(1));
            attribute.setAttributeType(DiagramCustomizationMetadataSource.getJavaType(diagramColumn));
            ColumnMetadata column = new ColumnMetadata();
            column.setName(diagramColumn.getColumnName());
            attribute.setColumn(column);
        }
        this.xmlEntityMappings.getEntities().add(entity);
        try {
            DiagramCustomizationMetadataSource.processDiagramTableCustomization(diagramTable);
        }
        catch (CronappFrameworkException e) {
            this.logger.error("Error processing customization", (Throwable)e);
        }
    }

    private void initializeXMLEntityMappingLists() {
        this.xmlEntityMappings.setEntities(new ArrayList());
        this.xmlEntityMappings.setEmbeddables(new ArrayList());
        this.xmlEntityMappings.setPLSQLRecords(new ArrayList());
        this.xmlEntityMappings.setPLSQLTables(new ArrayList());
        this.xmlEntityMappings.setOracleObjectTypes(new ArrayList());
        this.xmlEntityMappings.setOracleArrayTypes(new ArrayList());
        this.xmlEntityMappings.setNamedNativeQueries(new ArrayList());
        this.xmlEntityMappings.setNamedPLSQLStoredFunctionQueries(new ArrayList());
        this.xmlEntityMappings.setNamedPLSQLStoredProcedureQueries(new ArrayList());
        this.xmlEntityMappings.setNamedStoredFunctionQueries(new ArrayList());
        this.xmlEntityMappings.setNamedStoredProcedureQueries(new ArrayList());
        this.xmlEntityMappings.setMixedConverters(new ArrayList());
        this.xmlEntityMappings.setMappedSuperclasses(new ArrayList());
        this.xmlEntityMappings.setTenantDiscriminatorColumns(new ArrayList());
        this.xmlEntityMappings.setTypeConverters(new ArrayList());
        this.xmlEntityMappings.setObjectTypeConverters(new ArrayList());
        this.xmlEntityMappings.setSerializedConverters(new ArrayList());
        this.xmlEntityMappings.setStructConverters(new ArrayList());
        this.xmlEntityMappings.setTableGenerators(new ArrayList());
        this.xmlEntityMappings.setSequenceGenerators(new ArrayList());
        this.xmlEntityMappings.setPartitioning(new ArrayList());
        this.xmlEntityMappings.setReplicationPartitioning(new ArrayList());
        this.xmlEntityMappings.setRoundRobinPartitioning(new ArrayList());
        this.xmlEntityMappings.setPinnedPartitioning(new ArrayList());
        this.xmlEntityMappings.setRangePartitioning(new ArrayList());
        this.xmlEntityMappings.setValuePartitioning(new ArrayList());
        this.xmlEntityMappings.setHashPartitioning(new ArrayList());
        this.xmlEntityMappings.setNamedQueries(new ArrayList());
        this.xmlEntityMappings.setSqlResultSetMappings(new ArrayList());
        this.xmlEntityMappings.setUuidGenerators(new ArrayList());
    }

    public Map<String, Object> getPropertyOverrides(Map<String, Object> properties, ClassLoader classLoader, SessionLog log) {
        return Map.of();
    }

    private void initializeXMLAttributeLists(ClassAccessor accessor) {
        accessor.setAttributes(new XMLAttributes());
        accessor.getAttributes().setIds(new ArrayList());
        accessor.getAttributes().setBasics(new ArrayList());
        accessor.getAttributes().setArrays(new ArrayList());
        accessor.getAttributes().setStructures(new ArrayList());
        accessor.getAttributes().setEmbeddeds(new ArrayList());
        accessor.getAttributes().setBasicCollections(new ArrayList());
        accessor.getAttributes().setBasicMaps(new ArrayList());
        accessor.getAttributes().setElementCollections(new ArrayList());
        accessor.getAttributes().setManyToManys(new ArrayList());
        accessor.getAttributes().setManyToOnes(new ArrayList());
        accessor.getAttributes().setOneToManys(new ArrayList());
        accessor.getAttributes().setOneToOnes(new ArrayList());
        accessor.getAttributes().setTransformations(new ArrayList());
        accessor.getAttributes().setTransients(new ArrayList());
        accessor.getAttributes().setVariableOneToOnes(new ArrayList());
        accessor.getAttributes().setVersions(new ArrayList());
    }

    public XMLEntityMappings getEntityMappings(Map<String, Object> properties, ClassLoader classLoader, SessionLog log) {
        Object diagramNamespace = properties.get("cronapp.diagram.namespace");
        Objects.requireNonNull(diagramNamespace, "Missing property cronapp.diagram.namespace");
        this.generateXmlEntityMappings(diagramNamespace.toString());
        return this.xmlEntityMappings;
    }

    static {
        try {
            defineClassMethod = ClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
            defineClassMethod.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

