/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.customization.diagram;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.ServletContext;
import org.apache.commons.io.FilenameUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class DiagramCustomizationController {
    private final ServletContext servletContext;

    public DiagramCustomizationController(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    @GetMapping(value={"/api/customization/diagrams"})
    @ResponseBody
    public synchronized List<String> getDiagrams() throws IOException {
        Path servletContextPath = Paths.get(this.servletContext.getRealPath("WEB-INF/classes/META-INF/diagram"), new String[0]);
        try (Stream<Path> walker = Files.walk(servletContextPath, new FileVisitOption[0]);){
            List<String> list = walker.map(Path::toString).filter(path -> FilenameUtils.getExtension((String)path).equals("umlcd")).map(FilenameUtils::getBaseName).collect(Collectors.toUnmodifiableList());
            return list;
        }
    }
}

