/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.customization.diagram;

import cronapp.framework.core.EntityManagerConfiguration;
import cronapp.framework.customization.diagram.DiagramCustomizationMetadataSource;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.NotFoundException;
import javassist.bytecode.Descriptor;
import javax.sql.DataSource;
import liquibase.integration.spring.SpringLiquibase;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class DiagramCustomizationConfiguration {
    @Bean
    public SpringLiquibase diagramCustomizationLiquibase(@Qualifier(value="cronappDataSource") DataSource dataSource) {
        SpringLiquibase liquibase = new SpringLiquibase();
        liquibase.setDataSource(dataSource);
        liquibase.setChangeLog("classpath:customization-diagram-db-changes.xml");
        return liquibase;
    }

    @Bean
    public EntityManagerConfiguration diagramEntityManagerConfiguration() {
        return EntityManagerConfiguration.builder().packageToScan(this.getClass().getPackage().getName()).build();
    }

    static {
        try {
            ClassPool pool = ClassPool.getDefault();
            CtClass metadataFactory = pool.get("org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataFactory");
            CtConstructor constructor = metadataFactory.getConstructor(Descriptor.ofConstructor((CtClass[])new CtClass[]{pool.get("org.eclipse.persistence.internal.jpa.metadata.MetadataLogger"), pool.get("java.lang.ClassLoader")}));
            constructor.insertAfter("this.m_loader = new cronapp.framework.customization.diagram.DiagramCustomizationClassLoader(loader);");
            metadataFactory.toClass(DiagramCustomizationMetadataSource.class.getClassLoader(), null);
        }
        catch (CannotCompileException | NotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

