/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.customization.diagram;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DiagramCustomizationClassLoader
extends ClassLoader {
    private static final Map<String, byte[]> customizations = new ConcurrentHashMap<String, byte[]>();

    public static void registerCustomization(String className, byte[] classBytes) {
        customizations.put(className, classBytes);
    }

    public static boolean hasCustomization(String className) {
        return customizations.containsKey(className);
    }

    public DiagramCustomizationClassLoader(ClassLoader parent) {
        super(parent);
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        String className;
        if (name.endsWith(".class") && customizations.containsKey(className = name.replace('/', '.').replace(".class", ""))) {
            return new ByteArrayInputStream(customizations.get(className));
        }
        return super.getResourceAsStream(name);
    }
}

