/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.core.persistence;

import cronapp.framework.core.CronappSettingsService;
import cronapp.framework.core.model.SecureValue;
import javax.persistence.AttributeConverter;
import javax.persistence.Converter;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.security.crypto.encrypt.Encryptors;
import org.springframework.stereotype.Component;

@Converter
@Component
public class SecureValueConverter
implements AttributeConverter<SecureValue, SecureValue> {
    public final CronappSettingsService settingsService;

    public SecureValueConverter(CronappSettingsService settingsService) {
        this.settingsService = settingsService;
    }

    public SecureValue convertToDatabaseColumn(SecureValue attribute) {
        if (BooleanUtils.isTrue((Boolean)attribute.getSecure())) {
            Encryptors.text((CharSequence)this.settingsService.getEncryptionKey(), (CharSequence)this.settingsService.getEncryptionSalt()).encrypt(attribute.getValue());
        }
        return attribute;
    }

    public SecureValue convertToEntityAttribute(SecureValue dbData) {
        return dbData;
    }
}

