/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.core;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import cronapp.framework.core.CronappSettingsRepository;
import cronapp.framework.core.model.CronappSettings;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.context.annotation.DependsOn;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;

@Service
@DependsOn(value={"liquibase"})
@CacheConfig(cacheNames={"cronapp.framework.core.settings"})
public class CronappSettingsService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final CronappSettingsRepository settingsRepository;
    private final Environment environment;

    public CronappSettingsService(CronappSettingsRepository settingsRepository, Environment environment) {
        this.settingsRepository = settingsRepository;
        this.environment = environment;
    }

    public String getOption(String option) {
        return this.settingsRepository.findByApplicationIdAndName(CronappSettingsService.getApplicationId(), option).orElse(CronappSettings.newBuilder().build()).getValue();
    }

    public void addOption(String option, boolean secure) {
        Optional<CronappSettings> settings = this.settingsRepository.findByApplicationIdAndName(CronappSettingsService.getApplicationId(), option);
        if (settings.isPresent()) {
            String[] reloadProperties = (String[])this.environment.getProperty("reload.properties", String[].class);
            if (reloadProperties != null && Arrays.asList(reloadProperties).stream().anyMatch(item -> item.equals("all") || item.equals(option))) {
                CronappSettings item2 = settings.get();
                item2.setValue(this.environment.getProperty(option));
                this.settingsRepository.save(item2);
            }
            return;
        }
        this.settingsRepository.save(CronappSettings.newBuilder().setId(UUID.randomUUID().toString()).setApplicationId(CronappSettingsService.getApplicationId()).setName(option).setSecure(secure).setValue(this.environment.getProperty(option)).build());
    }

    public String getEncryptionKey() {
        return DigestUtils.sha1Hex((String)CronappSettingsService.token());
    }

    public String getEncryptionSalt() {
        return DigestUtils.sha1Hex((String)CronappSettingsService.getApplicationId());
    }

    public String getIntanceId() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            this.logger.warn("Couldn't get instanceId from hostname", (Throwable)e);
            return UUID.randomUUID().toString();
        }
    }

    private static JsonObject loadAppConfig() {
        JsonObject jsonObject;
        block8: {
            ClassLoader classLoader = CronappSettings.class.getClassLoader();
            InputStream stream = classLoader.getResourceAsStream("META-INF/app.config");
            try {
                InputStreamReader reader = new InputStreamReader(stream);
                JsonElement jsonElement = new JsonParser().parse((Reader)reader);
                jsonObject = jsonElement.getAsJsonObject();
                if (stream == null) break block8;
            }
            catch (Throwable reader) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable) {
                            reader.addSuppressed(throwable);
                        }
                    }
                    throw reader;
                }
                catch (Exception e) {
                    JsonObject jsonElement = new JsonObject();
                    return jsonElement.getAsJsonObject();
                }
            }
            stream.close();
        }
        return jsonObject;
    }

    public static boolean isNotNull(JsonElement value) {
        return value != null && !value.isJsonNull();
    }

    public static String token() {
        JsonElement elem;
        JsonObject config = CronappSettingsService.loadAppConfig();
        if (CronappSettingsService.isNotNull(config.get("security")) && CronappSettingsService.isNotNull(elem = config.get("security").getAsJsonObject().get("token"))) {
            return elem.getAsString();
        }
        return "9SyECk96oDsTmXfogIieDI0cD/8FpnojlYSUJT5U9I/FGVmBz5oskmjOR8cbXTvoPjX+Pq/T/b1PqpHX0lYm0oCBjXWICA==";
    }

    public static String getApplicationId() {
        JsonObject app;
        JsonObject config = CronappSettingsService.loadAppConfig();
        if (CronappSettingsService.isNotNull(config.get("app")) && CronappSettingsService.isNotNull((app = config.get("app").getAsJsonObject()).get("guid"))) {
            return app.get("guid").getAsString();
        }
        return "";
    }
}

