/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.core;

import cronapp.framework.core.EntityManagerConfiguration;
import cronapp.framework.core.liquibase.CronappChangeLog;
import cronapp.framework.core.liquibase.CronappLiquibase;
import java.io.FileWriter;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.naming.NamingException;
import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import liquibase.integration.spring.SpringLiquibase;
import org.apache.commons.dbcp2.BasicDataSource;
import org.eclipse.persistence.internal.jpa.deployment.PersistenceUnitProcessor;
import org.eclipse.persistence.internal.jpa.deployment.SEPersistenceUnitInfo;
import org.eclipse.persistence.internal.jpa.jdbc.DataSourceImpl;
import org.eclipse.persistence.jpa.Archive;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.cache.concurrent.ConcurrentMapCacheManager;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.jndi.JndiTemplate;
import org.springframework.lang.Nullable;
import org.springframework.orm.jpa.AbstractEntityManagerFactoryBean;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.JpaVendorAdapter;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.orm.jpa.vendor.EclipseLinkJpaVendorAdapter;
import org.springframework.transaction.PlatformTransactionManager;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Configuration
@ComponentScan
@EnableCaching
@EnableJpaRepositories(basePackageClasses={CronappConfiguration.class}, entityManagerFactoryRef="cronappEntityManagerFactoryBean", transactionManagerRef="cronappTransactionManager")
public class CronappConfiguration
implements ApplicationContextAware {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static ApplicationContext applicationContext;

    public static String getProperty(String key) {
        return applicationContext.getEnvironment().getProperty(key);
    }

    public static <T> T getBean(String name, @Nullable Class<T> requiredType) {
        return (T)applicationContext.getBean(name, requiredType);
    }

    public static Object getBean(String name) {
        return applicationContext.getBean(name);
    }

    public static <T> T getBean(Class<T> requiredType) {
        return (T)applicationContext.getBean(requiredType);
    }

    public static <T> T autowire(Class<T> requiredType) {
        return (T)applicationContext.getAutowireCapableBeanFactory().autowire(requiredType, 3, true);
    }

    private static Stream<? extends SEPersistenceUnitInfo> getPersistenceUnits(Archive archive) {
        return PersistenceUnitProcessor.getPersistenceUnits((Archive)archive, (ClassLoader)Thread.currentThread().getContextClassLoader()).stream();
    }

    @Bean(name={"cronappDataSource"})
    public DataSource cronappDataSource(@Value(value="${cronapp.datasource.url:#{null}}") Optional<String> dataSourceUrl, @Value(value="${cronapp.datasource.username:#{null}}") Optional<String> dataSourceUsername, @Value(value="${cronapp.datasource.password:#{null}}") Optional<String> dataSourcePassword, @Value(value="${cronapp.datasource.driver:#{null}}") Optional<String> dataSourceDriver) throws NamingException {
        if (dataSourceUrl.isPresent()) {
            BasicDataSource dataSource2 = new BasicDataSource();
            dataSourceUrl.ifPresent(arg_0 -> ((BasicDataSource)dataSource2).setUrl(arg_0));
            dataSourceUsername.ifPresent(arg_0 -> ((BasicDataSource)dataSource2).setUsername(arg_0));
            dataSourcePassword.ifPresent(arg_0 -> ((BasicDataSource)dataSource2).setPassword(arg_0));
            dataSourceDriver.ifPresent(arg_0 -> ((BasicDataSource)dataSource2).setDriverClassName(arg_0));
            return dataSource2;
        }
        String dataSourceName = PersistenceUnitProcessor.findPersistenceArchives().stream().flatMap(CronappConfiguration::getPersistenceUnits).filter(info -> info.getPersistenceUnitName().equals("app")).map(SEPersistenceUnitInfo::getNonJtaDataSource).map(dataSource -> ((DataSourceImpl)dataSource).getName()).findFirst().orElseThrow();
        return (DataSource)new JndiTemplate().lookup(dataSourceName);
    }

    @Bean
    public EntityManagerConfiguration coreEntityManagerConfiguration() {
        return EntityManagerConfiguration.builder().packageToScan(this.getClass().getPackage().getName()).build();
    }

    @Bean
    public AbstractEntityManagerFactoryBean cronappEntityManagerFactoryBean(@Qualifier(value="cronappDataSource") DataSource dataSource, List<EntityManagerConfiguration> configurations, JpaVendorAdapter jpaVendorAdapter) {
        HashMap<String, String> jpaProperties = new HashMap<String, String>();
        jpaProperties.put("eclipselink.weaving", "false");
        LocalContainerEntityManagerFactoryBean emf = new LocalContainerEntityManagerFactoryBean();
        emf.setDataSource(dataSource);
        emf.setPackagesToScan((String[])configurations.stream().map(EntityManagerConfiguration::getPackageToScan).toArray(String[]::new));
        emf.setPersistenceUnitName("cronapp.framework.core");
        emf.setJpaVendorAdapter(jpaVendorAdapter);
        emf.setJpaPropertyMap(jpaProperties);
        return emf;
    }

    @Bean
    public JpaVendorAdapter jpaVendorAdapter() {
        return new EclipseLinkJpaVendorAdapter();
    }

    @Bean
    public EntityManagerFactory cronappEntityManagerFactory(@Qualifier(value="cronappEntityManagerFactoryBean") AbstractEntityManagerFactoryBean factoryBean) {
        return factoryBean.getObject();
    }

    @Bean
    public PlatformTransactionManager cronappTransactionManager(@Qualifier(value="cronappEntityManagerFactory") EntityManagerFactory entityManagerFactory) {
        JpaTransactionManager transactionManager = new JpaTransactionManager();
        transactionManager.setEntityManagerFactory(entityManagerFactory);
        return transactionManager;
    }

    @Bean
    public SpringLiquibase liquibase(List<CronappChangeLog> changeLogs, ResourceLoader resourceLoader, @Qualifier(value="cronappDataSource") DataSource dataSource) throws Exception {
        CronappLiquibase liquibase = new CronappLiquibase();
        liquibase.setDataSource(dataSource);
        if (!changeLogs.isEmpty()) {
            Document baseDocument;
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Resource baseResource = resourceLoader.getResource(changeLogs.get(0).getDataModel());
            try (InputStream baseResourceStream = baseResource.getInputStream();){
                baseDocument = documentBuilder.parse(baseResourceStream);
            }
            Element baseDocumentElement = baseDocument.getDocumentElement();
            for (int i = 1; i < changeLogs.size(); ++i) {
                Document document;
                Resource resource = resourceLoader.getResource(changeLogs.get(i).getDataModel());
                try (InputStream resourceStream = resource.getInputStream();){
                    document = documentBuilder.parse(resourceStream);
                }
                NodeList childNodes = document.getDocumentElement().getChildNodes();
                IntStream.range(0, childNodes.getLength()).mapToObj(childNodes::item).map(node -> baseDocument.importNode((Node)node, true)).forEach(node -> baseDocumentElement.appendChild((Node)node));
            }
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(baseDocument);
            Path resultPath = Files.createTempFile("cronapp-database-changelog", ".xml", new FileAttribute[0]);
            FileWriter fileWriter = new FileWriter(resultPath.toFile());
            StreamResult result = new StreamResult(fileWriter);
            transformer.transform(source, result);
            liquibase.setChangeLog("application:cronapp-framework.xml");
            liquibase.setMergedChangelogPath(resultPath.toUri().toString());
        }
        return liquibase;
    }

    @Bean
    public CronappChangeLog coreLiquibaseChangelog() {
        return CronappChangeLog.newBuilder().setDataModel("classpath:core-db-changes.xml").build();
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        CronappConfiguration.applicationContext = applicationContext;
    }

    @Bean
    public CacheManager cacheManager() {
        return new ConcurrentMapCacheManager();
    }
}

