package cronapi.workflow.support;

import cronapi.workflow.support.callback.TaskCallback;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeManager;

public class TaskTemplate {
  public static <T> T executeTaskOperation(TaskCallback<T> action) {
    RuntimeManager manager = Utils.getRuntimeManager();
    RuntimeEngine engine = Utils.getRuntimeEngine(manager);

    T result = action.doInTask(engine.getTaskService());

    manager.disposeRuntimeEngine(engine);

    return result;
  }
}