package cronapi.workflow.support;

import cronapi.workflow.support.callback.SessionCallback;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeManager;

public class SessionTemplate {
  public static final <T> T executeSessionOperation(SessionCallback<T> action) {
    RuntimeManager manager = Utils.getRuntimeManager();
    RuntimeEngine engine = Utils.getRuntimeEngine(manager);

    T result = action.doInSession(engine.getKieSession());

    manager.disposeRuntimeEngine(engine);

    return result;
  }
}