package cronapi.workflow;

import cronapi.CronapiMetaData;
import cronapi.CronapiMetaData.ObjectType;
import cronapi.Var;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.task.model.OrganizationalEntity;
import org.kie.api.task.model.Status;
import org.kie.api.task.model.Task;
import org.kie.api.task.model.TaskSummary;

import java.util.*;
import static cronapi.workflow.support.SessionTemplate.executeSessionOperation;
import static cronapi.workflow.support.TaskTemplate.executeTaskOperation;


@CronapiMetaData(categoryName = "Workflow", categoryTags = {"Workflow", "Fluxo"})
public class Operations {

  /*KieSession methods*/
  @CronapiMetaData(name = "{{startProcess}}", nameTags = {"startProcess"}, description = "{{functionToStartProcess}}",
      params = {"{{processId}}"}, paramsType = {ObjectType.STRING},
      returnType = ObjectType.OBJECT)
  public static final Var startProcess(Var processId) {
    ProcessInstance processInstance = executeSessionOperation(session -> session.startProcess(processId.getObjectAsString()));
    return Var.valueOf(processInstance);
  }

  @CronapiMetaData(name = "{{startProcessWithParameters}}", nameTags = {"startProcess"},
      description = "{{functionToStartProcessWithParameters}}",
      params = {"{{processId}}", "{{parameters}}"}, paramsType = {ObjectType.STRING, ObjectType.MAP},
      returnType = ObjectType.OBJECT)
  public static final Var startProcess(Var processId, Var parameters) {
    Map<String, Var> mapOfVar = parameters.getObjectAsMap();
    Map<String, Object> parameterMap = new HashMap<>();
    mapOfVar.forEach((key,value) -> {
      switch (value.getType()){
        case INT:
          parameterMap.put(key,value.getObjectAsInt());
          break;
        case LIST:
          parameterMap.put(key,value.getTypedObject(List.class));
          break;
        case DOUBLE:
          parameterMap.put(key,value.getObjectAsDouble());
          break;
        case BOOLEAN:
          parameterMap.put(key,value.getObjectAsBoolean());
          break;
        case STRING:
          parameterMap.put(key,value.getObjectAsString());
          break;
        case DATETIME:
          parameterMap.put(key,value.getObjectAsDateTime());
          break;
        case UNKNOWN:
          parameterMap.put(key,value.getObject());
          break;
      }});
    ProcessInstance processInstance = executeSessionOperation(session -> session.startProcess(processId.getObjectAsString(), parameterMap));
    return Var.valueOf(processInstance);
  }

  @CronapiMetaData(name = "{{createProcessInstance}}", nameTags = {"createProcessInstance"},
      description = "{{functionToCreateProcessInstance}}",
      params = {"{{processId}}", "{{parameters}}"}, paramsType = {ObjectType.STRING, ObjectType.MAP},
      returnType = ObjectType.OBJECT)
  public static final Var createProcessInstance(Var processId,Var parameters) {
    Map<String, Var> mapOfVar = parameters.getObjectAsMap();
    Map<String, Object> parameterMap = new HashMap<>();
    mapOfVar.forEach((key,value) -> {
        switch (value.getType()){
          case INT:
            parameterMap.put(key,value.getObjectAsInt());
            break;
          case LIST:
            parameterMap.put(key,value.getTypedObject(List.class));
            break;
          case DOUBLE:
            parameterMap.put(key,value.getObjectAsDouble());
            break;
          case BOOLEAN:
            parameterMap.put(key,value.getObjectAsBoolean());
            break;
          case STRING:
            parameterMap.put(key,value.getObjectAsString());
            break;
          case DATETIME:
            parameterMap.put(key,value.getObjectAsDateTime());
            break;
          case UNKNOWN:
            parameterMap.put(key,value.getObject());
            break;
        }});
    ProcessInstance processInstance = executeSessionOperation(session -> session.createProcessInstance(processId.getObjectAsString(), parameterMap));
    return Var.valueOf(processInstance);
  }

  @CronapiMetaData(name = "{{startProcessInstance}}", nameTags = {"startProcessInstance"},
      description = "{{functionToStartProcessInstance}}",
      params = {"{{processId}}"}, paramsType = {ObjectType.LONG},
      returnType = ObjectType.OBJECT)
  public static final Var startProcessInstance(Var processInstanceId) {
    ProcessInstance processInstance = executeSessionOperation(session -> session.startProcessInstance(processInstanceId.getObjectAsLong()));
    return Var.valueOf(processInstance);
  }

  @CronapiMetaData(name = "{{signalEvent}}", nameTags = {"signalEvent"}, description = "{{functionToSignalEvent}}",
      params = {"{{type}}", "{{event}}"}, paramsType = {ObjectType.STRING, ObjectType.OBJECT})
  public static final void signalEvent(Var type, Var event) {
    executeSessionOperation(session -> {
      session.signalEvent(type.getObjectAsString(), event.getObject());
      return Void.TYPE;
    });
  }

  @CronapiMetaData(name = "{{signalProcessInstanceEvent}}", nameTags = {"signalEvent"},
      description = "{{functionToSignalProcessInstanceEvent}}",
      params = {"{{type}}", "{{event}}", "{{processInstanceId}}"},
      paramsType = {ObjectType.STRING, ObjectType.OBJECT, ObjectType.LONG})
  public static final void signalEvent(Var type, Var event, Var processInstanceId) {
    executeSessionOperation(session -> {
      session.signalEvent(type.getObjectAsString(), event.getObject(), processInstanceId.getObjectAsLong());
      return Void.TYPE;
    });
  }

  @CronapiMetaData(name = "{{getProcessInstances}}", nameTags = {"getProcessInstances"},
      description = "{{functionToGetProcessInstances}}", returnType = ObjectType.LIST)
  public static final Var getProcessInstances() {
    Collection<ProcessInstance> processInstances = executeSessionOperation(KieSession::getProcessInstances);
    return Var.valueOf(processInstances);
  }

  @CronapiMetaData(name = "{{getProcessInstance}}", nameTags = {"getProcessInstance"},
      description = "{{functionToGetProcessInstance}}",
      params = {"{{processInstanceId}}"}, paramsType = {ObjectType.LONG}, returnType = ObjectType.OBJECT)
  public static final Var getProcessInstance(Var processInstanceId) {
    ProcessInstance processInstance = executeSessionOperation(session -> session.getProcessInstance(processInstanceId.getObjectAsLong()));
    return Var.valueOf(processInstance);
  }

  @CronapiMetaData(name = "{{getReadOnlyProcessInstance}}", nameTags = {"getProcessInstance"},
      description = "{{functionToGetReadOnlyProcessInstance}}",
      params = {"{{processInstanceId}}", "{{readonly}}"}, paramsType = {ObjectType.LONG, ObjectType.BOOLEAN},
      returnType = ObjectType.OBJECT)
  public static final Var getProcessInstance(Var processInstanceId, Var readonly) {
    ProcessInstance processInstance = executeSessionOperation(session -> session.getProcessInstance(processInstanceId.getObjectAsLong(), readonly.getObjectAsBoolean()));
    return Var.valueOf(processInstance);
  }

  @CronapiMetaData(name = "{{abortProcessInstance}}", nameTags = {"abortProcessInstance"},
      description = "{{functionToAbortProcessInstance}}",
      params = {"{{processInstanceId}}"}, paramsType = {ObjectType.LONG})
  public static final void abortProcessInstance(Var processInstanceId) {
    executeSessionOperation(session -> {
      session.abortProcessInstance(processInstanceId.getObjectAsLong());
      return Void.TYPE;
    });
  }

  /*TaskService methods*/
  @CronapiMetaData(name = "{{activate}}", nameTags = {"activate"}, description = "{{functionToActivateTask}}",
      params = {"{{taskId}}", "{{userId}}"}, paramsType = {ObjectType.LONG, ObjectType.STRING},
      returnType = ObjectType.VOID)
  public static final void activate(Var taskId, Var userId) {
    executeTaskOperation(taskService -> {
      taskService.activate(taskId.getObjectAsLong(), userId.getObjectAsString());
      return Void.TYPE;
    });
  }

  @CronapiMetaData(name = "{{claim}}", nameTags = {"claim"}, description = "{{functionToClaimTask}}",
      params = {"{{taskId}}", "{{userId}}"}, paramsType = {ObjectType.LONG, ObjectType.STRING},
      returnType = ObjectType.VOID)
  public static final void claim(Var taskId, Var userId) {
    executeTaskOperation(taskService -> {
      taskService.claim(taskId.getObjectAsLong(), userId.getObjectAsString());
      return Void.TYPE;
    });
  }

  @CronapiMetaData(name = "{{claimNextAvailable}}", nameTags = {"claimNextAvailable"},
      description = "{{functionToClaimNextAvailable}}",
      params = {"{{userId}}", "{{language}}"}, paramsType = {ObjectType.STRING, ObjectType.STRING},
      returnType = ObjectType.VOID)
  public static final void claimNextAvailable(Var userId, Var language) {
    executeTaskOperation(taskService -> {
      taskService.claimNextAvailable(userId.getObjectAsString(), language.getObjectAsString());
      return Void.TYPE;
    });
  }

  @CronapiMetaData(name = "{{complete}}", nameTags = {"complete"}, description = "{{functionToComplete}}",
      params = {"{{taskId}}", "{{userId}}", "{{data}}"}, paramsType = {ObjectType.LONG, ObjectType.STRING, ObjectType.MAP},
      returnType = ObjectType.VOID)
  public static final void complete(Var taskId, Var userId, Var data) {
    executeTaskOperation(taskService -> {
      Map<String, Var> mapOfVar = data.getObjectAsMap();
      Map<String, Object> dataMap = new HashMap<>();
      mapOfVar.forEach((key,value) -> {
        switch (value.getType()){
          case INT:
            dataMap.put(key,value.getObjectAsInt());
            break;
          case LIST:
            dataMap.put(key,value.getTypedObject(List.class));
            break;
          case DOUBLE:
            dataMap.put(key,value.getObjectAsDouble());
            break;
          case BOOLEAN:
            dataMap.put(key,value.getObjectAsBoolean());
            break;
          case STRING:
            dataMap.put(key,value.getObjectAsString());
            break;
          case DATETIME:
            dataMap.put(key,value.getObjectAsDateTime());
            break;
          case UNKNOWN:
            dataMap.put(key,value.getObject());
            break;
        }});
      taskService.complete(taskId.getObjectAsLong(), userId.getObjectAsString(), dataMap);
      return Void.TYPE;
    });
  }

  @CronapiMetaData(name = "{{delegate}}", nameTags = {"delegate"}, description = "{{functionToDelegate}}",
      params = {"{{taskId}}", "{{userId}}", "{{targetUserId}}"}, paramsType = {ObjectType.LONG, ObjectType.STRING, ObjectType.STRING},
      returnType = ObjectType.VOID)
  public static final void delegate(Var taskId, Var userId, Var targetUserId) {
    executeTaskOperation(taskService -> {
      taskService.delegate(taskId.getObjectAsLong(), userId.getObjectAsString(), targetUserId.getObjectAsString());
      return Void.TYPE;
    });
  }

  @CronapiMetaData(name = "{{exit}}", nameTags = {"exit"}, description = "{{functionToExit}}",
      params = {"{{taskId}}", "{{userId}}"}, paramsType = {ObjectType.LONG, ObjectType.STRING},
      returnType = ObjectType.VOID)
  public static final void exit(Var taskId, Var userId) {
    executeTaskOperation(taskService -> {
      taskService.exit(taskId.getObjectAsLong(), userId.getObjectAsString());
      return Void.TYPE;
    });
  }

  @CronapiMetaData(name = "{{fail}}", nameTags = {"fail"}, description = "{{functionToFail}}",
      params = {"{{taskId}}", "{{userId}}", "{{faultData}}"}, paramsType = {ObjectType.LONG, ObjectType.STRING, ObjectType.MAP},
      returnType = ObjectType.VOID)
  public static final void fail(Var taskId, Var userId, Var faultData) {
    Map<String, Var> mapOfVar = faultData.getObjectAsMap();
    Map<String, Object> faultDataMap = new HashMap<>();
    mapOfVar.forEach((key,value) -> {
      switch (value.getType()){
        case INT:
          faultDataMap.put(key,value.getObjectAsInt());
          break;
        case LIST:
          faultDataMap.put(key,value.getTypedObject(List.class));
          break;
        case DOUBLE:
          faultDataMap.put(key,value.getObjectAsDouble());
          break;
        case BOOLEAN:
          faultDataMap.put(key,value.getObjectAsBoolean());
          break;
        case STRING:
          faultDataMap.put(key,value.getObjectAsString());
          break;
        case DATETIME:
          faultDataMap.put(key,value.getObjectAsDateTime());
          break;
        case UNKNOWN:
          faultDataMap.put(key,value.getObject());
          break;
      }});
    executeTaskOperation(taskService -> {
      taskService.fail(taskId.getObjectAsLong(), userId.getObjectAsString(), faultDataMap);
      return Void.TYPE;
    });
  }

  @CronapiMetaData(name = "{{forward}}", nameTags = {"forward"}, description = "{{functionToForward}}",
      params = {"{{taskId}}", "{{userId}}", "{{targetEntityId}}"}, paramsType = {ObjectType.LONG, ObjectType.STRING, ObjectType.STRING},
      returnType = ObjectType.VOID)
  public static final void forward(Var taskId, Var userId, Var targetEntityId) {
    executeTaskOperation(taskService -> {
      taskService.forward(taskId.getObjectAsLong(), userId.getObjectAsString(), targetEntityId.getObjectAsString());
      return Void.TYPE;
    });
  }

  @CronapiMetaData(name = "{{getTaskByWorkItemId}}", nameTags = {"getTaskByWorkItemId"},
      description = "{{functionToGetTaskByWorkItemId}}", params = {"{{workItemId}}"}, paramsType = {ObjectType.LONG},
      returnType = ObjectType.OBJECT)
  public static final Var getTaskByWorkItemId(Var workItemId) {
    Task task = executeTaskOperation(taskService -> taskService.getTaskByWorkItemId(workItemId.getObjectAsLong()));
    return new Var(task);
  }

  @CronapiMetaData(name = "{{getTaskById}}", nameTags = {"getTaskById"},
      description = "{{functionToGetTaskById}}", params = {"{{taskId}}"}, paramsType = {ObjectType.LONG},
      returnType = ObjectType.OBJECT)
  public static final Var getTaskById(Var taskId) {
    Task task = executeTaskOperation(taskService -> taskService.getTaskById(taskId.getObjectAsLong()));
    return new Var(task);
  }

  @CronapiMetaData(name = "{{getTasksAssignedAsBusinessAdministrator}}", nameTags = {"getTasksAssignedAsBusinessAdministrator"},
      description = "{{functionToGetTasksAssignedAsBusinessAdministrator}}", params = {"{{userId}}", "{{language}}"},
      paramsType = {ObjectType.LONG, ObjectType.STRING}, returnType = ObjectType.LIST)
  public static final Var getTasksAssignedAsBusinessAdministrator(Var userId, Var language) {
    List<TaskSummary> taskSummaries = executeTaskOperation(taskService -> taskService.getTasksAssignedAsBusinessAdministrator(userId.getObjectAsString(), language.getObjectAsString()));
    return new Var(taskSummaries);
  }

  @CronapiMetaData(name = "{{getTasksAssignedAsPotentialOwner}}", nameTags = {"getTasksAssignedAsPotentialOwner"},
      description = "{{functionToGetTasksAssignedAsPotentialOwner}}", params = {"{{userId}}", "{{language}}"},
      paramsType = {ObjectType.LONG, ObjectType.STRING}, returnType = ObjectType.LIST)
  public static final Var getTasksAssignedAsPotentialOwner(Var userId, Var language) {
    List<TaskSummary> taskSummaries = executeTaskOperation(taskService -> taskService.getTasksAssignedAsPotentialOwner(userId.getObjectAsString(), language.getObjectAsString()));
    return new Var(taskSummaries);
  }

  @CronapiMetaData(name = "{{getTasksAssignedAsPotentialOwnerByStatus}}", nameTags = {"getTasksAssignedAsPotentialOwnerByStatus"},
      description = "{{functionToGetTasksAssignedAsPotentialOwnerByStatus}}", params = {"{{userId}}", "{{status}}", "{{language}}"},
      paramsType = {ObjectType.LONG, ObjectType.LIST, ObjectType.STRING}, returnType = ObjectType.LIST)
  public static final Var getTasksAssignedAsPotentialOwnerByStatus(Var userId, Var status, Var language) {
      List<Status> statusList = new LinkedList<>();
      for(int i=0; i< status.getObjectAsList().size(); i++){
          statusList.add(status.getObjectAsList().get(i).getTypedObject(Status.class));
      }
    List<TaskSummary> taskSummaries = executeTaskOperation(taskService -> taskService.getTasksAssignedAsPotentialOwnerByStatus(userId.getObjectAsString(), statusList, language.getObjectAsString()));
    return new Var(taskSummaries);
  }

  @CronapiMetaData(name = "{{getTasksOwned}}", nameTags = {"getTasksOwned"},
      description = "{{functionToGetTasksOwned}}", params = {"{{userId}}", "{{language}}"},
      paramsType = {ObjectType.LONG, ObjectType.STRING}, returnType = ObjectType.LIST)
  public static final Var getTasksOwned(Var userId, Var language) {
    List<TaskSummary> taskSummaries = executeTaskOperation(taskService -> taskService.getTasksOwned(userId.getObjectAsString(), language.getObjectAsString()));
    return new Var(taskSummaries);
  }

  @CronapiMetaData(name = "{{getTasksOwnedByStatus}}", nameTags = {"getTasksOwnedByStatus"},
      description = "{{functionToGetTasksOwnedByStatus}}", params = {"{{userId}}", "{{status}}", "{{language}}"},
      paramsType = {ObjectType.LONG, ObjectType.LIST, ObjectType.STRING}, returnType = ObjectType.LIST)
  public static final Var getTasksOwnedByStatus(Var userId, Var status, Var language) {
      List<Status> statusList = new LinkedList<>();
      for(int i=0; i< status.getObjectAsList().size(); i++){
          statusList.add(status.getObjectAsList().get(i).getTypedObject(Status.class));
      }
    List<TaskSummary> taskSummaries = executeTaskOperation(taskService -> taskService.getTasksOwnedByStatus(userId.getObjectAsString(), statusList, language.getObjectAsString()));
    return new Var(taskSummaries);
  }

  @CronapiMetaData(name = "{{getTasksByStatusByProcessInstanceId}}", nameTags = {"getTasksByStatusByProcessInstanceId"},
      description = "{{functionToGetTasksByStatusByProcessInstanceId}}", params = {"{{processInstanceId}}", "{{status}}", "{{language}}"},
      paramsType = {ObjectType.LONG, ObjectType.LIST, ObjectType.STRING}, returnType = ObjectType.LIST)
  public static final Var getTasksByStatusByProcessInstanceId(Var processInstanceId, Var status, Var language) {
      List<Status> statusList = new LinkedList<>();
      for(int i=0; i< status.getObjectAsList().size(); i++){
          statusList.add(status.getObjectAsList().get(i).getTypedObject(Status.class));
      }
    List<TaskSummary> taskSummaries = executeTaskOperation(taskService -> taskService.getTasksByStatusByProcessInstanceId(processInstanceId.getObjectAsLong(), statusList, language.getObjectAsString()));
    return new Var(taskSummaries);
  }

  @CronapiMetaData(name = "{{getTasksAssignedAsPotentialOwnerByProcessId}}", nameTags = {"getTasksAssignedAsPotentialOwnerByProcessId"},
      description = "{{functionToGetTasksAssignedAsPotentialOwnerByProcessId}}", params = {"{{userId}}", "{{processId}}"},
      paramsType = {ObjectType.LONG, ObjectType.STRING}, returnType = ObjectType.LIST)
  public static final Var getTasksAssignedAsPotentialOwnerByProcessId(Var userId, Var processId) {
    List<TaskSummary> taskSummaries = executeTaskOperation(taskService -> taskService.getTasksAssignedAsPotentialOwnerByProcessId(userId.getObjectAsString(), processId.getObjectAsString()));
    return new Var(taskSummaries);
  }

  @CronapiMetaData(name = "{{getTasksByProcessInstanceId}}", nameTags = {"getTasksByProcessInstanceId"},
      description = "{{functionToGetTasksByProcessInstanceId}}", params = {"{{processInstanceId}}"},
      paramsType = {ObjectType.LONG}, returnType = ObjectType.LIST)
  public static final Var getTasksByProcessInstanceId(Var processInstanceId) {
    List<Long> tasks = executeTaskOperation(taskService -> taskService.getTasksByProcessInstanceId(processInstanceId.getObjectAsLong()));
    return new Var(tasks);
  }

  @CronapiMetaData(name = "{{addTask}}", nameTags = {"addTask"},
      description = "{{functionToAddTask}}", params = {"{{task}}", "{{params}}"},
      paramsType = {ObjectType.OBJECT, ObjectType.MAP}, returnType = ObjectType.LIST)
  public static final Var addTask(Var task, Var params) {
    Map<String, Var> mapOfVar = params.getObjectAsMap();
    Map<String, Object> parameterMap = new HashMap<>();
    mapOfVar.forEach((key,value) -> {
      switch (value.getType()){
        case INT:
          parameterMap.put(key,value.getObjectAsInt());
          break;
        case LIST:
          parameterMap.put(key,value.getTypedObject(List.class));
          break;
        case DOUBLE:
          parameterMap.put(key,value.getObjectAsDouble());
          break;
        case BOOLEAN:
          parameterMap.put(key,value.getObjectAsBoolean());
          break;
        case STRING:
          parameterMap.put(key,value.getObjectAsString());
          break;
        case DATETIME:
          parameterMap.put(key,value.getObjectAsDateTime());
          break;
        case UNKNOWN:
          parameterMap.put(key,value.getObject());
          break;
      }});
    long addedTask = executeTaskOperation(taskService -> taskService.addTask(task.getTypedObject(Task.class), parameterMap));
    return new Var(addedTask);
  }

  @CronapiMetaData(name = "{{release}}", nameTags = {"release"}, description = "{{functionToRelease}}",
      params = {"{{taskId}}", "{{userId}}"}, paramsType = {ObjectType.LONG, ObjectType.STRING},
      returnType = ObjectType.VOID)
  public static final void release(Var taskId, Var userId) {
    executeTaskOperation(taskService -> {
      taskService.release(taskId.getObjectAsLong(), userId.getObjectAsString());
      return Void.TYPE;
    });
  }

  @CronapiMetaData(name = "{{resume}}", nameTags = {"resume"}, description = "{{functionToResume}}",
      params = {"{{taskId}}", "{{userId}}"}, paramsType = {ObjectType.LONG, ObjectType.STRING},
      returnType = ObjectType.VOID)
  public static final void resume(Var taskId, Var userId) {
    executeTaskOperation(taskService -> {
      taskService.resume(taskId.getObjectAsLong(), userId.getObjectAsString());
      return Void.TYPE;
    });
  }

  @CronapiMetaData(name = "{{skip}}", nameTags = {"skip"}, description = "{{functionToSkip}}",
      params = {"{{taskId}}", "{{userId}}"}, paramsType = {ObjectType.LONG, ObjectType.STRING},
      returnType = ObjectType.VOID)
  public static final void skip(Var taskId, Var userId) {
    executeTaskOperation(taskService -> {
      taskService.skip(taskId.getObjectAsLong(), userId.getObjectAsString());
      return Void.TYPE;
    });
  }

  @CronapiMetaData(name = "{{start}}", nameTags = {"start"}, description = "{{functionToStart}}",
      params = {"{{taskId}}", "{{userId}}"}, paramsType = {ObjectType.LONG, ObjectType.STRING},
      returnType = ObjectType.VOID)
  public static final void start(Var taskId, Var userId) {
    executeTaskOperation(taskService -> {
      taskService.start(taskId.getObjectAsLong(), userId.getObjectAsString());
      return Void.TYPE;
    });
  }

  @CronapiMetaData(name = "{{stop}}", nameTags = {"stop"}, description = "{{functionToStop}}",
      params = {"{{taskId}}", "{{userId}}"}, paramsType = {ObjectType.LONG, ObjectType.STRING},
      returnType = ObjectType.VOID)
  public static final void stop(Var taskId, Var userId) {
    executeTaskOperation(taskService -> {
      taskService.stop(taskId.getObjectAsLong(), userId.getObjectAsString());
      return Void.TYPE;
    });
  }

  @CronapiMetaData(name = "{{suspend}}", nameTags = {"suspend"}, description = "{{functionToSuspend}}",
      params = {"{{taskId}}", "{{userId}}"}, paramsType = {ObjectType.LONG, ObjectType.STRING},
      returnType = ObjectType.VOID)
  public static final void suspend(Var taskId, Var userId) {
    executeTaskOperation(taskService -> {
      taskService.suspend(taskId.getObjectAsLong(), userId.getObjectAsString());
      return Void.TYPE;
    });
  }

  @CronapiMetaData(name = "{{nominate}}", nameTags = {"nominate"}, description = "{{functionToNominate}}",
      params = {"{{taskId}}", "{{userId}}", "{{potentialOwners}}"},
      paramsType = {ObjectType.LONG, ObjectType.STRING, ObjectType.MAP}, returnType = ObjectType.VOID)
  public static final void nominate(Var taskId, Var userId, Var potentialOwners) {
    List<OrganizationalEntity> potentialOwnersList = new LinkedList<>();
    for(int i=0; i< potentialOwners.getObjectAsList().size(); i++){
      potentialOwnersList.add(potentialOwners.getObjectAsList().get(i).getTypedObject(OrganizationalEntity.class));
    }
    executeTaskOperation(taskService -> {
      taskService.nominate(taskId.getObjectAsLong(), userId.getObjectAsString(), potentialOwnersList);
      return Void.TYPE;
    });
  }

  @CronapiMetaData(name = "{{setExpirationDate}}", nameTags = {"setExpirationDate"},
      description = "{{functionToSetExpirationDate}}",
      params = {"{{taskId}}", "{{date}}"}, paramsType = {ObjectType.LONG, ObjectType.DATETIME},
      returnType = ObjectType.VOID)
  public static final void setExpirationDate(Var taskId, Var date) {
    executeTaskOperation(taskService -> {
      taskService.setExpirationDate(taskId.getObjectAsLong(), date.getTypedObject(Date.class));
      return Void.TYPE;
    });
  }
}