package cronapi.qrcode;

import java.io.ByteArrayOutputStream;
import java.util.UUID;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.Writer;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;

import cronapi.CronapiMetaData;
import cronapi.ParamMetaData;
import cronapi.Var;
import cronapi.CronapiMetaData.ObjectType;
import cronapi.io.Operations;

public final class QRCode {

  @CronapiMetaData(type = "function", name = "{{generateQRCode}}",
	description = "{{generateQRCodeDescription}}", returnType = ObjectType.VOID)
	public static void gerarQRCode(
		@ParamMetaData(type = ObjectType.STRING, description = "{{contentQRCode}}") Var content,
		@ParamMetaData(type = ObjectType.STRING, description = "{{formatImageQRCode}}", 
		blockType = "util_dropdown", keys = {"PNG", "JPG"}) Var format,
		@ParamMetaData(type = ObjectType.LONG, description = "{{widthImageQRCode}}") Var width,
		@ParamMetaData(type = ObjectType.LONG, description = "{{heightImageQRCode}}") Var height
		) throws Exception {
		
		String conteudo = content.getObjectAsString();
		String formato = format.getObjectAsString();
		Integer largura = width.getObjectAsInt();
		Integer altura = height.getObjectAsInt();

		final Writer w = new QRCodeWriter();

    ByteArrayOutputStream bos = new ByteArrayOutputStream();
		
		final BitMatrix matrix = w.encode(conteudo, BarcodeFormat.QR_CODE, largura, altura);		
    MatrixToImageWriter.writeToStream(matrix, formato, bos);

		bos.close();

		UUID uuid = UUID.randomUUID();
		Var nome = new Var(uuid.toString().substring(0, 6).concat(".").concat(formato.toLowerCase()));

		Operations.startDownload(new Var(bos.toByteArray()), nome);
  }
  
}
