/*
 * Decompiled with CFR 0.152.
 */
package cronapi.database;

import cronapi.CronapiMetaData;
import cronapi.ParamMetaData;
import cronapi.RestClient;
import cronapi.Var;
import cronapi.database.DataSource;
import cronapi.database.TransactionManager;
import cronapi.odata.server.JPQLParserUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.ParameterMode;
import javax.persistence.Persistence;
import javax.persistence.Query;
import javax.persistence.StoredProcedureQuery;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.PageRequest;

@CronapiMetaData(category=CronapiMetaData.CategoryType.DATABASE, categoryTags={"Database", "Banco", "Dados", "Storage"})
public class Operations {
    @CronapiMetaData(name="{{datasourceQuery}}", nameTags={"datasourceQuery", "openConnection", "abrirConsulta"}, description="{{functionToQueryInDatasource}}", params={"{{entity}}", "{{query}}", "{{paramsQueryTuples}}"}, paramsType={CronapiMetaData.ObjectType.STRING, CronapiMetaData.ObjectType.STRING, CronapiMetaData.ObjectType.LIST}, returnType=CronapiMetaData.ObjectType.DATASET, arbitraryParams=true, wizard="procedures_sql_callreturn")
    public static Var query(Var entity, Var query, Var ... params) {
        DataSource ds = new DataSource(entity.getObjectAsString());
        if (query == Var.VAR_NULL) {
            ds.fetch();
        } else {
            ds.filter(query.getObjectAsString(), params);
        }
        return new Var(ds);
    }

    public static Var queryPaged(Var entity, Var query, Var useRequestData, Var ... params) {
        DataSource ds = new DataSource(entity.getObjectAsString());
        String limit = null;
        String offset = null;
        LinkedList<Var> finalParams = new LinkedList<Var>();
        block8: for (Var param : params) {
            switch (param.getId()) {
                case "limit": {
                    limit = param.getObjectAsString();
                    continue block8;
                }
                case "offset": {
                    offset = param.getObjectAsString();
                    continue block8;
                }
                default: {
                    finalParams.add(param);
                }
            }
        }
        int pageNumber = 0;
        int pageSize = 100;
        if (offset != null) {
            pageNumber = Integer.parseInt(offset);
            ds.setUseOffset(true);
        }
        if (limit != null) {
            pageSize = Integer.parseInt(limit);
        }
        PageRequest page = PageRequest.of((int)pageNumber, (int)pageSize);
        if (useRequestData.getObjectAsBoolean().booleanValue()) {
            String pageSizeFromRequest;
            String[] splitedQueryString;
            String queryString;
            if (query != Var.VAR_NULL && (queryString = RestClient.getRestClient().getRequest().getServletPath()).contains("/api/cronapi/query/") && (splitedQueryString = (queryString = queryString.replace("/api/cronapi/query/", "")).split("/")).length > 1) {
                for (int ix = 1; ix < splitedQueryString.length; ++ix) {
                    Var param = Var.valueOf("id" + (ix - 1), splitedQueryString[ix]);
                    finalParams.add(param);
                }
            }
            String pageFromRequest = RestClient.getRestClient().getRequest().getParameter("page");
            boolean isODataParam = StringUtils.isNotEmpty((CharSequence)RestClient.getRestClient().getRequest().getParameter("$skip"));
            if (StringUtils.isEmpty((CharSequence)pageFromRequest) && StringUtils.isEmpty((CharSequence)(pageFromRequest = RestClient.getRestClient().getRequest().getParameter("$skip")))) {
                pageFromRequest = "0";
            }
            if (StringUtils.isEmpty((CharSequence)(pageSizeFromRequest = RestClient.getRestClient().getRequest().getParameter("size"))) && StringUtils.isEmpty((CharSequence)(pageSizeFromRequest = RestClient.getRestClient().getRequest().getParameter("$top")))) {
                pageSizeFromRequest = "100";
            }
            if (isODataParam) {
                pageFromRequest = pageFromRequest.equals("0") ? "0" : String.valueOf(Integer.parseInt(pageSizeFromRequest) / Integer.parseInt(pageFromRequest));
            }
            page = PageRequest.of((int)pageNumber, (int)pageSize);
        }
        ds.setUseOdataRequest(useRequestData.getObjectAsBoolean());
        if (query == Var.VAR_NULL) {
            ds.fetch();
        } else {
            ds.filter(query.getObjectAsString(), page, finalParams.toArray(new Var[0]));
        }
        ds.alowFetchNext(false);
        return new Var(ds);
    }

    @CronapiMetaData(type="function", name="{{datasourceNext}}", nameTags={"next", "avan\u00e7ar", "proximo"}, description="{{functionToMoveCursorToNextPosition}}", params={"{{datasource}}"}, paramsType={CronapiMetaData.ObjectType.DATASET}, returnType=CronapiMetaData.ObjectType.VOID, displayInline=true)
    public static void next(Var ds) {
        ((DataSource)ds.getObject()).next();
    }

    @CronapiMetaData(type="function", name="{{datasourceHasData}}", nameTags={"hasElement", "existeRegistro", "temRegistro"}, description="{{functionToVerifyDataInCurrentPosition}}", params={"{{datasource}}"}, paramsType={CronapiMetaData.ObjectType.DATASET}, returnType=CronapiMetaData.ObjectType.BOOLEAN, displayInline=true)
    public static Var hasElement(Var ds) {
        if (ds.getObject() != null) {
            return Var.valueOf(((DataSource)ds.getObject()).getObject() != null);
        }
        return Var.VAR_FALSE;
    }

    @CronapiMetaData(type="function", name="{{datasourceClose}}", nameTags={"close", "fechar", "limpar", "clear"}, description="{{functionToCloseAndCleanDatasource}}", params={"{{datasource}}"}, paramsType={CronapiMetaData.ObjectType.DATASET}, returnType=CronapiMetaData.ObjectType.VOID, displayInline=true)
    public static void close(Var ds) {
        ((DataSource)ds.getObject()).clear();
    }

    @CronapiMetaData(type="function", name="{{datasourceUpdateField}}", nameTags={"updateField", "atualizarCampo", "setField", "modificarCampo"}, description="{{functionToUpdateFieldInDatasource}}", params={"{{datasource}}", "{{fieldName}}", "{{fieldValue}}"}, paramsType={CronapiMetaData.ObjectType.DATASET, CronapiMetaData.ObjectType.STRING, CronapiMetaData.ObjectType.STRING}, returnType=CronapiMetaData.ObjectType.VOID)
    public static void updateField(Var ds, Var fieldName, Var fieldValue) {
        ds.setField(fieldName.getObjectAsString(), fieldValue);
    }

    @CronapiMetaData(type="function", name="{{datasourceGetActiveData}}", nameTags={"getElement", "obterElemento"}, description="{{functionToDatasourceGetActiveData}}", params={"{{datasource}}"}, paramsType={CronapiMetaData.ObjectType.DATASET}, returnType=CronapiMetaData.ObjectType.OBJECT)
    public static Var getActiveData(Var ds) {
        return new Var(((DataSource)ds.getObject()).getObject());
    }

    @CronapiMetaData(type="function", name="{{datasourceInsert}}", nameTags={"insert", "create", "novo", "inserir", "criar"}, description="{{functionToInsertObjectInDatasource}}", params={"{{datasource}}", "{{params}}"}, paramsType={CronapiMetaData.ObjectType.DATASET, CronapiMetaData.ObjectType.LIST}, returnType=CronapiMetaData.ObjectType.VOID, arbitraryParams=true, wizard="procedures_sql_insert_callreturn")
    public static Var insert(Var entity, Var ... params) {
        DataSource ds = new DataSource(entity.getObjectAsString());
        ds.insert();
        ds.updateFields(params);
        return Var.valueOf(ds.save(true, false));
    }

    public static Var insert(Var entity, Var object) {
        if (!object.equals(Var.VAR_NULL)) {
            DataSource ds = new DataSource(entity.getObjectAsString());
            ds.insert(object.getObjectAsMap());
            Object saved = ds.save();
            object.updateWith(saved);
        }
        return object;
    }

    @CronapiMetaData(type="function", name="{{update}}", nameTags={"update", "edit", "editar", "alterar"}, description="{{functionToUpdateObjectInDatasource}}", params={"{{datasource}}", "{{entity}}"}, paramsType={CronapiMetaData.ObjectType.DATASET, CronapiMetaData.ObjectType.OBJECT}, returnType=CronapiMetaData.ObjectType.VOID, arbitraryParams=true, wizard="procedures_sql_update_callnoreturn")
    public static void update(Var entity, Var object) {
        if (!object.equals(Var.VAR_NULL)) {
            DataSource ds = new DataSource(entity.getObjectAsString());
            ds.filter(object, null);
            ds.update(new Var(object.getObjectAsMap()));
            Object saved = ds.save();
            object.updateWith(saved);
        }
    }

    @CronapiMetaData(type="function", name="{{datasourceRemove}}", nameTags={"remove", "delete", "remover", "deletar", "excluir"}, description="{{functionToRemoveObject}}", params={"{{datasource}}", "{{entity}}"}, paramsType={CronapiMetaData.ObjectType.DATASET, CronapiMetaData.ObjectType.OBJECT}, returnType=CronapiMetaData.ObjectType.VOID, arbitraryParams=true, wizard="procedures_sql_delete_callnoreturn")
    public static void remove(Var entity, Var object) {
        if (!object.equals(Var.VAR_NULL)) {
            DataSource ds = new DataSource(entity.getObjectAsString());
            ds.filter(object, null);
            ds.delete();
        }
    }

    @CronapiMetaData(type="function", name="{{datasourceGetField}}", nameTags={"getField", "obterCampo"}, description="{{functionToGetFieldOfCurrentCursorInDatasource}}", params={"{{datasource}}", "{{fieldName}}"}, paramsType={CronapiMetaData.ObjectType.DATASET, CronapiMetaData.ObjectType.STRING}, returnType=CronapiMetaData.ObjectType.OBJECT, wizard="procedures_get_field")
    public static Var getField(@ParamMetaData(blockType="variables_get", type=CronapiMetaData.ObjectType.OBJECT, description="{{datasource}}") Var ds, @ParamMetaData(blockType="procedures_get_field_datasource", type=CronapiMetaData.ObjectType.STRING, description="{{fieldName}}") Var fieldName) {
        return ds.getField(fieldName.getObjectAsString());
    }

    @CronapiMetaData(type="function", name="{{datasourceGetField}}", nameTags={"getField", "obterCampo"}, description="{{functionToGetFieldOfCurrentCursorInDatasource}}", returnType=CronapiMetaData.ObjectType.STRING, wizard="procedures_get_field_datasource")
    public static Var getFieldFromDatasource() {
        return Var.VAR_NULL;
    }

    @CronapiMetaData(type="function", name="{{datasourceRemove}}", nameTags={"remove", "delete", "apagar", "remover"}, description="{{functionToRemoveObjectInDatasource}}", params={"{{datasource}}"}, paramsType={CronapiMetaData.ObjectType.DATASET}, returnType=CronapiMetaData.ObjectType.VOID, displayInline=true)
    public static void remove(Var ds) {
        ((DataSource)ds.getObject()).delete();
    }

    @CronapiMetaData(type="function", name="{{datasourceExecuteQuery}}", nameTags={"datasourceExecuteQuery", "executeCommand", "executarComando"}, description="{{functionToExecuteQuery}}", params={"{{entity}}", "{{query}}", "{{paramsQueryTuples}}"}, paramsType={CronapiMetaData.ObjectType.STRING, CronapiMetaData.ObjectType.STRING, CronapiMetaData.ObjectType.LIST}, returnType=CronapiMetaData.ObjectType.DATASET, arbitraryParams=true, wizard="procedures_sql_command_callnoreturn")
    public static Var execute(Var entity, Var query, Var ... params) {
        DataSource ds = new DataSource(entity.getObjectAsString());
        return ds.execute(query.getObjectAsString(), params);
    }

    @CronapiMetaData(type="function", name="{{newEntity}}", nameTags={"newEntity", "NovaEntidade"}, description="{{newEntityDescription}}", params={"{{entity}}", "{{params}}"}, paramsType={CronapiMetaData.ObjectType.STRING, CronapiMetaData.ObjectType.MAP}, returnType=CronapiMetaData.ObjectType.OBJECT, arbitraryParams=true, wizard="procedures_createnewobject_callreturn")
    public static final Var newEntity(Var object, Var ... params) throws Exception {
        return cronapi.object.Operations.newObject(object, params);
    }

    @CronapiMetaData(type="function", name="{{datasourceExecuteJQPLQuery}}", nameTags={"datasourceQuery", "openConnection", "abrirConsulta"}, description="{{functionToQueryInDatasource}}", params={"{{entity}}", "{{query}}", "{{paramsQueryTuples}}"}, paramsType={CronapiMetaData.ObjectType.STRING, CronapiMetaData.ObjectType.STRING, CronapiMetaData.ObjectType.MAP}, returnType=CronapiMetaData.ObjectType.DATASET)
    public static Var executeQuery(Var entity, Var query, Var params) {
        Map map = params.getObjectAsMap();
        Var[] vars = new Var[map.size()];
        int i = 0;
        for (Map.Entry entry : map.entrySet()) {
            vars[i] = new Var((String)entry.getKey(), entry.getValue());
            ++i;
        }
        return Operations.query(entity, query, vars);
    }

    @CronapiMetaData(type="function", name="{{datasourceGetColumnName}}", nameTags={"GetColumn", "obterColuna", "datasource", "dados"}, description="{{datasourceGetColumnDescription}}", params={"{{datasource}}", "{{fieldName}}"}, paramsType={CronapiMetaData.ObjectType.DATASET, CronapiMetaData.ObjectType.STRING}, returnType=CronapiMetaData.ObjectType.OBJECT, wizard="procedures_get_field")
    public static Var getColumn(@ParamMetaData(blockType="variables_get", type=CronapiMetaData.ObjectType.OBJECT, description="{{datasource}}") Var ds, @ParamMetaData(blockType="procedures_get_field_datasource", type=CronapiMetaData.ObjectType.STRING, description="{{fieldName}}") Var fieldName) {
        Object obj = ds.getObject();
        LinkedList<Var> dst = new LinkedList<Var>();
        if (obj instanceof DataSource) {
            DataSource datasource = (DataSource)obj;
            while (datasource.hasNext()) {
                dst.add(ds.getField(fieldName.getObjectAsString()));
                datasource.next();
            }
            dst.add(ds.getField(fieldName.getObjectAsString()));
            datasource.setCurrent(0);
            return Var.valueOf(dst);
        }
        return Var.valueOf(dst);
    }

    @CronapiMetaData(type="function", name="{{commitTransaction}}", nameTags={"commitTransaction", "commitTransa\u00e7\u00e3o"}, description="{{commitTransactionDescription}}", params={"{{entity}}"}, paramsType={CronapiMetaData.ObjectType.STRING}, returnType=CronapiMetaData.ObjectType.VOID, wizard="procedures_setentity_callnoreturn")
    public static final void commitTransaction(Var object) throws Exception {
        if (!object.equals(Var.VAR_NULL)) {
            String className = object.getObjectAsString();
            if (className.contains(".entity.")) {
                Class<?> c = Class.forName(className);
                TransactionManager.commit(c);
            } else {
                TransactionManager.commit(className);
            }
        }
    }

    @CronapiMetaData(type="function", name="{{rollbackTransaction}}", nameTags={"rollbackTransaction", "rollbackTransa\u00e7\u00e3o"}, description="{{rollbackTransactionDescription}}", params={"{{entity}}"}, paramsType={CronapiMetaData.ObjectType.STRING}, returnType=CronapiMetaData.ObjectType.VOID, wizard="procedures_setentity_callnoreturn")
    public static final void rollbackTransaction(Var object) throws Exception {
        if (!object.equals(Var.VAR_NULL)) {
            String className = object.getObjectAsString();
            if (className.contains(".entity.")) {
                Class<?> c = Class.forName(className);
                TransactionManager.rollback(c);
            } else {
                TransactionManager.rollback(className);
            }
        }
    }

    @CronapiMetaData(type="function", name="{{flushTransaction}}", nameTags={"flushTransaction", "flushTransa\u00e7\u00e3o"}, description="{{flushTransactionDescription}}", params={"{{entity}}"}, paramsType={CronapiMetaData.ObjectType.STRING}, returnType=CronapiMetaData.ObjectType.VOID, wizard="procedures_setentity_callnoreturn")
    public static final void flushTransaction(Var object) throws Exception {
        if (!object.equals(Var.VAR_NULL)) {
            String className = object.getObjectAsString();
            if (className.contains(".entity.")) {
                Class<?> c = Class.forName(className);
                TransactionManager.flush(c);
            } else {
                TransactionManager.flush(className);
            }
        }
    }

    @CronapiMetaData(type="function", name="{{beginTransaction}}", nameTags={"beginTransaction", "iniciarTransa\u00e7\u00e3o"}, description="{{beginTransaction}}", params={"{{entity}}"}, paramsType={CronapiMetaData.ObjectType.STRING}, returnType=CronapiMetaData.ObjectType.VOID, wizard="procedures_setentity_callnoreturn")
    public static final void beginTransaction(Var object) throws Exception {
        if (!object.equals(Var.VAR_NULL)) {
            String className = object.getObjectAsString();
            if (className.contains(".entity.")) {
                Class<?> c = Class.forName(className);
                TransactionManager.begin(c);
            } else {
                TransactionManager.begin(className);
            }
        }
    }

    @CronapiMetaData(name="{{datasourceExecuteNativeQuery}}", nameTags={"datasourceExecuteNativeQuery", "executeNativeQuery", "executarQueryNativa"}, description="{{functionToExecuteNativeQuery}}", params={"{{entity}}", "{{query}}", "{{paramsQueryTuples}}"}, paramsType={CronapiMetaData.ObjectType.STRING, CronapiMetaData.ObjectType.STRING, CronapiMetaData.ObjectType.LIST}, returnType=CronapiMetaData.ObjectType.DATASET, arbitraryParams=true, wizard="procedures_sql_command_callreturn")
    public static Var executeNativeQuery(Var entity, Var query, Var ... params) throws Exception {
        Query nativeQuery = Operations.sanitizeNativeQuery(entity, query, Var.valueOf(false), params);
        return Var.valueOf(nativeQuery.getResultList());
    }

    @CronapiMetaData(name="{{datasourceExecuteNativeQueryUpdate}}", nameTags={"datasourceExecuteNativeQueryUpdate", "executeNativeQueryUpdate", "executarQueryNativaAlteracao"}, description="{{functionToExecuteNativeQueryUpdate}}", params={"{{entity}}", "{{query}}", "{{paramsQueryTuples}}"}, paramsType={CronapiMetaData.ObjectType.STRING, CronapiMetaData.ObjectType.STRING, CronapiMetaData.ObjectType.LIST}, returnType=CronapiMetaData.ObjectType.LONG, arbitraryParams=true, wizard="procedures_sql_command_callreturn")
    public static Var executeNativeQueryUpdate(Var entity, Var query, Var ... params) throws Exception {
        Query nativeQuery = Operations.sanitizeNativeQuery(entity, query, Var.valueOf(true), params);
        return Var.valueOf(nativeQuery.executeUpdate());
    }

    private static Query createNativeQuery(Var entity, Var isModififyQuery, String query) throws Exception {
        Class<?> domainClass = Class.forName(entity.getObjectAsString());
        String namespace = domainClass.getPackage().getName().replace(".entity", "");
        if (!isModififyQuery.getObjectAsBoolean().booleanValue()) {
            EntityManagerFactory factory = Persistence.createEntityManagerFactory((String)namespace);
            EntityManager entityManager = factory.createEntityManager();
            return entityManager.createNativeQuery(query, domainClass);
        }
        EntityManager entityManager = TransactionManager.getEntityManager(domainClass);
        return entityManager.createNativeQuery(query);
    }

    private static Query sanitizeNativeQuery(Var entity, Var query, Var isModififyQuery, Var ... params) throws Exception {
        String replacement = "?";
        String parameterizedQuery = query.getObjectAsString();
        List<String> parsedParams = JPQLParserUtil.parseParams(parameterizedQuery);
        for (String param : parsedParams) {
            parameterizedQuery = parameterizedQuery.replaceFirst(":" + param, replacement);
        }
        Query nativeQuery = Operations.createNativeQuery(entity, isModififyQuery, parameterizedQuery);
        if (params != null && params.length > 0) {
            LinkedHashMap<String, Object> paramsValues = new LinkedHashMap<String, Object>();
            for (Var param : params) {
                paramsValues.put(param.getId(), param.getObject());
            }
            int position = 1;
            for (String param : parsedParams) {
                nativeQuery.setParameter(position, paramsValues.get(param));
                ++position;
            }
        }
        return nativeQuery;
    }

    @CronapiMetaData(type="function", name="{{executeProcedureReturnTable}}", nameTags={"execute", "procedure"}, description="{{executeProcedureReturnTableDescription}}", params={"{{namespace}}", "{{procedureName}}", "{{parameterList}}", "{{returnClass}}"}, paramsType={CronapiMetaData.ObjectType.STRING, CronapiMetaData.ObjectType.STRING, CronapiMetaData.ObjectType.LIST, CronapiMetaData.ObjectType.STRING}, returnType=CronapiMetaData.ObjectType.LIST)
    public static Var executeProcedure(Var namespace, Var storeProcedure, Var param, Var nameClass) throws Exception {
        EntityManagerFactory factory = Persistence.createEntityManagerFactory((String)namespace.getObjectAsString());
        EntityManager em = factory.createEntityManager();
        List values = param.getObjectAsList();
        ArrayList args = new ArrayList();
        values.forEach(c -> args.add("?"));
        String strExecute = String.format("{call %s(%s)}", storeProcedure.getObjectAsString(), String.join((CharSequence)",", args));
        Query query = em.createNativeQuery(strExecute);
        for (int i = 0; i < values.size(); ++i) {
            query.setParameter(i + 1, (Object)((Var)values.get(i)).getObjectAsString());
        }
        List result = query.getResultList();
        ArrayList<Var> returnValues = new ArrayList<Var>();
        if (!nameClass.isEmptyOrNull().booleanValue()) {
            try {
                Class<?> clazz = Class.forName(nameClass.getObjectAsString());
                Field[] fieldArray = clazz.getDeclaredFields();
                for (Object value : result) {
                    Object instance = clazz.newInstance();
                    if (!(value instanceof Object[])) {
                        fieldArray[0].setAccessible(true);
                        fieldArray[0].set(instance, value);
                    } else {
                        for (int i = 0; i < fieldArray.length; ++i) {
                            fieldArray[i].setAccessible(true);
                            fieldArray[i].set(instance, ((Object[])value)[i]);
                        }
                    }
                    returnValues.add(Var.valueOf(instance));
                }
                return Var.valueOf(returnValues);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return Var.valueOf(result);
    }

    @CronapiMetaData(type="function", name="{{executeProcedureWithInOut}}", nameTags={"execute", "procedure"}, description="{{executeProcedureWithInOutDescription}}", params={"{{namespace}}", "{{procedureName}}", "{{parameterMap}}", "{{paramteterListModes}}", "{{paramteterListTypes}}"}, paramsType={CronapiMetaData.ObjectType.STRING, CronapiMetaData.ObjectType.STRING, CronapiMetaData.ObjectType.MAP, CronapiMetaData.ObjectType.LIST, CronapiMetaData.ObjectType.LIST}, returnType=CronapiMetaData.ObjectType.MAP)
    public static Var executeProcedureInOut(Var namespace, Var storeProcedure, Var param, Var paramModes, Var paramTypes) throws Exception {
        String paramModeName;
        String paramName;
        int i;
        LinkedHashMap<String, Object> mapReturn = new LinkedHashMap<String, Object>();
        HashMap<String, ParameterMode> paramModeMap = new HashMap<String, ParameterMode>();
        paramModeMap.put("IN", ParameterMode.IN);
        paramModeMap.put("OUT", ParameterMode.OUT);
        paramModeMap.put("INOUT", ParameterMode.INOUT);
        paramModeMap.put("CURSOR", ParameterMode.REF_CURSOR);
        EntityManagerFactory factory = Persistence.createEntityManagerFactory((String)namespace.getObjectAsString());
        EntityManager em = factory.createEntityManager();
        StoredProcedureQuery sp = em.createStoredProcedureQuery(storeProcedure.getObjectAsString());
        ArrayList keys = new ArrayList(param.getObjectAsMap().keySet());
        List modes = paramModes.getObjectAsList();
        List types = null;
        if (paramTypes != null && !paramTypes.isEmptyOrNull().booleanValue()) {
            types = paramTypes.getObjectAsList();
        }
        String nameClass = "java.lang.String";
        Class<?> clazz = Class.forName(nameClass);
        int posCursor = modes.indexOf(Var.valueOf("CURSOR"));
        Boolean hasOut = modes.indexOf(Var.valueOf("OUT")) > -1 || modes.indexOf(Var.valueOf("INOUT")) > -1;
        Boolean hasCursor = posCursor > -1;
        for (i = 0; i < keys.size(); ++i) {
            paramName = keys.get(i).toString();
            paramModeName = ((Var)modes.get(i)).getObjectAsString();
            ParameterMode paramMode = (ParameterMode)paramModeMap.get(paramModeName);
            if (types != null) {
                nameClass = ((Var)types.get(i)).getObjectAsString();
            } else {
                try {
                    nameClass = param.get(paramName).getClass().getName();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            clazz = Class.forName(nameClass);
            sp.registerStoredProcedureParameter(paramName, clazz, paramMode);
            if (!"IN".equals(paramModeName) && !"INOUT".equals(paramModeName)) continue;
            sp.setParameter(paramName, param.get(paramName));
        }
        sp.execute();
        if (hasCursor.booleanValue() || !hasOut.booleanValue()) {
            List result = sp.getResultList();
            String key = hasOut != false ? keys.get(posCursor).toString() : "result";
            mapReturn.put(key, result);
        } else {
            for (i = 0; i < keys.size(); ++i) {
                paramName = keys.get(i).toString();
                paramModeName = ((Var)modes.get(i)).getObjectAsString();
                if (!"OUT".equals(paramModeName) && !"INOUT".equals(paramModeName)) continue;
                Object value = sp.getOutputParameterValue(paramName);
                mapReturn.put(paramName, value);
            }
        }
        return Var.valueOf(mapReturn);
    }

    @CronapiMetaData(type="function", name="{{setFlushMode}}", nameTags={"Definir Modo", "Descarga Dados", "Transa\u00e7\u00e3o", "Set Flush", "Transaction Data", "setFlushMode"}, description="{{setFlushModeDescription}}", returnType=CronapiMetaData.ObjectType.VOID)
    public static void setFlushMode(@ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{persistenceUnit}}", blockType="util_persistence_unit_list") Var persistenceUnit, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{flushMode}}", blockType="util_dropdown", keys={"AUTO", "COMMIT"}, values={"{{always}}", "{{onCommit}}"}, defaultValue="AUTO") Var type) throws Exception {
        if (!persistenceUnit.equals(Var.VAR_NULL)) {
            TransactionManager.setFlushMode(persistenceUnit.getObjectAsString(), type.getObjectAsString());
        }
    }

    @CronapiMetaData(name="{{configureConnectionName}}", description="{{configureConnectionDescription}}", returnType=CronapiMetaData.ObjectType.OBJECT)
    public static Var configureConnection(@ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{configureConnectionDriverInput}}") Var driverInput, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{configureConnectionUrlInput}}") Var urlInput, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{configureConnectionUserInput}}") Var userInput, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{configureConnectionPasswordInput}}") Var passwordInput) throws Exception {
        return cronapi.map.Operations.createObjectMapWith(new Var("driver", driverInput.getObject()), new Var("url", urlInput.getObject()), new Var("user", userInput.getObject()), new Var("password", passwordInput.getObject()));
    }

    @CronapiMetaData(name="executeNativeQueryAndReturnMap", nameTags={"execute", "native", "SQL"}, description="{{executeNativeQueryAndReturnMapDescription}}", returnType=CronapiMetaData.ObjectType.LIST)
    public static Var executeNativeQueryAndReturnMap(@ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{namespace}}") Var namespace, @ParamMetaData(type=CronapiMetaData.ObjectType.LIST, description="{{fieldNames}}") Var fields, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{query}}") Var query) throws Exception {
        EntityManagerFactory factory = Persistence.createEntityManagerFactory((String)namespace.getObjectAsString());
        EntityManager em = factory.createEntityManager();
        String strExecute = query.getObjectAsString();
        Query q = em.createNativeQuery(strExecute);
        List records = q.getResultList();
        ArrayList array = new ArrayList();
        for (Object record : records) {
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            for (int i = 0; i < fields.size(); ++i) {
                if (record instanceof String) {
                    map.put(fields.get(i).getObjectAsString(), record.toString());
                    continue;
                }
                List<Object> values = Arrays.asList((Object[])record);
                map.put(fields.get(i).getObjectAsString(), values.get(i).toString());
            }
            array.add(map);
        }
        return Var.valueOf(array);
    }
}

