package cronapi.unittest;

import cronapi.CronapiMetaData;
import cronapi.CronapiMetaData.CategoryType;
import cronapi.CronapiMetaData.ObjectType;
import cronapi.ParamMetaData;
import cronapi.Var;
import org.hamcrest.CoreMatchers;
import org.junit.Test;

import static org.junit.Assert.*;
import static org.junit.Assert.assertEquals;


@CronapiMetaData(category = CategoryType.UNITTEST, categoryTags = {"Unittest"})
public class Operations {

    @CronapiMetaData(
            type = "function",
            name = "{{assertEquals}}",
            description = "{{assertEqualsDesc}}",
            params = {"{{type}}", "{{expected}}", "{{actual}}", "{{deltaParam}}"},
            paramsType = {ObjectType.STRING, ObjectType.OBJECT, ObjectType.OBJECT, ObjectType.DOUBLE}
    )

    @Test
    public static void fnAssertEquals(@ParamMetaData(blockType = "util_dropdown", keys = {"NUMBER", "TEXT"}, values = {"{{number}}", "{{text}}"}) Var type, Var expected, Var actual, Var delta) throws Exception {

        if (type.equals("NUMBER")) {
            assertEquals(expected.getObjectAsDouble(), actual.getObjectAsDouble(), delta.getObjectAsDouble());
        } else if (type.equals("TEXT")) {
            assertEquals(expected.getObjectAsString(), actual.getObjectAsString());
        }

    }

    @CronapiMetaData(
            type = "function",
            name = "{{assertTrue}}",
            description = "{{assertTrueDesc}}",
            params = {"{{assertTrueParam0}}"},
            paramsType = {ObjectType.BOOLEAN}
    )

    @Test
    public static void fnAssertTrue(Var condition) throws Exception {

        assertTrue(condition.getObjectAsBoolean());

    }

    @CronapiMetaData(
            type = "function",
            name = "{{assertArrayEquals}}",
            description = "{{assertArrayEqualsDesc}}",
            params = {"{{assertArrayEqualsParam0}}", "{{assertArrayEqualsParam1}}"},
            paramsType = {ObjectType.LIST, ObjectType.LIST}
    )

    @Test
    public static void fnAssertArrayEquals(Var expecteds, Var actuals) throws Exception {

        assertArrayEquals(expecteds.getObjectAsList().toArray(), actuals.getObjectAsList().toArray());

    }

    @CronapiMetaData(
            type = "function",
            name = "{{assertFalse}}",
            description = "{{assertFalseDesc}}",
            params = {"{{assertFalseParam0}}"},
            paramsType = {ObjectType.BOOLEAN}
    )

    @Test
    public static void fnAssertFalse(Var condition) throws Exception {

        assertFalse(condition.getObjectAsBoolean());

    }

    @CronapiMetaData(
            type = "function",
            name = "{{assertNotNull}}",
            description = "{{assertNotNullDesc}}",
            params = {"{{assertNotNullParam0}}"},
            paramsType = {ObjectType.OBJECT}
    )

    @Test
    public static void fnAssertNotNull(Var object) throws Exception {

        assertNotNull(object.getObject());

    }


    @CronapiMetaData(
            type = "function",
            name = "{{assertNull}}",
            description = "{{assertNullDesc}}",
            params = {"{{assertNullParam0}}"},
            paramsType = {ObjectType.OBJECT}
    )

    @Test
    public static void fnAssertNull(Var object) throws Exception {

        assertNull(object.getObject());

    }

    @CronapiMetaData(
            type = "function",
            name = "{{assertSame}}",
            description = "{{assertSameDesc}}",
            params = {"{{assertSameDescParam0}}", "{{assertSameDescParam1}}"},
            paramsType = {ObjectType.OBJECT, ObjectType.OBJECT}
    )

    @Test
    public static void fnAssertSame(Var expected, Var actual) throws Exception {

        assertSame(expected, actual);

    }

    @CronapiMetaData(
            type = "function",
            name = "{{assertThat}}",
            description = "{{assertThatDesc}}",
            params = {"{{assertThatParam0}}", "{{assertThatParam1}}"},
            paramsType = {ObjectType.OBJECT, ObjectType.OBJECT}
    )

    @Test
    public static void fnAssertThat(Var actual, Var matcher) throws Exception {

        assertThat(actual, CoreMatchers.is(matcher));


    }

}
