package cronapi.swagger;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.google.gson.JsonObject;

import java.util.HashMap;

public class ParameterDefinition {
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private String name;
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private String in;
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private String description;
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private Boolean required;
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private HashMap<String, String>  content;
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private HashMap<String, String> paramByRef;

    public ParameterDefinition(){
        this.content = new HashMap();
        this.content.put("type", "string");
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getIn() {
        return in;
    }

    public void setIn(String in) {
        this.in = in;
    }

    public Boolean getRequired() {
        return required;
    }

    public void setRequired(Boolean required) {
        this.required = required;
    }

    public void setParamByRef(String path){
        this.paramByRef = new HashMap<>();
        this.paramByRef.put("$ref", path);
        this.content = null;
    }

    @JsonAnyGetter
    public HashMap getParamByRef(){
        return this.paramByRef;
    }

    public HashMap getSchema() {
        return content;
    }

    public void setSchema(HashMap content) {
        this.content = content;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}
