package cronapi.swagger;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.LinkedHashMap;

public class ParameterBodyDefinition {

    private LinkedHashMap<String, LinkedHashMap> content = new LinkedHashMap();
    private final String type;
    private Boolean required;

    @JsonIgnore
    public ParameterBodyDefinition(String type){
        this.type = type;
        this.content.put(type, new LinkedHashMap());
        this.setDefaultProperties();
    }

    private void setDefaultProperties(){
        var schema = new LinkedHashMap();
        schema.put("type", "object");
        schema.put("properties", new LinkedHashMap());
        this.content.get(this.type).put("schema", schema);
    }

    @JsonIgnore
    public void addProperty(String name, LinkedHashMap definition){
        var schema = (LinkedHashMap) this.content.get(this.type).get("schema");
        var properties = (LinkedHashMap) schema.get("properties");
        properties.put(name, definition);
    }

    public LinkedHashMap getContent(){
        return this.content;
    }

    public void setRequired(boolean required){
        this.required = required;
    }

    public boolean getRequired(){
        return this.required;
    }

}
