package cronapi.swagger;

import com.fasterxml.jackson.annotation.JsonInclude;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.HashMap;

@Component
public class OperationDefinition {
    private String[] tags;
    private String operationId;
    private ArrayList<ParameterDefinition> parameters = new ArrayList<>();
    private HashMap<String, ResponseDefinition> responses = new HashMap();

    @JsonInclude(JsonInclude.Include.NON_NULL)
    private ParameterBodyDefinition requestBody;

    @JsonInclude(JsonInclude.Include.NON_NULL)
    private ArrayList<HashMap<String, HashMap>> security;

    public String[] getTags() {
        return tags;
    }

    public void setTags(String[] tags) {
        this.tags = tags;
    }

    public String getOperationId() {
        return operationId;
    }

    public void setOperationId(String operationId) {
        this.operationId = operationId;
    }

    public ArrayList<ParameterDefinition> getParameters() {
        return parameters;
    }

    public void setParameters(ArrayList<ParameterDefinition> parameters) {
        this.parameters = parameters;
    }

    public HashMap getResponses() {
        return responses;
    }

    public void setResponses(HashMap responses) {
        this.responses = responses;
    }

    public void setRequestBody(ParameterBodyDefinition requestBody) {
        this.requestBody = requestBody;
    }

    public ParameterBodyDefinition getRequestBody() {
        return requestBody;
    }

    public ArrayList<HashMap<String, HashMap>> getSecurity() {
        return security;
    }

    public void setSecurity(ArrayList<HashMap<String, HashMap>> security) {
        this.security = security;
    }
}
