package cronapi.rest;

import com.google.gson.JsonElement;
import cronapi.swagger.CronappOpenApiDefinition;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

@Controller
@RequestMapping(value = "/api/metadata/")
public class CronapiMetadataREST {

    @Autowired
    CronappOpenApiDefinition openApiDefinition;

    @RequestMapping("/")
    public String root(HttpServletResponse response) throws IOException {
        if(!openApiDefinition.exposeEndpoints()){
            response.sendRedirect("403.html");
            return "403.html";
        }else{
            return "index.html";
        }
    }

    @RequestMapping(method = RequestMethod.GET, value = "/configuration")
    public HttpEntity<JsonElement> dataOptions() throws Exception {
        return new ResponseEntity<>( openApiDefinition.getJsonData(), HttpStatus.OK);
    }

}
