package cronapi.dashboard;

import com.google.gson.*;
import com.stimulsoft.report.StiOptions.Services;
import cronapi.*;
import cronapi.report.odata.StiODataDatabase;
import cronapi.report.odata.StiODataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import java.io.*;
import java.util.*;
import java.util.stream.Collectors;

@Service
public class DashboardService {

    private static HashMap<String, String> charCannotBeEscaped;

    static {
        com.stimulsoft.base.licenses.StiLicense.setKey("" +
                "6vJhGtLLLz2GNviWmUTrhSqnOItdDwjBylQzQcAOiHl4mF8Yy+Msl8Mjp+nbkDv52zYAIT+dpsXLWIrkoWUKLuRM23" +
                "NSg8pIvYh6tBo4G/ZbeRpxW0S6pW7OFk7po8BkktyA+vHtfRKYFAO4H+qoK6JBlRbQjOtO9vDgdcIfkLIfhwrbQhvh" +
                "yaJMnkga7SqJ2c181/qsG90YkxgF+o525F67z/Ar0uCIoz6UgebnfFX44dfr3k37tlVwgEKtHLIZhxpUddmhh10jz6" +
                "LmMpOsumJtnBUxANBuvhbXwVvssIYxLAaltqYc9DvkgetJQtinc23zZp81zE9D/Sf9lXhKu6oplHsQVURDVC6gZ+ke" +
                "yeiHbI6DM8xf1TV2BjM3V5+C23cyQ9F3fFUM/lMPto9CZyJZTmqRnrckO/dtQ88Q2ESCQXqNOBEf0rL9jlJlWLpK/Z" +
                "LwcTudISL1jW5Nd78IfXr14ejq18wnKYWsYMOq2Sd1u7cBvjt7bTXvkZpb6Lkyqlg2vKNnYcdf3kBSS94fhBFcHKQs" +
                "TSq7F3njQRSsqXO1Tzu8/CBrBqx+/k7aow2DF4Vap0PFN/2/f0WGglroGh6vFk/XF0vH5fZvrDg/Edg1YzNxHuOVJJ" +
                "ZhM3Il11eiQejV2N9V4LPh1O0Sergi1pb+IRlIzCWIA+8Zykjqn97OtF+oxVvIZdXRkIWEa00EmuJuljPCC5pKMMDq" +
                "kixwRw=="
        );

        Services.getDataSource().add(StiODataSource.class);
        Services.getDataBases().add(StiODataDatabase.class);
        charCannotBeEscaped = new HashMap<String, String>() {{
            put("/", "|slash|");
        }};
    }

    private static final Logger log = LoggerFactory.getLogger(DashboardService.class);

    private final ClassLoader loader;

    DashboardService() {
        this.loader = Thread.currentThread().getContextClassLoader();
    }

    public DashboardFront getDashboard(String dashboardName) {
        DashboardFront dashboardFront = new DashboardFront(dashboardName);
        return dashboardFront;
    }

    public String getContentDashboard(String dashboardName) {
        try (InputStream inputStream = this.getInputStream(dashboardName)) {
            try (BufferedReader buffer = new BufferedReader(new InputStreamReader(inputStream, CronapiConfigurator.ENCODING))) {
                String content = buffer.lines().collect(Collectors.joining("\n"));
                JsonObject json = (JsonObject) new JsonParser().parse(content);
                json.addProperty("dashboardName", dashboardName);
                return json.toString();
            }
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private InputStream getInputStream(String dashboardName) {
        InputStream inputStream = loader.getResourceAsStream(dashboardName);
        if (inputStream == null) {
            throw new RuntimeException("File [" + dashboardName + "] not found.");
        }
        return inputStream;
    }
}