package cronapi.dashboard;

import cronapi.rest.DashboardREST;
import cronapp.reports.commons.Parameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class DashboardFront implements Serializable {

    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(DashboardFront.class);
    private String dashboardName;

    private List<Parameter> parameters;

    public DashboardFront() {
        this.dashboardName = "";
        this.parameters = new ArrayList<>(1024);
    }

    public DashboardFront(String dashboardName) {
        log.info("construtor do front ==== " + dashboardName);
        this.dashboardName = dashboardName;
        this.parameters = new ArrayList<>(1024);
    }

    public String getDashboardName() {
        return dashboardName;
    }

    public void setDashboardName(String dashboardName) {
        this.dashboardName = dashboardName;
    }
    public List<Parameter> getParameters() {
        return parameters;
    }

    public void setParameters(List<Parameter> parameters) {
        this.parameters = parameters;
    }

    @Override
    public boolean equals(Object o) {
        if(this == o)
            return true;
        if(o == null || getClass() != o.getClass())
            return false;
        cronapi.dashboard.DashboardFront that = (cronapi.dashboard.DashboardFront)o;
        return dashboardName != null ? dashboardName.equals(that.dashboardName)
                : that.dashboardName == null && parameters.equals(that.parameters);
    }

    @Override
    public int hashCode() {
        int result = dashboardName != null ? dashboardName.hashCode() : 0;
        result = 31 * result + parameters.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "DashboardFront{" + "dashboardName='" + dashboardName + '\'' + ", parameters=" + parameters + '}';
    }

}
