package cronapi.authentication;

import com.google.gson.JsonObject;
import cronapi.*;
import cronapi.CronapiMetaData.CategoryType;
import cronapi.database.DataSource;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import org.apache.commons.lang3.StringUtils;

import java.util.*;

/**
 * Classe que representa ...
 * 
 * @author Rodrigo Santos Reis
 * @email rodrigo.reis@cronapp.io
 * @version 1.0
 * @since 2017-03-29
 *
 */
@CronapiMetaData(category = CategoryType.AUTHENTICATION, categoryTags = { "Autenticação", "Authentication" })
public class Operations {


  @CronapiMetaData(type = "function", name = "{{getUserRoles}}", nameTags = { "listar", "list","regras","roles","papeis","grupos" }, description = "{{getUserRolesDescription}}", returnType = CronapiMetaData.ObjectType.LIST)
  public static final Var getUserRoles() throws Exception{ 
    LinkedList<String> groups = new LinkedList<String>();
    for( cronapi.util.SecurityUtil.SecurityGroup obj : cronapi.util.SecurityUtil.getRoles()){
	   groups.add(obj.id); 
	}
		return Var.valueOf(groups);
  }

    @CronapiMetaData(
        type = "function",
        name = "{{signUp}}",
        nameTags = { "sign up", "register", "cadastrar", "inscrever" },
        description = "{{signUpParam0}}"
    )
    public static Var signUp(
        @ParamMetaData( type = CronapiMetaData.ObjectType.MAP, description = "{{signUpParam0}}") Var params
    ) throws Exception {
        Var retorno = new Var();
        try {
            StringBuilder uriBuilder = new StringBuilder()
                .append(cronapi.screen.Operations.getHeader(Var.valueOf("Origin")))
                .append("/auth/signup");

            retorno = cronapi.util.Operations.getURLFromOthers(
                Var.valueOf("POST"),
                Var.valueOf("application/json"),
                new Var(uriBuilder.toString()),
                Var.VAR_NULL,
                Var.VAR_NULL,
                params
            );
        } catch (Exception err) {
            cronapi.util.Operations.log(
                Var.valueOf("General"),
                Var.valueOf("SEVERE"),
                cronapi.json.Operations.getJsonOrMapField(new Var(err), Var.valueOf("message")),
                Var.VAR_NULL
            );
        }
        return Var.valueOf(retorno);
    }

    @CronapiMetaData(
        type = "function",
        name = "{{resetPassword}}",
        nameTags = { "reset password", "recover password", "recuperar senha", "resetar senha" },
        description = "{{resetPasswordDescription}}"
    )
    public static void resetPassword(
        @ParamMetaData(type = CronapiMetaData.ObjectType.STRING, description = "{{resetPasswordParam0}}") Var toAddress,
        @ParamMetaData(type = CronapiMetaData.ObjectType.STRING, description = "{{resetPasswordParam1}}") Var imageHeader,
        @ParamMetaData(type = CronapiMetaData.ObjectType.STRING, description = "{{resetPasswordParam2}}") Var imageFooter
    ) throws Exception {
        try {

            DataSource ds = new DataSource("app.entity.User");
            ds.filter("select u.name, u.email from User u where u.email = :email", Var.valueOf("email", toAddress));

            if (!ds.getPage().getContent().isEmpty()) {
                Map<String, Object> dataModel = new LinkedHashMap<>();

                Map<String, Object> claims = new HashMap<>();
                claims.put("sub", toAddress.getObjectAsString());
                claims.put("scope", "update:current_user:password");

                Long expiration = AppConfig.tokenExpiration();
                Date tokenExpiration = new Date(System.currentTimeMillis() + expiration * 1000);

                String token = Jwts.builder().setClaims(claims).setExpiration(tokenExpiration).signWith(SignatureAlgorithm.HS512, AppConfig.token()).compact();

                String url = RestClient.getRestClient().getHeader("Origin") + "/#/public/reset-password?token=" + token;
                dataModel.put("link", url);
                dataModel.put("email", toAddress);

                JsonObject config = AppConfig.getJSON();
                String emailFrom = StringUtils.EMPTY;
                String nameFrom = StringUtils.EMPTY;
                if (!AppConfig.isNull(config.get("email"))) {
                    emailFrom = config.get("email").getAsJsonObject().get("emailResetPassword").getAsString();
                    nameFrom = config.get("email").getAsJsonObject().get("nameResetPassword").getAsString();
                }

                Variable message = cronapp.framework.mailer.MailerApi.createMessage();

                cronapp.framework.mailer.MailerApi.setFrom(message, VariableFactory.getInstance().newVariable(emailFrom), VariableFactory.getInstance().newVariable(nameFrom));

                cronapp.framework.mailer.MailerApi.addTo(message, toAddress, toAddress);

                cronapp.framework.mailer.MailerApi.setSubject(message, VariableFactory.getInstance().newVariable(cronapi.i18n.Operations.translate(Var.valueOf("ResetPasswordEmailSubject"))));

                cronapp.framework.mailer.MailerApi.setText(message,
                        VariableFactory.getInstance().newVariable(StringUtils.EMPTY),
                        cronapp.framework.templater.TemplaterApi.process(new Var("reset-password.ftlh"), new Var(dataModel), VariableFactory.getInstance().newVariable(RestClient.getRestClient().getLocale())));

                cronapp.framework.mailer.MailerApi.addInlineAttachment(VariableFactory.getInstance().newVariable("headerImageCid"), message, imageHeader);

                cronapp.framework.mailer.MailerApi.addInlineAttachment(VariableFactory.getInstance().newVariable("footerImageCid"), message, imageFooter);

                cronapp.framework.mailer.MailerApi.send(message);
            }

        } catch (Exception err) {
            cronapi.util.Operations.log(
                Var.valueOf("General"),
                Var.valueOf("SEVERE"),
                cronapi.json.Operations.getJsonOrMapField(new Var(err), Var.valueOf("message")),
                Var.VAR_NULL
            );
        }
    }

}
