package cronapi.database;

import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.expressions.QueryKeyExpression;
import org.eclipse.persistence.internal.jpa.EJBQueryImpl;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;

import javax.persistence.Query;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.SingularAttribute;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class JPAUtil {
  public static Set getAjustedAttributes(EntityType type) {
    Set<SingularAttribute> attributes = type.getAttributes();
    Set<SingularAttribute> attrs = new LinkedHashSet<SingularAttribute>();

    for (int i = 0; i < type.getJavaType().getDeclaredFields().length; i++) {
      for (SingularAttribute attr : attributes) {
        if (attr.getName().equalsIgnoreCase(type.getJavaType().getDeclaredFields()[i].getName())) {
          attrs.add(attr);
          break;
        }
      }
    }

    return attrs;
  }

  public static void recursiveDerived(List<Expression> derivedExpressions) {
    if (derivedExpressions != null) {
      for (Expression derivedExpression : derivedExpressions) {
        //Só permite por doUseOuterJoin quando tiver expressions tb (Pois significa que é campo de FK (RelationMapping, ManyToOne...), se for directMapping, não irá setar
        //doUseOuterJoin, verifica se tb se existe mais derivedExpressions para ser utilizado o doUseOUterJoin()
        if (derivedExpression instanceof QueryKeyExpression && ((QueryKeyExpression) derivedExpression).derivedExpressions != null) {
          ((QueryKeyExpression)derivedExpression).doUseOuterJoin();
          recursiveDerived(((QueryKeyExpression) derivedExpression).derivedExpressions);
        }
      }
    }
  }

  public static void prepareQuery(Query query) {
    List<Expression> joinedAttributes = ((ObjectLevelReadQuery) ((EJBQueryImpl) query).getDatabaseQuery()).getJoinedAttributeManager().getJoinedMappingExpressions();
    if (joinedAttributes != null) {
      for (org.eclipse.persistence.expressions.Expression joinedAttribute : joinedAttributes) {
        if (joinedAttribute instanceof QueryKeyExpression) {
          ((QueryKeyExpression) joinedAttribute).doUseOuterJoin();
          recursiveDerived(((QueryKeyExpression) joinedAttribute).derivedExpressions);
        }
      }
    }
  }
}

