package cronapi.odata.server;

import cronapi.database.TransactionManager;
import org.apache.olingo.odata2.api.ODataServiceFactory;
import org.apache.olingo.odata2.core.servlet.ODataServlet;
import org.apache.olingo.odata2.jpa.processor.core.ODataExpressionParser;
import org.apache.olingo.odata2.jpa.processor.core.ODataParameterizedWhereExpressionUtil;

import javax.persistence.EntityManagerFactory;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

class ODataServletV2 extends ODataServlet {
  public static ThreadLocal<HttpServletRequest> REQUEST = new ThreadLocal<>();
  public static ThreadLocal<HttpServletResponse> RESPONSE = new ThreadLocal<>();
  private static final long serialVersionUID = 1L;
  private final String namespace;
  private final int order;

  public ODataServletV2(String namespace, int order) {
    this.namespace = namespace;
    this.order = order;
  }

  @Override
  protected void service(HttpServletRequest req, HttpServletResponse res) throws IOException {
    try {

      REQUEST.set(req);
      RESPONSE.set(res);
      req.setAttribute(ODataServiceFactory.FACTORY_INSTANCE_LABEL, new JPAODataServiceFactory(namespace, order));
      //TODO: Centralizar no cronapp filter e remover dos lugares com código duplicado
      try {
        super.service(req, res);
        TransactionManager.commit();
      } catch (Exception e) {
        TransactionManager.rollback();
        throw e;
      }
    } finally {
      ODataParameterizedWhereExpressionUtil.clear();
      ODataExpressionParser.clear();
      TransactionManager.close();
      TransactionManager.clear();
      REQUEST.set(null);
      REQUEST.remove();
      RESPONSE.set(null);
      RESPONSE.remove();
    }
  }
}
