package cronapi.util;

import cronapi.QueryManager;
import cronapi.Var;
import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BlocklyInfo {
  public static Pattern BLOCKLY_CALL = Pattern.compile("cronapi\\.([^\\.]+)\\((.*?)\\)(\\.names\\((.*?)\\))?(\\.attr\\(\\))?\\.run\\((.*?)\\)");

  private String type;
  private String blocklyMethod;
  private String blocklyClass;
  private String blocklyLanguage;
  private List<BlocklyParam> blocklyParams = new ArrayList<>();

  private String unquote(String str) {
    if (str.length() >= 2 && str.startsWith("\"") || str.startsWith("'")) {
      return str.substring(1, str.length() - 1);
    }

    return str;
  }

  public boolean load(String text, Object entity, Map<String, Var> customValues) {
    if (text != null && !text.trim().isEmpty()) {

      Matcher blocklyMatcher = BLOCKLY_CALL.matcher(text);

      if (blocklyMatcher.matches()) {

        blocklyParams.clear();

        String blockly = unquote(blocklyMatcher.group(2).trim());

        String[] parts = blockly.split("\\.");

        type = blocklyMatcher.group(1);
        blocklyMethod = parts[parts.length - 1];
        blocklyClass = StringUtils.join(parts, ".", 0, parts.length - 1);
        blocklyLanguage = "client".equals(type) ? "js" : "java";

        List<String> array = StringUtils.isNotBlank(blocklyMatcher.group(6)) ? Functions.parseArguments(blocklyMatcher.group(6).trim()) : null;
        List<String> names = StringUtils.isNotBlank(blocklyMatcher.group(4)) ? Functions.parseArguments(blocklyMatcher.group(4).trim()) : null;

        if (array != null) {
          int i = 0;
          for (String value : array) {
            i++;
            BlocklyParam param = new BlocklyParam();
            if (names != null && names.size() == array.size()) {
              param.setName(names.get(i - 1));
            }
            if (!value.equals("null")) {
              param.setValue(QueryManager.parseExpressionValue(entity, value, customValues));
            }
            blocklyParams.add(param);
          }
        }

        return true;
      }

    }

    return false;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public String getBlocklyMethod() {
    return blocklyMethod;
  }

  public void setBlocklyMethod(String blocklyMethod) {
    this.blocklyMethod = blocklyMethod;
  }

  public String getBlocklyClass() {
    return blocklyClass;
  }

  public void setBlocklyClass(String blocklyClass) {
    this.blocklyClass = blocklyClass;
  }

  public void setParamValue(String key, Var value) {
    for (BlocklyParam param : blocklyParams) {
      if (param.name.equals(key)) {
        param.value = value;
      }
    }
  }

  public List<BlocklyParam> getBlocklyParams() {
    return blocklyParams;
  }

  public void setBlocklyParams(List<BlocklyParam> blocklyParams) {
    this.blocklyParams = blocklyParams;
  }

  public String getBlocklyLanguage() {
    return blocklyLanguage;
  }

  public void setBlocklyLanguage(String blocklyLanguage) {
    this.blocklyLanguage = blocklyLanguage;
  }

  @Override
  public String toString() {
    String result = "";
    if (this.getBlocklyClass() != null)
      result = this.getBlocklyClass();
    if (this.getBlocklyMethod() != null)
      result += result.length() > 0 ? ":" + this.getBlocklyMethod() : this.getBlocklyMethod();
    return result;
  }
}
