package cronapi.util;

import java.lang.reflect.Field;
import java.util.*;

import cronapi.Var;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ReflectionUtils;

public class SecurityUtil {

  private static final Logger log = LoggerFactory.getLogger(SecurityUtil.class);

  public static class SecurityGroup {
    public String id;
    public String name;
  }

  private static Class forName(String clazz) {
    try {
      return Class.forName(clazz);
    }
    catch(Exception e) {
      //
    }
    return null;
  }

    public static List<SecurityGroup> getRoles() {
        Class clazz = forName("auth.permission.SecurityPermission");
        if(clazz != null) {
            final List<SecurityGroup> groups = new LinkedList<>();
            ReflectionUtils.doWithLocalFields(clazz, new ReflectionUtils.FieldCallback() {
                @Override
                public void doWith(Field field) throws IllegalArgumentException, IllegalAccessException {
                    Object v = field.get(null);

                    SecurityGroup group = new SecurityGroup();
                    group.name = v.toString();
                    group.id = v.toString();

                    groups.add(group);
                }
            });
            return groups;
        } else {
            try {
                List<SecurityGroup> listReturn = new ArrayList<>();
                Var listRoles = Var.VAR_NULL;
                Var role = Var.VAR_NULL;
                Var roleName = Var.VAR_NULL;

                listRoles = cronapi.database.Operations.query(Var.valueOf("app.entity.Role"), Var.valueOf("select r from Role r"));
                for (Iterator it_i = listRoles.iterator(); it_i.hasNext(); ) {
                    role = Var.valueOf(it_i.next());
                    roleName = cronapi.object.Operations.getObjectField(role, Var.valueOf("name"));
                    SecurityGroup securityGroup = new SecurityGroup();
                    securityGroup.id = roleName.getObjectAsString();
                    securityGroup.name = roleName.getObjectAsString();
                    listReturn.add(securityGroup);
                }
                return listReturn;
            } catch (Exception e) {
                log.error(e.getMessage());
                throw new RuntimeException(e);
            }
        }
    }

}
