package cronapi.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import org.apache.commons.lang3.StringUtils;

public class JsonUtil {
  public static boolean isJson(String content) {
    try {
      new JsonParser().parse(content);
      return true;
    } catch (Throwable e) {
      //NoCommand
    }
    return false;
  }

  public static boolean isNull(JsonElement value) {
    return value == null || value.isJsonNull();
  }

  public static boolean isNullOrBlank(JsonElement value) {
    return value == null || value.isJsonNull() || (value.isJsonPrimitive() && value.getAsJsonPrimitive().isString() && StringUtils.isBlank(value.getAsJsonPrimitive().getAsString()));
  }
}
