package cronapi.odata.server;

import cronapi.Var;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.jaxws.endpoint.dynamic.JaxWsDynamicClientFactory;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.model.MessageInfo;

import java.lang.reflect.Field;
import java.util.*;
import java.util.concurrent.ConcurrentHashMap;

public class SOAPUtil {
  private static Map<String, Client> CACHE = new ConcurrentHashMap<>();
  private Client client;

  public static class ServiceMetadataMethod {
    public Field[] inputs;
    public Field response;
    public String name;

    public ServiceMetadataMethod(MessageInfo message) {
      try {
        Class<?> clazz = message.getFirstMessagePart().getTypeClass();
        inputs = clazz.getDeclaredFields();
        name = message.getOperation().getName().getLocalPart();

        MessageInfo responseMessage = message.getOperation().getOutput();
        if (responseMessage != null && responseMessage.getFirstMessagePart().getTypeClass().getDeclaredFields().length > 0) {
          response = responseMessage.getFirstMessagePart().getTypeClass().getDeclaredFields()[0];
        }
      } catch (Exception e) {
        throw new RuntimeException(e);
      }
    }
  }

  public static class ServiceMetadata {
    public List<ServiceMetadataMethod> functions = new LinkedList<>();
  }

  public ServiceMetadata getSOAPMetadata(String url, String name) {
    try {
      String cacheKey = "SOAP" + url;

      client = CACHE.get(cacheKey);
      if (client == null) {
        JaxWsDynamicClientFactory dcf = JaxWsDynamicClientFactory.newInstance();
        client = dcf.createClient(url);
        CACHE.put(cacheKey, client);
      }

      ServiceMetadata result = new ServiceMetadata();
      client.getEndpoint().getEndpointInfo().getService().getMessages().values().stream().forEach((message) -> {
        if ((name == null || name.equals(message.getName().getLocalPart())) && message.getType() != MessageInfo.Type.OUTPUT) {
          ServiceMetadataMethod method = new ServiceMetadataMethod(message);
          result.functions.add(method);
        }
      });

      result.functions.sort((f1, f2) -> {
        return f1.name.toLowerCase().compareTo(f2.name.toLowerCase());
      });

      return result;
    } catch (Exception e) {
      throw new RuntimeException(e);
    }
  }

  public Object call(String method, Map<String, Var> headers, Object... params) {
    try {
      Map<String, List<String>> cxfHeaders = (Map<String, List<String>>) client.getRequestContext().get(Message.PROTOCOL_HEADERS);

      if (cxfHeaders == null) {
        cxfHeaders = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
        client.getRequestContext().put(Message.PROTOCOL_HEADERS, cxfHeaders);
      }
      for (Map.Entry<String, Var> entry : headers.entrySet()) {
        cxfHeaders.put(entry.getKey(), Collections.singletonList(entry.getValue().getObjectAsString()));
      }

      Object[] result = client.invoke(method, params);
      if (result != null && result.length > 0) {
        return result[0];
      }
    } catch (Exception e) {
      throw new RuntimeException(e);
    }

    return null;
  }
}
