package cronapi.util;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class Functions {

  public static List<String> parseArguments(String str) {
    return parseArguments(str, ",");
  }

  public static List<String> parseArguments(String str, String delimiters) {
    final String delims = delimiters;
    final String quots = "\'\"[]";
    final String trim = " \n\r\t";
    char currentQuot = '\'';
    String token = "";
    boolean isQuoted = false;
    List<String> tokens = new LinkedList<>();

    for (int i = 0; i < str.length(); i++) {
      if (quots.indexOf(str.charAt(i)) != -1 && (i == 0 || (i > 0 && str.charAt(i - 1) != '\\'))) {

        if (token.length() != 0 && currentQuot != str.charAt(i)) {
          //
        } else {
          isQuoted = token.length() == 0;
          currentQuot = str.charAt(i);
          if (currentQuot == '[') {
            currentQuot = ']';
          }
        }
      }
      if (delims.indexOf(str.charAt(i)) == -1 || isQuoted) {
        if (token.isEmpty() && trim.indexOf(str.charAt(i)) != -1) {
          //
        } else {
          token += str.charAt(i);
        }
      } else {
        if (!token.trim().isEmpty()) {
          tokens.add(token.trim());
        }
        token = "";
        isQuoted = false;
      }
    }

    if (token.trim().length() > 0) {
      tokens.add(token.trim());
    }

    return tokens;
  }

  public static List<String> parseTokens(String text) {
    final String delims = " \n\r\t.(){},+/?=&";
    final String quots = "\'";
    String token = "";
    boolean isQuoted = false;
    List<String> tokens = new ArrayList<String>();

    for (int i = 0; i < text.length(); i++) {
      if (quots.indexOf(text.charAt(i)) != -1) {
        isQuoted = token.length() == 0;
      }
      if (delims.indexOf(text.charAt(i)) == -1 || isQuoted) {
        token += text.charAt(i);
      } else {
        if (token.length() > 0) {
          tokens.add(token);
          token = "";
          isQuoted = false;
        }
      }
    }

    if (token.length() > 0) {
      tokens.add(token);
    }

    return tokens;
  }

  public static String unquote(String str) {
    if (str.length() >= 2 && (str.startsWith("\"") || str.startsWith("'")) && (str.endsWith("\"") || str.endsWith("'"))) {
      return str.substring(1, str.length() - 1);
    }

    return str;
  }

}
