package cronapi.excel;

import cronapi.CronapiMetaData;
import cronapi.ParamMetaData;
import cronapi.Var;
import org.apache.poi.common.usermodel.HyperlinkType;
import org.apache.poi.ss.usermodel.*;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.*;

import java.io.File;
import java.io.FileOutputStream;

@CronapiMetaData(categoryName = "Excel")
public class Excel {

    @CronapiMetaData(
        name = "{{createSpreadSheet}}",
        description = "{{createSpreadSheetDescription}}",
        nameTags = {"Criar Excel", "Criar Arquivo Excel", "Create Excel", "Create File Excel"},
        returnType = CronapiMetaData.ObjectType.OBJECT
    )
    public static final Var createSpreadSheet() {
        XSSFWorkbook workbook = new XSSFWorkbook();
        return Var.valueOf(workbook);
    }

    @CronapiMetaData(
        name = "{{createSheet}}",
        description = "{{createSheetDescription}}",
        nameTags = {"Criar Aba", "Aba", "Create Sheet", "Sheet"},
        returnType = CronapiMetaData.ObjectType.OBJECT
    )
    public static final Var createSheet(
        @ParamMetaData(type = CronapiMetaData.ObjectType.STRING, description = "{{workbook}}") Var workbook,
        @ParamMetaData(type = CronapiMetaData.ObjectType.STRING, description = "{{nameDescription}}") Var name
    ) {
        Sheet sheet = workbook.getTypedObject(XSSFWorkbook.class).createSheet(name.getObjectAsString());
        return Var.valueOf(sheet);
    }

    @CronapiMetaData(
        name = "{{createLine}}",
        description = "{{createLineDescription}}",
        nameTags = {"Criar Linha", "Linha", "Create Line", "Line"},
        returnType = CronapiMetaData.ObjectType.OBJECT
    )
    public static final Var createLine(
            @ParamMetaData(type = CronapiMetaData.ObjectType.STRING, description = "{{rowNumber}}") Var rowNumber,
            @ParamMetaData(type = CronapiMetaData.ObjectType.STRING, description = "{{sheet}}") Var sheet
    ) {
        Row row = sheet.getTypedObject(XSSFSheet.class).createRow(rowNumber.getObjectAsInt());
        return Var.valueOf(row);
    }

    @CronapiMetaData(
        name = "{{getCellValue}}",
        description = "{{getCellValueDescription}}",
        nameTags = {"Obter Valor", "Valor Celula", "Get Value", "Value Cell"},
        returnType = CronapiMetaData.ObjectType.OBJECT
    )
    public static final Var getCellValue(
        @ParamMetaData(type = CronapiMetaData.ObjectType.STRING, description = "{{rowNumber}}") Var rowNumber,
        @ParamMetaData(type = CronapiMetaData.ObjectType.STRING, description = "{{columnNumber}}") Var columnNumber,
        @ParamMetaData(type = CronapiMetaData.ObjectType.STRING, description = "{{sheet}}") Var sheet
    ) {

        XSSFRow row = sheet.getTypedObject(XSSFSheet.class).getRow(rowNumber.getObjectAsInt());
        XSSFCell cell = row.getCell(columnNumber.getObjectAsInt());
        Var valor;

        switch (cell.getCellType()) {
            case BLANK:
                valor = Var.valueOf(cell.getRawValue());
                break;
            case BOOLEAN:
                valor = Var.valueOf(cell.getBooleanCellValue());
                break;
            case ERROR:
                valor = Var.valueOf(cell.getErrorCellString());
                break;
            case FORMULA:
                valor = Var.valueOf(cell.getCellFormula());
                break;
            case NUMERIC:
                valor = Var.valueOf(cell.getNumericCellValue());
                break;
            default:
                valor = Var.valueOf(cell.getStringCellValue());
        }

        return valor;
    }

    @CronapiMetaData(
        name = "{{insertCellContent}}",
        description = "{{insertCellContentDescription}}",
        nameTags = {"Inserir Conteúdo", "Conteudo Celula", "Insert Content", "Content Cell"},
        returnType = CronapiMetaData.ObjectType.VOID
    )
    public static final void insertCellValue(
        @ParamMetaData(type = CronapiMetaData.ObjectType.STRING, description = "{{rowNumber}}") Var rowNumber,
        @ParamMetaData(type = CronapiMetaData.ObjectType.STRING, description = "{{columnNumber}}") Var columnNumber,
        @ParamMetaData(type = CronapiMetaData.ObjectType.STRING, description = "{{sheet}}") Var sheet,
        @ParamMetaData(type = CronapiMetaData.ObjectType.STRING, description = "{{contentSheet}}") Var value
    ) {
        Row row = sheet.getTypedObject(XSSFSheet.class).getRow(rowNumber.getObjectAsInt());
        if (row == null) {
            row = sheet.getTypedObject(XSSFSheet.class).createRow(rowNumber.getObjectAsInt());
        }

        Cell cell = row.getCell(columnNumber.getObjectAsInt());
        if (cell == null) {
            cell = row.createCell(columnNumber.getObjectAsInt());
        }

        switch (value.getType()) {
            case STRING:
                cell.setCellValue(value.getObjectAsString());
                break;
            case INT:
                cell.setCellValue(value.getObjectAsInt());
                break;
            case DOUBLE:
                cell.setCellValue(value.getObjectAsDouble());
                break;
            case BOOLEAN:
                cell.setCellValue(value.getObjectAsBoolean());
                break;
            case DATETIME:
                cell.setCellValue(value.getObjectAsDateTime());
                break;
            default:
                cell.setCellValue(value.getObjectAsString());
        }
    }

    @CronapiMetaData(
        name = "{{setCellType}}",
        description = "{{setCellTypeDescription}}",
        nameTags = {"Tipo Célula", "Formato Conteúdo", "Set Cell Type", "Cell Type"},
        returnType = CronapiMetaData.ObjectType.VOID
    )
    public static final void setCellType(
        @ParamMetaData(type = CronapiMetaData.ObjectType.STRING, description = "{{rowNumber}}") Var rowNumber,
        @ParamMetaData(type = CronapiMetaData.ObjectType.STRING, description = "{{columnNumber}}") Var columnNumber,
        @ParamMetaData(type = CronapiMetaData.ObjectType.STRING, description = "{{sheet}}") Var sheet,
        @ParamMetaData(type = CronapiMetaData.ObjectType.STRING, description = "{{cellType}}",
            blockType = "util_dropdown",
            values = {
                "{{cellTypeNumeric}}", "{{cellTypeText}}", "{{cellTypeFormula}}",
                "{{cellTypeWhite}}", "{{cellTypeBoolean}}", "{{cellTypeError}}"
            },
            keys = {
                "0", "1", "2", "3", "4", "5"
            }
        ) Var cellType
    ) {

        Row row = sheet.getTypedObject(XSSFSheet.class).getRow(rowNumber.getObjectAsInt());
        if (row == null) {
            row = sheet.getTypedObject(XSSFSheet.class).createRow(rowNumber.getObjectAsInt());
        }

        Cell cell = row.getCell(columnNumber.getObjectAsInt());
        if (cell == null) {
            cell = row.createCell(columnNumber.getObjectAsInt());
        }

        cell.setCellType(CellType.forInt(cellType.getObjectAsInt()));
    }

    @CronapiMetaData(
        name = "{{alignCellTextHorizontal}}",
        description = "{{alignCellTextHorizontalDescription}}",
        nameTags = {"Alinhamento Horizontal", "Alinhamento", "Align Horizontal", "Align"},
        returnType = CronapiMetaData.ObjectType.VOID
    )
    public static final void alignCellTextHorizontal(
        @ParamMetaData(type = CronapiMetaData.ObjectType.STRING, description = "{{rowNumber}}") Var rowNumber,
        @ParamMetaData(type = CronapiMetaData.ObjectType.STRING, description = "{{columnNumber}}") Var columnNumber,
        @ParamMetaData(type = CronapiMetaData.ObjectType.STRING, description = "{{sheet}}") Var sheet,
        @ParamMetaData(type = CronapiMetaData.ObjectType.STRING, description = "{{alignType}}",
            blockType = "util_dropdown",
            values = {
                "{{alignTypeLeft}}", "{{alignTypeCenter}}", "{{alignTypeRight}}"
            },
            keys = {
                "1", "2", "3"
            }
        ) Var alignType
    ) {

        Row row = sheet.getTypedObject(XSSFSheet.class).getRow(rowNumber.getObjectAsInt());
        if (row == null) {
            row = sheet.getTypedObject(XSSFSheet.class).createRow(rowNumber.getObjectAsInt());
        }

        Cell cell = row.getCell(columnNumber.getObjectAsInt());
        if (cell == null) {
            cell = row.createCell(columnNumber.getObjectAsInt());
        }

        CellStyle style = cell.getCellStyle();

        style.setAlignment(HorizontalAlignment.forInt(alignType.getObjectAsInt()));
        cell.setCellStyle(style);
    }

    @CronapiMetaData(
        name = "{{alignCellTextVertical}}",
        description = "{{alignCellTextVerticalDescription}}",
        nameTags = {"Alinhamento Vertical", "Alinhamento", "Align Vertical", "Align"},
        returnType = CronapiMetaData.ObjectType.VOID
    )
    public static final void alignCellTextVertical(
        @ParamMetaData(type = CronapiMetaData.ObjectType.STRING, description = "{{rowNumber}}") Var rowNumber,
        @ParamMetaData(type = CronapiMetaData.ObjectType.STRING, description = "{{columnNumber}}") Var columnNumber,
        @ParamMetaData(type = CronapiMetaData.ObjectType.STRING, description = "{{sheet}}") Var sheet,
        @ParamMetaData(type = CronapiMetaData.ObjectType.STRING, description = "{{alignType}}",
            blockType = "util_dropdown",
            values = {
                "{{alignTypeVerticalTop}}", "{{alignTypeVerticalCenter}}",
                "{{alignTypeVerticalBottom}}", "{{alignTypeVerticalJustify}}"
            },
            keys = {
                "0", "1", "2", "3"
            }
        ) Var alignType
    ) {

        Row row = sheet.getTypedObject(XSSFSheet.class).getRow(rowNumber.getObjectAsInt());
        if (row == null) {
            row = sheet.getTypedObject(XSSFSheet.class).createRow(rowNumber.getObjectAsInt());
        }

        Cell cell = row.getCell(columnNumber.getObjectAsInt());
        if (cell == null) {
            cell = row.createCell(columnNumber.getObjectAsInt());
        }

        CellStyle style = cell.getCellStyle();

        style.setVerticalAlignment(VerticalAlignment.forInt(alignType.getObjectAsInt()));
        cell.setCellStyle(style);
    }

    @CronapiMetaData(
        name = "{{setFontProperties}}",
        description = "{{setFontPropertiesDescription}}",
        nameTags = {"Definir Fonte", "Propriedades da Fonte", "Set Font", "Font Properties"},
        returnType = CronapiMetaData.ObjectType.VOID
    )
    public static final void setFontProperties(
        @ParamMetaData(type = CronapiMetaData.ObjectType.STRING, description = "{{rowNumber}}") Var rowNumber,
        @ParamMetaData(type = CronapiMetaData.ObjectType.STRING, description = "{{columnNumber}}") Var columnNumber,
        @ParamMetaData(type = CronapiMetaData.ObjectType.STRING, description = "{{sheet}}") Var sheet,
        @ParamMetaData(type = CronapiMetaData.ObjectType.STRING, description = "{{fontType}}",
            blockType = "util_dropdown",
            values = {
                "{{fontTypeItalic}}", "{{fontTypeBold}}", "{{fontTypeUnderline}}", "{{fontTypeStrikeout}}"
            },
            keys = {
                "0", "1", "2", "3"
            }
        ) Var fontType,
        @ParamMetaData(type = CronapiMetaData.ObjectType.STRING, description = "{{fontColor}}",
            blockType = "util_dropdown",
            values = {
                    "{{fontColorYellow}}", "{{fontColorWhite}}", "{{fontColorRed}}",
                    "{{fontColorPink}}", "{{fontColorGreen}}", "{{fontColorOrange}}",
                    "{{fontColorMagenta}}", "{{fontColorGray1}}", "{{fontColorGray}}",
                    "{{fontColorGray2}}", "{{fontColorBlue1}}", "{{fontColorBlue}}", "{{fontColorBlack}}"
            },
            keys = {
                    "13", "9", "10", "14", "17", "53", "6", "22", "23", "63", "49", "12", "8", "14"
            }
        ) Var fontColor
    ) {

        Row row = sheet.getTypedObject(XSSFSheet.class).getRow(rowNumber.getObjectAsInt());
        if (row == null) {
            row = sheet.getTypedObject(XSSFSheet.class).createRow(rowNumber.getObjectAsInt());
        }

        Cell cell = row.getCell(columnNumber.getObjectAsInt());
        if (cell == null) {
            cell = row.createCell(columnNumber.getObjectAsInt());
        }
        XSSFWorkbook workbook = sheet.getTypedObject(XSSFSheet.class).getWorkbook();
        CellStyle style = workbook.createCellStyle();
        style.cloneStyleFrom(cell.getCellStyle());
        XSSFFont font = workbook.createFont();

        switch (fontType.getObjectAsString()) {
            case "0":
                font.setItalic(true);
                break;
            case "1":
                font.setBold(true);
                break;
            case "2":
                font.setUnderline(XSSFFont.U_SINGLE);
                break;
            case "3":
                font.setStrikeout(true);
                break;
        }

        font.setColor(IndexedColors.fromInt(fontColor.getObjectAsInt()).getIndex());

        style.setFont(font);
        cell.setCellStyle(style);
    }

    @CronapiMetaData(
        name = "{{setBorder}}",
        description = "{{setBorderDescription}}",
        nameTags = {"Tipo de Borda", "Borda", "Set Border", "Border Type"},
        returnType = CronapiMetaData.ObjectType.VOID
    )
    public static final void setBorder(
        @ParamMetaData(type = CronapiMetaData.ObjectType.STRING, description = "{{rowNumber}}") Var rowNumber,
        @ParamMetaData(type = CronapiMetaData.ObjectType.STRING, description = "{{columnNumber}}") Var columnNumber,
        @ParamMetaData(type = CronapiMetaData.ObjectType.STRING, description = "{{sheet}}") Var sheet,
        @ParamMetaData(type = CronapiMetaData.ObjectType.STRING, description = "{{borderType}}",
            blockType = "util_dropdown",
            values = {
                "{{borderTypeDotted}}", "{{borderTypeDashed}}", "{{borderTypeThick}}", "{{borderTypeThin}}"
            },
            keys = {
                "0", "1", "2", "3"
            }
        ) Var borderType
    ) {

        Row row = sheet.getTypedObject(XSSFSheet.class).getRow(rowNumber.getObjectAsInt());
        if (row == null) {
            row = sheet.getTypedObject(XSSFSheet.class).createRow(rowNumber.getObjectAsInt());
        }

        Cell cell = row.getCell(columnNumber.getObjectAsInt());
        if (cell == null) {
            cell = row.createCell(columnNumber.getObjectAsInt());
        }

        CellStyle style = sheet.getTypedObject(XSSFSheet.class).getWorkbook().createCellStyle();
        style.cloneStyleFrom(cell.getCellStyle());

        switch (borderType.getObjectAsString()) {
            case "0":
                style.setBorderRight(BorderStyle.DOTTED);
                style.setBorderLeft(BorderStyle.DOTTED);
                style.setBorderTop(BorderStyle.DOTTED);
                style.setBorderBottom(BorderStyle.DOTTED);
                break;
            case "1":
                style.setBorderRight(BorderStyle.DASHED);
                style.setBorderLeft(BorderStyle.DASHED);
                style.setBorderTop(BorderStyle.DASHED);
                style.setBorderBottom(BorderStyle.DASHED);
                break;
            case "2":
                style.setBorderRight(BorderStyle.THICK);
                style.setBorderLeft(BorderStyle.THICK);
                style.setBorderTop(BorderStyle.THICK);
                style.setBorderBottom(BorderStyle.THICK);
                break;
            case "3":
                style.setBorderRight(BorderStyle.THIN);
                style.setBorderLeft(BorderStyle.THIN);
                style.setBorderTop(BorderStyle.THIN);
                style.setBorderBottom(BorderStyle.THIN);
                break;
        }

        cell.setCellStyle(style);
    }

    @CronapiMetaData(
        name = "{{setBorderColor}}",
        description = "{{setBorderColorDescription}}",
        nameTags = {"Cor da Borda", "Borda", "Border Color", "Border"},
        returnType = CronapiMetaData.ObjectType.VOID
    )
    public static final void setBorderColor(
        @ParamMetaData(type = CronapiMetaData.ObjectType.STRING, description = "{{rowNumber}}") Var rowNumber,
        @ParamMetaData(type = CronapiMetaData.ObjectType.STRING, description = "{{columnNumber}}") Var columnNumber,
        @ParamMetaData(type = CronapiMetaData.ObjectType.STRING, description = "{{sheet}}") Var sheet,
        @ParamMetaData(type = CronapiMetaData.ObjectType.STRING, description = "{{colorType}}",
            blockType = "util_dropdown",
            values = {
                    "{{fontColorYellow}}", "{{fontColorWhite}}", "{{fontColorRed}}",
                    "{{fontColorPink}}", "{{fontColorGreen}}", "{{fontColorOrange}}",
                    "{{fontColorMagenta}}", "{{fontColorGray1}}", "{{fontColorGray}}",
                    "{{fontColorGray2}}", "{{fontColorBlue1}}", "{{fontColorBlue}}", "{{fontColorBlack}}"
            },
            keys = {
                    "13", "9", "10", "14", "17", "53", "6", "22", "23", "63", "49", "12", "8", "14", "17"
            }
        ) Var colorType
    ) {

        Row row = sheet.getTypedObject(XSSFSheet.class).getRow(rowNumber.getObjectAsInt());
        if (row == null) {
            row = sheet.getTypedObject(XSSFSheet.class).createRow(rowNumber.getObjectAsInt());
        }

        Cell cell = row.getCell(columnNumber.getObjectAsInt());
        if (cell == null) {
            cell = row.createCell(columnNumber.getObjectAsInt());
        }

        CellStyle style = sheet.getTypedObject(XSSFSheet.class).getWorkbook().createCellStyle();
        style.cloneStyleFrom(cell.getCellStyle());

        style.setTopBorderColor(IndexedColors.fromInt(colorType.getObjectAsInt()).getIndex());
        style.setRightBorderColor(IndexedColors.fromInt(colorType.getObjectAsInt()).getIndex());
        style.setLeftBorderColor(IndexedColors.fromInt(colorType.getObjectAsInt()).getIndex());
        style.setBottomBorderColor(IndexedColors.fromInt(colorType.getObjectAsInt()).getIndex());

        cell.setCellStyle(style);
    }

    @CronapiMetaData(
        name = "{{setBackgroundColor}}",
        description = "{{setBackgroundColorDescription}}",
        nameTags = {"Cor de Preenchimento", "Preenchimento", "Background Color", "Color"},
        returnType = CronapiMetaData.ObjectType.VOID
    )
    public static final void setBackgroundColor(
        @ParamMetaData(type = CronapiMetaData.ObjectType.STRING, description = "{{rowNumber}}") Var rowNumber,
        @ParamMetaData(type = CronapiMetaData.ObjectType.STRING, description = "{{columnNumber}}") Var columnNumber,
        @ParamMetaData(type = CronapiMetaData.ObjectType.STRING, description = "{{sheet}}") Var sheet,
        @ParamMetaData(type = CronapiMetaData.ObjectType.STRING, description = "{{colorType}}",
            blockType = "util_dropdown",
            values = {
                    "{{fontColorYellow}}", "{{fontColorWhite}}", "{{fontColorRed}}",
                    "{{fontColorPink}}", "{{fontColorGreen}}", "{{fontColorOrange}}",
                    "{{fontColorMagenta}}", "{{fontColorGray1}}", "{{fontColorGray}}",
                    "{{fontColorGray2}}", "{{fontColorBlue1}}", "{{fontColorBlue}}", "{{fontColorBlack}}"
            },
            keys = {
                "13", "9", "10", "14", "17", "53", "6", "22", "23", "63", "49", "12", "8", "14", "17"
            }
        ) Var cellColor,
        @ParamMetaData(type = CronapiMetaData.ObjectType.STRING, description = "{{fillPattern}}",
            blockType = "util_dropdown",
            values = {
                "{{fillPatternNone}}", "{{fillPatternSolidForeground}}", "{{fillPatternFineDots}}",
                "{{fillPatternAltBars}}", "{{fillPatternSparseDots}}", "{{fillPatternThickHorzBands}}",
                "{{fillPatternThickVertBands}}"
            },
            keys = {
                "0", "1", "2", "3", "4", "5", "6"
            }
        ) Var fillPattern
    ) {

        Row row = sheet.getTypedObject(XSSFSheet.class).getRow(rowNumber.getObjectAsInt());
        if (row == null) {
            row = sheet.getTypedObject(XSSFSheet.class).createRow(rowNumber.getObjectAsInt());
        }

        Cell cell = row.getCell(columnNumber.getObjectAsInt());
        if (cell == null) {
            cell = row.createCell(columnNumber.getObjectAsInt());
        }

        CellStyle style = sheet.getTypedObject(XSSFSheet.class).getWorkbook().createCellStyle();
        style.cloneStyleFrom(cell.getCellStyle());

        style.setFillBackgroundColor(IndexedColors.fromInt(cellColor.getObjectAsInt()).getIndex());
        style.setFillPattern(FillPatternType.forInt(fillPattern.getObjectAsInt()));

        cell.setCellStyle(style);
    }

    @CronapiMetaData(
        name = "{{createLineWithContentSet}}",
        description = "{{createLineWithContentSetDescription}}",
        nameTags = {"Criar Linha", "Linha", "Create Line", "Line"},
        returnType = CronapiMetaData.ObjectType.UNKNOWN
    )
    public static final void createLineWithValueSet(
        @ParamMetaData(type = CronapiMetaData.ObjectType.STRING, description = "{{sheet}}") Var sheet,
        @ParamMetaData(type = CronapiMetaData.ObjectType.STRING, description = "{{rowNumber}}") Var rowNumber,
        @ParamMetaData(type = CronapiMetaData.ObjectType.OBJECT, description = "{{contentSheet}}") Var name
    ) {
        Row row = sheet.getTypedObject(XSSFSheet.class).createRow(rowNumber.getObjectAsInt());
        for (int i = 0; i < name.getObjectAsList().size(); i++) {
            Cell cell = row.createCell(i);
            Var listObject =  Var.valueOf(name.getObjectAsList().get(i));
            switch (listObject.getType()) {
                case STRING:
                    cell.setCellValue(listObject.getObjectAsString());
                    break;
                case INT:
                    cell.setCellValue(listObject.getObjectAsInt());
                    break;
                case DOUBLE:
                    cell.setCellValue(listObject.getObjectAsDouble());
                    break;
                case BOOLEAN:
                    cell.setCellValue(listObject.getObjectAsBoolean());
                    break;
                case DATETIME:
                    cell.setCellValue(listObject.getObjectAsDateTime());
                    break;
                default:
                    cell.setCellValue(listObject.getObjectAsString());
            }
        }
    }

    @CronapiMetaData(
        name = "{{createHyperlink}}",
        description = "{{createHyperlinkDescription}}",
        nameTags = {"Criar Hyperlink", "Hyperlink", "Create Hyperlink"},
        returnType = CronapiMetaData.ObjectType.VOID
    )
    public static final void createHyperlink(
        @ParamMetaData(type = CronapiMetaData.ObjectType.STRING, description = "{{rowNumber}}") Var rowNumber,
        @ParamMetaData(type = CronapiMetaData.ObjectType.STRING, description = "{{columnNumber}}") Var columnNumber,
        @ParamMetaData(type = CronapiMetaData.ObjectType.STRING, description = "{{fileExcel}}") Var excel,
        @ParamMetaData(type = CronapiMetaData.ObjectType.STRING, description = "{{sheet}}") Var sheet,
        @ParamMetaData(type = CronapiMetaData.ObjectType.STRING, description = "{{address}}") Var address,
        @ParamMetaData(type = CronapiMetaData.ObjectType.STRING, description = "{{textHyperlink}}") Var text,
        @ParamMetaData(type = CronapiMetaData.ObjectType.STRING, description = "{{hyperlinkType}}",
            blockType = "util_dropdown",
            values = {
                "{{hyperlinkTypeDocument}}", "{{hyperlinkTypeEmail}}", "{{hyperlinkTypeFile}}",
                "{{hyperlinkTypeURL}}", "{{hyperlinkTypeNone}}"
            },
            keys = {
                "DOCUMENT", "EMAIL", "FILE", "URL", "NONE"
            }
        ) Var hyperlinkType
    ) {

        Row row = sheet.getTypedObject(XSSFSheet.class).getRow(rowNumber.getObjectAsInt());
        if (row == null) {
            row = sheet.getTypedObject(XSSFSheet.class).createRow(rowNumber.getObjectAsInt());
        }

        Cell cell = row.getCell(columnNumber.getObjectAsInt());
        if (cell == null) {
            cell = row.createCell(columnNumber.getObjectAsInt());
        }

        Workbook workbook = excel.getTypedObject(Workbook.class);

        CellStyle style = cell.getCellStyle();

        Font fontStyle = workbook.createFont();
        fontStyle.setUnderline(Font.U_SINGLE);
        fontStyle.setColor(IndexedColors.BLUE.getIndex());
        style.setFont(fontStyle);

        cell.setCellValue(text.getObjectAsString());

        Hyperlink link = workbook.getCreationHelper().createHyperlink(HyperlinkType.valueOf(hyperlinkType.getObjectAsString()));


        link.setAddress(address.getObjectAsString());
        cell.setHyperlink(link);
    }

    @CronapiMetaData(
        name = "{{mergeCells}}",
        description = "{{mergeCellsDescription}}",
        nameTags = {"Mesclar", "Célula", "Merge Cells"},
        returnType = CronapiMetaData.ObjectType.VOID
    )
    public static final void mergeCells(
        @ParamMetaData(type = CronapiMetaData.ObjectType.STRING, description = "{{sheet}}") Var sheet,
        @ParamMetaData(type = CronapiMetaData.ObjectType.STRING, description = "{{firstRow}}") Var firstRow,
        @ParamMetaData(type = CronapiMetaData.ObjectType.STRING, description = "{{lastRow}}") Var lastRow,
        @ParamMetaData(type = CronapiMetaData.ObjectType.STRING, description = "{{firstCol}}") Var firstCol,
        @ParamMetaData(type = CronapiMetaData.ObjectType.STRING, description = "{{lastCol}}") Var lastCol
    ) {
        CellRangeAddress range = new CellRangeAddress(firstRow.getObjectAsInt(),
                lastRow.getObjectAsInt(), firstCol.getObjectAsInt(),
                lastCol.getObjectAsInt());
        sheet.getTypedObject(XSSFSheet.class).addMergedRegion(range);
    }

    @CronapiMetaData(
        name = "{{autoSizeColumn}}",
        description = "{{autoSizeColumnDescription}}",
        nameTags = {"Ajustar", "Coluna", "Auto Size"},
        returnType = CronapiMetaData.ObjectType.VOID
    )
    public static final void autoSize(
        @ParamMetaData(type = CronapiMetaData.ObjectType.STRING, description = "{{sheet}}") Var sheet,
        @ParamMetaData(type = CronapiMetaData.ObjectType.STRING, description = "{{columnNumber}}") Var column
    ) {
        sheet.getTypedObject(XSSFSheet.class).autoSizeColumn(column.getObjectAsInt());
    }

    @CronapiMetaData(
        name = "{{saveSpreadSheet}}",
        description = "{{saveSpreadSheetDescription}}",
        nameTags = {"Salvar", "Planilha", "Save", "Spread Sheet"},
        returnType = CronapiMetaData.ObjectType.VOID
    )
    public static final void saveSpreadSheet(
        @ParamMetaData(type = CronapiMetaData.ObjectType.STRING, description = "{{fileExcel}}") Var workbook,
        @ParamMetaData(type = CronapiMetaData.ObjectType.STRING, description = "{{nameDescription}}") Var name,
        @ParamMetaData(type = CronapiMetaData.ObjectType.STRING, description = "{{pathLocation}}") Var path
    ) throws Exception {
        StringBuilder sbPath = new StringBuilder();
        sbPath.append(path.getObjectAsString());
        sbPath.append(File.separator);
        sbPath.append(name.getObjectAsString());
        sbPath.append(".xlsx");

        File arquivo = new File(sbPath.toString());
        FileOutputStream out = new FileOutputStream(arquivo);
        workbook.getTypedObject(XSSFWorkbook.class).write(out);
        out.close();
    }

}
