/*
 * Decompiled with CFR 0.152.
 */
package cronapi.chatbot.whatsapp.type;

import java.util.stream.Stream;

public enum WhatsappMessageTypeEnum {
    LOCATION(1L, "location"),
    TEXT(2L, "text"),
    VIDEO(3L, "video"),
    DOCUMENT(4L, "document"),
    IMAGE(5L, "image");

    private Long code;
    private String description;

    private WhatsappMessageTypeEnum(Long code, String description) {
        this.code = code;
        this.description = description;
    }

    public static WhatsappMessageTypeEnum getByCode(Long code) {
        return Stream.of(WhatsappMessageTypeEnum.values()).filter(whatsappMessageType -> whatsappMessageType.getCode().equals(code)).findFirst().orElseThrow(IllegalArgumentException::new);
    }

    public static WhatsappMessageTypeEnum getByDescription(String description) {
        return Stream.of(WhatsappMessageTypeEnum.values()).filter(whatsappMessageType -> whatsappMessageType.getDescription().equalsIgnoreCase(description)).findFirst().orElseThrow(IllegalArgumentException::new);
    }

    public Long getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }
}

