/*
 * Decompiled with CFR 0.152.
 */
package cronapi.chatbot.telegram;

import com.google.gson.Gson;
import cronapi.Var;
import cronapi.chatbot.ChatBotException;
import cronapi.chatbot.Messenger;
import cronapi.chatbot.elements.Carousel;
import cronapi.chatbot.elements.GroupedButton;
import cronapi.chatbot.elements.LabelUrl;
import cronapi.chatbot.elements.Location;
import cronapi.chatbot.elements.QuickReply;
import cronapi.chatbot.elements.WebView;
import cronapi.json.Operations;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.telegram.telegrambots.bots.DefaultAbsSender;
import org.telegram.telegrambots.bots.DefaultBotOptions;
import org.telegram.telegrambots.meta.api.methods.ActionType;
import org.telegram.telegrambots.meta.api.methods.BotApiMethod;
import org.telegram.telegrambots.meta.api.methods.send.SendChatAction;
import org.telegram.telegrambots.meta.api.methods.send.SendDocument;
import org.telegram.telegrambots.meta.api.methods.send.SendLocation;
import org.telegram.telegrambots.meta.api.methods.send.SendMessage;
import org.telegram.telegrambots.meta.api.methods.send.SendPhoto;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.InlineKeyboardMarkup;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.ReplyKeyboard;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.buttons.InlineKeyboardButton;
import org.telegram.telegrambots.meta.exceptions.TelegramApiException;

@Component
public class TelegramMessenger
extends DefaultAbsSender
implements Messenger {
    private final String token;
    private final String url;
    private final Boolean typingIndicator;

    public static TelegramMessenger create() {
        try {
            InputStream inputStream = TelegramMessenger.class.getResourceAsStream("/META-INF/chatbot.json");
            Var json = Operations.toJson((Var)Var.valueOf((Object)IOUtils.toString((InputStream)inputStream)));
            String token = json.getObjectAsJson().getAsJsonObject().get("chatbot").getAsJsonObject().get("telegram").getAsJsonObject().get("token").toString().replace("\"", "");
            String url = json.getObjectAsJson().getAsJsonObject().get("chatbot").getAsJsonObject().get("telegram").getAsJsonObject().get("url").toString().replace("\"", "");
            Boolean typingIndicator = json.getObjectAsJson().getAsJsonObject().get("chatbot").getAsJsonObject().get("telegram").getAsJsonObject().get("typingIndicator").getAsBoolean();
            return new TelegramMessenger(token, url, typingIndicator);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @Autowired
    public TelegramMessenger(@Value(value="${chatbot.telegram.token}") String token, @Value(value="${chatbot.telegram.url}") String url, @Value(value="${chatbot.telegram.typingIndicator}") Boolean typingIndicator) {
        super(new DefaultBotOptions());
        this.token = token;
        this.url = url;
        this.typingIndicator = typingIndicator;
        this.setWebhook();
    }

    private void setWebhook() {
        try (CloseableHttpClient httpclient = HttpClientBuilder.create().build();){
            String requestUrl = this.getOptions().getBaseUrl() + this.token + "/" + "setwebhook";
            HttpPost httppost = new HttpPost(requestUrl);
            httppost.setConfig(this.getOptions().getRequestConfig());
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            builder.addTextBody("url", this.url);
            HttpEntity multipart = builder.build();
            httppost.setEntity(multipart);
            try (CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httppost);){
                HttpEntity ht = response.getEntity();
                BufferedHttpEntity buf = new BufferedHttpEntity(ht);
                String responseContent = EntityUtils.toString((HttpEntity)buf, (Charset)StandardCharsets.UTF_8);
                JSONObject jsonObject = new JSONObject(responseContent);
                if (!jsonObject.getBoolean("ok")) {
                    throw new ChatBotException("Error setting webhook" + jsonObject);
                }
            }
        }
        catch (JSONException e) {
            throw new ChatBotException("Error deserializing setWebhook method response", e);
        }
        catch (IOException e) {
            throw new ChatBotException("Error executing setWebook method", e);
        }
    }

    private InlineKeyboardMarkup quickReplyToInlineKeyboardMarkup(List<QuickReply> quickReplyList) {
        ArrayList<InlineKeyboardButton> inlineKeyboardRow = new ArrayList<InlineKeyboardButton>();
        for (QuickReply quickReply : quickReplyList) {
            InlineKeyboardButton inlineKeyboardButton = new InlineKeyboardButton();
            inlineKeyboardButton.setText(quickReply.getText());
            Object data = quickReply.getData();
            String url = quickReply.getUrl();
            if (data != null) {
                if (data instanceof String) {
                    inlineKeyboardButton.setCallbackData(data.toString());
                } else {
                    inlineKeyboardButton.setCallbackData(new Gson().toJson(data));
                }
            } else if (url != null) {
                inlineKeyboardButton.setUrl(url);
            }
            inlineKeyboardRow.add(inlineKeyboardButton);
        }
        InlineKeyboardMarkup replyMarkup = new InlineKeyboardMarkup();
        ArrayList<ArrayList<InlineKeyboardButton>> inlineKeyboard = new ArrayList<ArrayList<InlineKeyboardButton>>();
        inlineKeyboard.add(inlineKeyboardRow);
        replyMarkup.setKeyboard(inlineKeyboard);
        return replyMarkup;
    }

    private InlineKeyboardMarkup quickReplyToInlineKeyboardMarkupRow(List<QuickReply> quickReplyList) {
        ArrayList inlineKeyboard = new ArrayList();
        for (QuickReply quickReply : quickReplyList) {
            ArrayList<InlineKeyboardButton> inlineKeyboardRow = new ArrayList<InlineKeyboardButton>();
            InlineKeyboardButton inlineKeyboardButton = new InlineKeyboardButton();
            inlineKeyboardButton.setText(quickReply.getText());
            Object data = quickReply.getData();
            String url = quickReply.getUrl();
            if (data != null) {
                if (data instanceof String) {
                    inlineKeyboardButton.setCallbackData(data.toString());
                } else {
                    inlineKeyboardButton.setCallbackData(new Gson().toJson(data));
                }
            } else if (url != null) {
                inlineKeyboardButton.setUrl(url);
            }
            inlineKeyboardRow.add(inlineKeyboardButton);
            inlineKeyboard.add(inlineKeyboardRow);
        }
        InlineKeyboardMarkup replyMarkup = new InlineKeyboardMarkup();
        replyMarkup.setKeyboard(inlineKeyboard);
        return replyMarkup;
    }

    private SendMessage getSendMessage(String conversationId, String message) {
        SendMessage sendMessage = new SendMessage();
        sendMessage.setChatId(conversationId);
        sendMessage.setText(message);
        return sendMessage;
    }

    @Override
    public String getPlatform() {
        return "Telegram";
    }

    @Override
    public void sendLocation(String conversationId, Location location) {
        try {
            SendLocation sendLocation = new SendLocation();
            sendLocation.setLatitude(location.getLatitude());
            sendLocation.setLongitude(location.getLongitude());
            sendLocation.setChatId(conversationId);
            this.execute((BotApiMethod)sendLocation);
        }
        catch (TelegramApiException e) {
            throw new ChatBotException(e);
        }
    }

    @Override
    public void sendCarousel(String conversationId, List<Carousel> carouselList) {
        try {
            for (Carousel carousel : carouselList) {
                SendPhoto sendPhoto = new SendPhoto();
                sendPhoto.setChatId(conversationId);
                sendPhoto.setCaption(carousel.getMessage());
                sendPhoto.setPhoto(carousel.getImage());
                List<QuickReply> quickReplyList = carousel.getQuickReply();
                if (quickReplyList != null) {
                    for (QuickReply quickReply : quickReplyList) {
                        sendPhoto.setReplyMarkup((ReplyKeyboard)this.quickReplyToInlineKeyboardMarkup(quickReplyList));
                        if (this.url == null) continue;
                        sendPhoto.setReplyMarkup((ReplyKeyboard)this.quickReplyToInlineKeyboardMarkupRow(quickReplyList));
                        break;
                    }
                }
                this.execute(sendPhoto);
            }
        }
        catch (TelegramApiException e) {
            throw new ChatBotException(e);
        }
    }

    @Override
    public void sendQuickReply(String conversationId, String text, List<QuickReply> quickReply) {
        try {
            SendMessage sendMessage = this.getSendMessage(conversationId, text);
            sendMessage.setReplyMarkup((ReplyKeyboard)this.quickReplyToInlineKeyboardMarkup(quickReply));
            this.execute((BotApiMethod)sendMessage);
        }
        catch (TelegramApiException e) {
            throw new ChatBotException(e);
        }
    }

    @Override
    public void sendTextMessage(String conversationId, String text) {
        if (StringUtils.isEmpty((String)text)) {
            return;
        }
        try {
            SendMessage sendMessage = this.getSendMessage(conversationId, text);
            this.execute((BotApiMethod)sendMessage);
        }
        catch (TelegramApiException e) {
            throw new ChatBotException(e);
        }
    }

    @Override
    public void sendTypingOn(String conversationId) {
        if (this.typingIndicator.booleanValue()) {
            try {
                SendChatAction sendChatAction = new SendChatAction();
                sendChatAction.setChatId(conversationId);
                sendChatAction.setAction(ActionType.TYPING);
                this.execute((BotApiMethod)sendChatAction);
            }
            catch (TelegramApiException e) {
                throw new ChatBotException(e);
            }
        }
    }

    @Override
    public void sendTypingOff(String conversationId) {
    }

    public String getBotToken() {
        return this.token;
    }

    @Override
    public void sendButtonMessage(String conversationId, GroupedButton groupedButton) {
        try {
            InlineKeyboardMarkup inlineKeyboardMarkup = new InlineKeyboardMarkup();
            ArrayList rowsInline = new ArrayList();
            for (LabelUrl button : groupedButton.getButtons()) {
                ArrayList<InlineKeyboardButton> row = new ArrayList<InlineKeyboardButton>();
                row.add(new InlineKeyboardButton().setText(button.getLabel()).setUrl(button.getUrl()));
                rowsInline.add(row);
            }
            inlineKeyboardMarkup.setKeyboard(rowsInline);
            SendMessage sendMessage = this.getSendMessage(conversationId, groupedButton.getMessage());
            sendMessage.setReplyMarkup((ReplyKeyboard)inlineKeyboardMarkup);
            this.execute((BotApiMethod)sendMessage);
        }
        catch (TelegramApiException e) {
            throw new ChatBotException(e);
        }
    }

    @Override
    public void sendFileMessage(String conversationId, List<LabelUrl> labelUrlList) {
        labelUrlList.forEach(labelUrl -> {
            try {
                SendDocument sendDocument = new SendDocument();
                sendDocument.setChatId(conversationId);
                sendDocument.setDocument(labelUrl.getUrl());
                sendDocument.setCaption(labelUrl.getLabel());
                this.execute(sendDocument);
            }
            catch (TelegramApiException e) {
                throw new ChatBotException(e);
            }
        });
    }

    @Override
    public void sendImageMessage(String conversationId, List<LabelUrl> labelUrlList) {
        labelUrlList.forEach(labelUrl -> {
            try {
                SendPhoto sendPhotoRequest = new SendPhoto();
                sendPhotoRequest.setChatId(conversationId);
                sendPhotoRequest.setPhoto(labelUrl.getUrl());
                this.execute(sendPhotoRequest);
            }
            catch (TelegramApiException e) {
                throw new ChatBotException(e);
            }
        });
    }

    @Override
    public void sendWebView(String conversationId, WebView webView) {
        GroupedButton groupedButton = new GroupedButton();
        groupedButton.setButtons(new ArrayList<LabelUrl>());
        groupedButton.setMessage(Objects.isNull(webView.getMessagesButtons()) ? webView.getMessage() : webView.getMessagesButtons());
        LabelUrl labelUrl = new LabelUrl();
        labelUrl.setLabel(webView.getMessage());
        labelUrl.setUrl(webView.getUrl());
        groupedButton.getButtons().add(labelUrl);
        this.sendButtonMessage(conversationId, groupedButton);
    }

    public String toString() {
        return super.toString();
    }
}

