/*
 * Decompiled with CFR 0.152.
 */
package cronapi.chatbot.blockly;

import com.ibm.watson.assistant.v1.model.MessageResponse;
import cronapi.CronapiMetaData;
import cronapi.chatbot.Messenger;
import cronapi.chatbot.cronchat.CronchatMessenger;
import cronapi.chatbot.elements.Carousel;
import cronapi.chatbot.elements.GroupedButton;
import cronapi.chatbot.elements.LabelUrl;
import cronapi.chatbot.elements.Location;
import cronapi.chatbot.elements.QuickReply;
import cronapi.chatbot.elements.WebView;
import cronapi.chatbot.facebook.FacebookMessenger;
import cronapi.chatbot.telegram.TelegramMessenger;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Value;

@CronapiMetaData
public class ChatBotOperations {
    @Value(value="${chatbot.telegram.token}")
    private static String token = null;
    @Value(value="${chatbot.telegram.url}")
    private static String url = null;
    @Value(value="${chatbot.telegram.typingIndicator}")
    private static Boolean typingIndicator = null;

    @CronapiMetaData
    public static void sendWatsonMessage(Messenger messenger, String conversationId, MessageResponse messageResponse) {
        messenger.sendWatsonMessage(conversationId, messageResponse);
    }

    @CronapiMetaData
    public static void sendLocation(Messenger messenger, String conversationId, Location location) {
        messenger.sendLocation(conversationId, location);
    }

    @CronapiMetaData
    public static void sendCarousel(Messenger messenger, String conversationId, List<Carousel> carousel) {
        messenger.sendCarousel(conversationId, carousel);
    }

    @CronapiMetaData
    public static void sendCarousel(Messenger messenger, String conversationId, Carousel carousel) {
        ArrayList<Carousel> carouselList = new ArrayList<Carousel>();
        carouselList.add(carousel);
        ChatBotOperations.sendCarousel(messenger, conversationId, carouselList);
    }

    @CronapiMetaData
    public static void sendQuickReply(Messenger messenger, String conversationId, String text, List<QuickReply> quickReply) {
        messenger.sendQuickReply(conversationId, text, quickReply);
    }

    @CronapiMetaData
    public static void sendQuickReply(Messenger messenger, String conversationId, String text, QuickReply quickReply) {
        ArrayList<QuickReply> quickReplyList = new ArrayList<QuickReply>();
        quickReplyList.add(quickReply);
        ChatBotOperations.sendQuickReply(messenger, conversationId, text, quickReplyList);
    }

    @CronapiMetaData
    public static void sendTextMessage(String conversationId, String text, String platform) throws ClassNotFoundException {
        Messenger messenger = null;
        if (platform.equalsIgnoreCase("Telegram")) {
            messenger = TelegramMessenger.create();
        }
        if (platform.equalsIgnoreCase("Facebook")) {
            messenger = FacebookMessenger.create();
        }
        if (platform.equalsIgnoreCase("Cronchat")) {
            messenger = CronchatMessenger.create();
        }
        messenger.sendTextMessage(conversationId, text);
    }

    @CronapiMetaData
    public static void sendTypingOn(Messenger messenger, String conversationId) {
        messenger.sendTypingOn(conversationId);
    }

    @CronapiMetaData
    public static void sendTypingOff(Messenger messenger, String conversationId) {
        messenger.sendTypingOff(conversationId);
    }

    @CronapiMetaData
    public static void sendImageMessage(Messenger messenger, String conversationId, List<LabelUrl> labelUrlList) {
        messenger.sendImageMessage(conversationId, labelUrlList);
    }

    @CronapiMetaData
    public static void sendImageMessage(Messenger messenger, String conversationId, LabelUrl labelUrl) {
        ArrayList<LabelUrl> labelUrls = new ArrayList<LabelUrl>();
        ChatBotOperations.sendImageMessage(messenger, conversationId, labelUrls);
    }

    @CronapiMetaData
    public static void sendFileMessage(Messenger messenger, String conversationId, List<LabelUrl> labelUrlList) {
        messenger.sendFileMessage(conversationId, labelUrlList);
    }

    @CronapiMetaData
    public static void sendFileMessage(Messenger messenger, String conversationId, LabelUrl labelUrl) {
        ArrayList<LabelUrl> labelUrlList = new ArrayList<LabelUrl>();
        ChatBotOperations.sendFileMessage(messenger, conversationId, labelUrlList);
    }

    @CronapiMetaData
    public static void sendButtonMessage(Messenger messenger, String conversationId, GroupedButton groupedButton) {
        messenger.sendButtonMessage(conversationId, groupedButton);
    }

    @CronapiMetaData
    public static void sendWebView(Messenger messenger, String conversationId, WebView webView) {
        messenger.sendWebView(conversationId, webView);
    }
}

