/*
 * Decompiled with CFR 0.152.
 */
package cronapi.chatbot.whatsapp;

import cronapi.chatbot.ChatBotException;
import cronapi.chatbot.Messenger;
import cronapi.chatbot.elements.Carousel;
import cronapi.chatbot.elements.GroupedButton;
import cronapi.chatbot.elements.LabelUrl;
import cronapi.chatbot.elements.Location;
import cronapi.chatbot.elements.QuickReply;
import cronapi.chatbot.elements.WebView;
import cronapi.chatbot.whatsapp.type.RecipientTypeEnum;
import cronapi.chatbot.whatsapp.type.WhatsappMessageTypeEnum;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.util.Base64;
import java.util.List;
import java.util.Objects;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.stereotype.Component;

@Component
public class WhatsappMessager
implements Messenger {
    private String token;
    private LocalDateTime localDateTime;
    private String urlWhatsApp;
    private String urlWhatsAppApi;
    private String whatsAppUser;
    private String whatsAppPassword;

    @Override
    public String getPlatform() {
        return "WhatsApp";
    }

    @Override
    public void sendLocation(String conversationId, Location location) {
        try {
            JSONObject jsonObject = this.startMessageIndividual(conversationId, WhatsappMessageTypeEnum.LOCATION);
            JSONObject jsonObjectLocation = new JSONObject();
            jsonObjectLocation.put("longitude", (Object)location.getLongitude());
            jsonObjectLocation.put("latitude", (Object)location.getLatitude());
            jsonObjectLocation.put("name", (Object)location.getTitle());
            jsonObjectLocation.put("address", (Object)location.getAddress());
            jsonObject.put(WhatsappMessageTypeEnum.LOCATION.getDescription(), (Object)jsonObjectLocation);
            this.setJsonCallWhatsapp(conversationId, jsonObject, "/v1/messages");
        }
        catch (Exception e) {
            throw new ChatBotException(e);
        }
    }

    @Override
    public void sendCarousel(String conversationId, List<Carousel> carousel) {
    }

    @Override
    public void sendQuickReply(String conversationId, String text, List<QuickReply> quickReply) {
    }

    @Override
    public void sendTextMessage(String conversationId, String text) {
        try {
            JSONObject jsonObject = this.startMessageIndividual(conversationId, WhatsappMessageTypeEnum.TEXT);
            jsonObject.put(WhatsappMessageTypeEnum.TEXT.getDescription(), (Object)new JSONObject().put("body", (Object)text));
            this.setJsonCallWhatsapp(conversationId, jsonObject, "/v1/messages");
        }
        catch (Exception e) {
            throw new ChatBotException(e);
        }
    }

    @Override
    public void sendTypingOn(String conversationId) {
    }

    @Override
    public void sendTypingOff(String conversationId) {
    }

    @Override
    public void sendImageMessage(String conversationId, List<LabelUrl> labelUrlList) {
        try {
            JSONObject jsonObject = this.startMessageIndividual(conversationId, WhatsappMessageTypeEnum.IMAGE);
            labelUrlList.forEach(labelUrl -> {
                JSONObject jsonObjectImagem = new JSONObject();
                try {
                    jsonObjectImagem.put("link", (Object)labelUrl.getUrl());
                    jsonObjectImagem.put("caption", (Object)labelUrl.getLabel());
                    jsonObject.put(WhatsappMessageTypeEnum.IMAGE.getDescription(), (Object)jsonObjectImagem);
                }
                catch (Exception e) {
                    throw new ChatBotException(e);
                }
            });
            this.setJsonCallWhatsapp(conversationId, jsonObject, "/v1/messages");
        }
        catch (Exception e) {
            throw new ChatBotException(e);
        }
    }

    @Override
    public void sendFileMessage(String conversationId, List<LabelUrl> labelUrlList) {
        try {
            JSONObject jsonObject = this.startMessageIndividual(conversationId, WhatsappMessageTypeEnum.DOCUMENT);
            labelUrlList.forEach(labelUrl -> {
                try {
                    JSONObject jsonObjectDocument = new JSONObject();
                    String[] urlSplited = labelUrl.getUrl().split("/");
                    String label = urlSplited[urlSplited.length - 1];
                    jsonObjectDocument.put("caption", (Object)label);
                    jsonObjectDocument.put("link", (Object)labelUrl.getUrl());
                    jsonObjectDocument.put("filename", (Object)label);
                    jsonObject.put(WhatsappMessageTypeEnum.DOCUMENT.getDescription(), (Object)new JSONObject().put("id", (Object)jsonObjectDocument));
                    this.setJsonCallWhatsapp(conversationId, jsonObject, "/v1/messages");
                }
                catch (Exception e) {
                    throw new ChatBotException(e);
                }
            });
        }
        catch (Exception e) {
            throw new ChatBotException(e);
        }
    }

    @Override
    public void sendButtonMessage(String conversationId, GroupedButton groupedButton) {
    }

    @Override
    public void sendWebView(String conversationId, WebView webView) {
    }

    private void setJsonCallWhatsapp(String conversationId, JSONObject jsonObject, String webhookMethod) {
        this.callWhatsapp(webhookMethod, jsonObject, "Bearer ".concat(this.token));
    }

    private void callWhatsapp(String webhookMethod, JSONObject content, String authorization) {
        try (CloseableHttpClient httpclient = HttpClientBuilder.create().build();){
            String requestUrl = this.urlWhatsAppApi + webhookMethod;
            HttpPost httppost = new HttpPost(requestUrl);
            httppost.setHeader("Accept", "application/json");
            httppost.setHeader("Content-type", "application/json");
            httppost.setHeader("Authorization", authorization);
            if (Objects.nonNull(content)) {
                StringEntity entity = new StringEntity(content.toString(), "utf-8");
                httppost.setEntity((HttpEntity)entity);
            }
            try (CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httppost);){
                HttpEntity ht = response.getEntity();
                BufferedHttpEntity buf = new BufferedHttpEntity(ht);
                String responseContent = EntityUtils.toString((HttpEntity)buf, (Charset)StandardCharsets.UTF_8);
                JSONObject result = new JSONObject(responseContent);
                if (!result.getBoolean("success")) {
                    throw new ChatBotException(result.getString("errorMessage"));
                }
            }
        }
        catch (JSONException e) {
            throw new ChatBotException("Error deserializing setWebhook method response", e);
        }
        catch (IOException e) {
            throw new ChatBotException("Error executing setWebook method", e);
        }
    }

    private void setwebHook() {
        this.token = Base64.getEncoder().encodeToString(this.whatsAppUser.concat(":").concat(this.whatsAppPassword).getBytes());
        this.callWhatsapp("/v1/users/login", null, "Basic ".concat(this.token));
    }

    private JSONObject startMessageIndividual(String conversationId, WhatsappMessageTypeEnum whatsappMessageTypeEnum) {
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("to", (Object)conversationId);
            jsonObject.put("type", (Object)whatsappMessageTypeEnum.getDescription());
            jsonObject.put("recipient_type", (Object)RecipientTypeEnum.INDIVIDUAL.getDescription());
            return jsonObject;
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }
}

