/*
 * Decompiled with CFR 0.152.
 */
package cronapi.chatbot.whatsapp;

import cronapi.chatbot.ChatBotException;
import cronapi.chatbot.Messenger;
import cronapi.chatbot.assistant.WatsonAssistant;
import cronapi.chatbot.elements.UserProfile;
import cronapi.chatbot.whatsapp.WhatsappMessager;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/cronapi/chatbot/whatsapp"})
public class WhatsappWebhook {
    private final Messenger messenger;
    private final WatsonAssistant assistant;
    private UserProfile user;

    @Autowired
    public WhatsappWebhook(WhatsappMessager whatsappMessager, WatsonAssistant assistant) {
        this.messenger = whatsappMessager;
        this.assistant = assistant;
    }

    @RequestMapping(method={RequestMethod.GET})
    public ResponseEntity<String> verifyWebhook() {
        return ResponseEntity.ok((Object)"");
    }

    @RequestMapping(method={RequestMethod.POST})
    public ResponseEntity<Void> handleCallback(@RequestBody String payload) {
        try {
            JSONObject json = new JSONObject(payload);
            String conversationId = json.getString("wa_id");
            String text = json.getString("messages");
            this.assistant.handleTextMessage(conversationId, text, this.messenger, this.user);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).build();
        }
        catch (Exception e) {
            throw new ChatBotException(e);
        }
    }
}

