/*
 * Decompiled with CFR 0.152.
 */
package cronapi.chatbot.facebook;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.github.messenger4j.common.WebviewHeightRatio;
import com.github.messenger4j.common.WebviewShareButtonState;
import com.github.messenger4j.exception.MessengerApiException;
import com.github.messenger4j.exception.MessengerIOException;
import com.github.messenger4j.send.MessagePayload;
import com.github.messenger4j.send.MessagingType;
import com.github.messenger4j.send.Payload;
import com.github.messenger4j.send.SenderActionPayload;
import com.github.messenger4j.send.message.Message;
import com.github.messenger4j.send.message.RichMediaMessage;
import com.github.messenger4j.send.message.TemplateMessage;
import com.github.messenger4j.send.message.TextMessage;
import com.github.messenger4j.send.message.quickreply.TextQuickReply;
import com.github.messenger4j.send.message.richmedia.RichMediaAsset;
import com.github.messenger4j.send.message.richmedia.UrlRichMediaAsset;
import com.github.messenger4j.send.message.template.ButtonTemplate;
import com.github.messenger4j.send.message.template.GenericTemplate;
import com.github.messenger4j.send.message.template.Template;
import com.github.messenger4j.send.message.template.button.PostbackButton;
import com.github.messenger4j.send.message.template.button.UrlButton;
import com.github.messenger4j.send.message.template.common.DefaultAction;
import com.github.messenger4j.send.message.template.common.Element;
import com.github.messenger4j.send.senderaction.SenderAction;
import com.google.gson.JsonObject;
import cronapi.Var;
import cronapi.chatbot.ChatBotException;
import cronapi.chatbot.Messenger;
import cronapi.chatbot.elements.Carousel;
import cronapi.chatbot.elements.GroupedButton;
import cronapi.chatbot.elements.LabelUrl;
import cronapi.chatbot.elements.Location;
import cronapi.chatbot.elements.QuickReply;
import cronapi.chatbot.elements.TypeUrl;
import cronapi.chatbot.elements.WebView;
import cronapi.json.Operations;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class FacebookMessenger
implements Messenger {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final Logger LOGGER = Logger.getLogger(FacebookMessenger.class.getName());
    private static final String ERROR_CAROUSEL = "Amount of carousel items is below the minimum required";
    private final com.github.messenger4j.Messenger messenger;
    private final Boolean typingIndicator;

    public static FacebookMessenger create() {
        try {
            InputStream inputStream = FacebookMessenger.class.getResourceAsStream("/META-INF/chatbot.json");
            Var json = Operations.toJson((Var)Var.valueOf((Object)IOUtils.toString((InputStream)inputStream)));
            JsonObject jsonObject = json.getObjectAsJson().getAsJsonObject().get("chatbot").getAsJsonObject().get("facebook").getAsJsonObject();
            String page = jsonObject.get("token").toString();
            String app = jsonObject.get("app").toString();
            String verify = jsonObject.get("verify").toString();
            Boolean typingIndicator = jsonObject.get("typingIndicator").getAsBoolean();
            com.github.messenger4j.Messenger messenger = com.github.messenger4j.Messenger.create((String)page, (String)app, (String)verify);
            return new FacebookMessenger(messenger, typingIndicator);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @Autowired
    public FacebookMessenger(com.github.messenger4j.Messenger messenger, @Value(value="${chatbot.facebook.typingIndicator}") Boolean typingIndicator) {
        this.messenger = messenger;
        this.typingIndicator = typingIndicator;
    }

    @Override
    public String getPlatform() {
        return "Facebook";
    }

    @Override
    public void sendLocation(String conversationId, Location location) {
        ArrayList<Element> elements = new ArrayList<Element>();
        String title = location.getTitle();
        if (title == null) {
            title = "Localiza\u00c3\u00a7\u00c3\u00a3o";
        }
        try {
            elements.add(Element.create((String)title, Optional.empty(), Optional.of(new URL(this.getUrlFromLocation(location, TypeUrl.IMAGE))), Optional.of(DefaultAction.create((URL)new URL(this.getUrlFromLocation(location, TypeUrl.ITEM)))), Optional.empty()));
            GenericTemplate genericTemplate = GenericTemplate.create(elements);
            TemplateMessage templateMessage = TemplateMessage.create((Template)genericTemplate);
            this.messengerSend(conversationId, (Payload)MessagePayload.create((String)conversationId, (MessagingType)MessagingType.RESPONSE, (Message)templateMessage));
        }
        catch (MessengerApiException | MessengerIOException | MalformedURLException e) {
            throw new ChatBotException(e);
        }
    }

    @Override
    public void sendCarousel(String conversationId, List<Carousel> carouselList) {
        try {
            ArrayList<Element> elements = new ArrayList<Element>();
            for (Carousel carousel : carouselList) {
                ArrayList<Object> buttons = new ArrayList<Object>();
                for (QuickReply quickReply : carousel.getQuickReply()) {
                    if (quickReply.getLocation() != null) {
                        buttons.add(UrlButton.create((String)quickReply.getText(), (URL)new URL(this.getUrlFromLocation(quickReply.getLocation(), TypeUrl.ITEM))));
                    } else if (quickReply.getUrl() != null) {
                        buttons.add(UrlButton.create((String)quickReply.getText(), (URL)new URL(quickReply.getUrl())));
                    } else {
                        Object data = quickReply.getData();
                        String payload = data instanceof String ? data.toString() : OBJECT_MAPPER.writeValueAsString(data);
                        buttons.add(PostbackButton.create((String)quickReply.getText(), (String)payload));
                    }
                    if (buttons.size() != 3) continue;
                    break;
                }
                elements.add(Element.create((String)carousel.getMessage(), Optional.empty(), Optional.of(new URL(carousel.getImage())), Optional.empty(), Optional.of(buttons)));
                if (elements.size() != 10) continue;
                break;
            }
            if (elements.size() < 2) {
                LOGGER.warning(() -> String.format(ERROR_CAROUSEL, new Object[0]));
                return;
            }
            GenericTemplate genericTemplate = GenericTemplate.create(elements);
            TemplateMessage templateMessage = TemplateMessage.create((Template)genericTemplate);
            this.messengerSend(conversationId, (Payload)MessagePayload.create((String)conversationId, (MessagingType)MessagingType.RESPONSE, (Message)templateMessage));
        }
        catch (JsonProcessingException | MessengerApiException | MessengerIOException | MalformedURLException e) {
            throw new ChatBotException(e);
        }
    }

    @Override
    public void sendQuickReply(String conversationId, String text, List<QuickReply> quickReplyList) {
        try {
            ArrayList<TextQuickReply> facebookQuickReplyList = new ArrayList<TextQuickReply>();
            for (QuickReply quickReply : quickReplyList) {
                Object data = quickReply.getData();
                String payload = data instanceof String ? data.toString() : OBJECT_MAPPER.writeValueAsString(data);
                facebookQuickReplyList.add(TextQuickReply.create((String)quickReply.getText(), (String)payload));
                if (facebookQuickReplyList.size() != 11) continue;
                break;
            }
            TextMessage message = TextMessage.create((String)text, Optional.of(facebookQuickReplyList), Optional.empty());
            this.messengerSend(conversationId, (Payload)MessagePayload.create((String)conversationId, (MessagingType)MessagingType.RESPONSE, (Message)message));
        }
        catch (JsonProcessingException | MessengerApiException | MessengerIOException e) {
            throw new ChatBotException(e);
        }
    }

    @Override
    public void sendTextMessage(String conversationId, String text) {
        if (StringUtils.isEmpty((String)text)) {
            return;
        }
        try {
            TextMessage textMessage = TextMessage.create((String)text);
            MessagePayload messagePayload = MessagePayload.create((String)conversationId, (MessagingType)MessagingType.RESPONSE, (Message)textMessage);
            this.messengerSend(conversationId, (Payload)messagePayload);
        }
        catch (MessengerApiException | MessengerIOException e) {
            throw new ChatBotException(e);
        }
    }

    @Override
    public void sendTypingOn(String conversationId) {
        this.sendMessengerTyping(conversationId, SenderAction.TYPING_ON);
    }

    @Override
    public void sendTypingOff(String conversationId) {
        this.sendMessengerTyping(conversationId, SenderAction.TYPING_OFF);
    }

    @Override
    public void sendButtonMessage(String conversationId, GroupedButton groupedButton) {
        this.sendButton(conversationId, groupedButton.getMessage(), groupedButton.getButtons(), Optional.empty());
    }

    @Override
    public void sendFileMessage(String conversationId, List<LabelUrl> labelUrlList) {
        this.sendRichMediaAssert(conversationId, labelUrlList, RichMediaAsset.Type.FILE);
    }

    @Override
    public void sendImageMessage(String conversationId, List<LabelUrl> labelUrlList) {
        this.sendRichMediaAssert(conversationId, labelUrlList, RichMediaAsset.Type.IMAGE);
    }

    @Override
    public void sendWebView(String conversationId, WebView webView) {
        try {
            ArrayList<UrlButton> buttons = new ArrayList<UrlButton>();
            for (LabelUrl button : webView.getButtons()) {
                buttons.add(UrlButton.create((String)button.getLabel(), (URL)new URL(button.getUrl()), Optional.of(WebviewHeightRatio.COMPACT), Optional.of(true), Optional.empty(), Optional.of(WebviewShareButtonState.HIDE)));
            }
            DefaultAction action = DefaultAction.create((URL)new URL(webView.getUrl()));
            Element element = Element.create((String)(Objects.isNull(webView.getTitle()) ? "" : webView.getTitle()), Optional.empty(), Optional.of(new URL(webView.getUrl())), Optional.of(action), Optional.of(buttons));
            ArrayList<Element> list = new ArrayList<Element>();
            list.add(element);
            GenericTemplate buttonTemplate = GenericTemplate.create(list);
            TemplateMessage templateMessage = TemplateMessage.create((Template)buttonTemplate);
            MessagePayload messagePayload = MessagePayload.create((String)conversationId, (MessagingType)MessagingType.RESPONSE, (Message)templateMessage);
            this.messengerSend(conversationId, (Payload)messagePayload);
        }
        catch (MessengerApiException | MessengerIOException | MalformedURLException e) {
            throw new ChatBotException(e);
        }
    }

    private void sendButton(String conversationId, String message, List<LabelUrl> labelUrls, Optional<WebviewShareButtonState> empty) {
        try {
            ArrayList<UrlButton> buttons = new ArrayList<UrlButton>();
            for (LabelUrl button : labelUrls) {
                buttons.add(UrlButton.create((String)button.getLabel(), (URL)new URL(button.getUrl()), Optional.of(WebviewHeightRatio.COMPACT), Optional.of(false), Optional.empty(), empty));
            }
            ButtonTemplate buttonTemplate = ButtonTemplate.create((String)message, buttons);
            TemplateMessage templateMessage = TemplateMessage.create((Template)buttonTemplate);
            MessagePayload messagePayload = MessagePayload.create((String)conversationId, (MessagingType)MessagingType.RESPONSE, (Message)templateMessage);
            this.messengerSend(conversationId, (Payload)messagePayload);
        }
        catch (MessengerApiException | MessengerIOException | MalformedURLException e) {
            throw new ChatBotException(e);
        }
    }

    private void sendRichMediaAssert(String conversationId, List<LabelUrl> labelUrlList, RichMediaAsset.Type file) {
        labelUrlList.forEach(labelUrl -> {
            try {
                UrlRichMediaAsset richMediaAsset = UrlRichMediaAsset.create((RichMediaAsset.Type)file, (URL)new URL(labelUrl.getUrl()));
                RichMediaMessage richMediaMessage = RichMediaMessage.create((RichMediaAsset)richMediaAsset);
                MessagePayload messagePayload = MessagePayload.create((String)conversationId, (MessagingType)MessagingType.RESPONSE, (Message)richMediaMessage);
                this.messengerSend(conversationId, (Payload)messagePayload);
            }
            catch (MessengerApiException | MessengerIOException | MalformedURLException e) {
                throw new ChatBotException(e);
            }
        });
    }

    private void messengerSend(String conversationId, Payload payload) throws MessengerApiException, MessengerIOException {
        this.sendTypingOff(conversationId);
        this.messenger.send(payload);
    }

    private void sendMessengerTyping(String conversationId, SenderAction typingOn) {
        if (this.typingIndicator.booleanValue()) {
            try {
                this.messenger.send((Payload)SenderActionPayload.create((String)conversationId, (SenderAction)typingOn));
            }
            catch (Exception e) {
                throw new ChatBotException(e);
            }
        }
    }

    private String getUrlFromLocation(Location location, TypeUrl typeUrl) {
        String urlFormat = null;
        String latitude = location.getLatitude().toString();
        String longitude = location.getLongitude().toString();
        if (typeUrl.equals((Object)TypeUrl.IMAGE)) {
            urlFormat = "https://maps.googleapis.com/maps/api/staticmap?size=764x400&center=" + latitude + "," + longitude + "&zoom=25&markers=" + latitude + "," + longitude;
        } else if (typeUrl.equals((Object)TypeUrl.ITEM)) {
            urlFormat = "http://maps.apple.com/maps?q=" + latitude + "," + longitude + "&z=16";
        }
        return urlFormat;
    }

    public String toString() {
        return super.toString();
    }

    static {
        OBJECT_MAPPER.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        OBJECT_MAPPER.setVisibility(OBJECT_MAPPER.getSerializationConfig().getDefaultVisibilityChecker().withFieldVisibility(JsonAutoDetect.Visibility.ANY).withGetterVisibility(JsonAutoDetect.Visibility.NONE).withSetterVisibility(JsonAutoDetect.Visibility.NONE).withCreatorVisibility(JsonAutoDetect.Visibility.NONE));
        OBJECT_MAPPER.setPropertyNamingStrategy(PropertyNamingStrategy.SnakeCaseStrategy.SNAKE_CASE);
    }
}

