/*
 * Decompiled with CFR 0.152.
 */
package cronapi.chatbot.cronchat;

import com.google.gson.JsonObject;
import cronapi.Var;
import cronapi.chatbot.ChatBotException;
import cronapi.chatbot.Messenger;
import cronapi.chatbot.elements.Carousel;
import cronapi.chatbot.elements.GroupedButton;
import cronapi.chatbot.elements.LabelUrl;
import cronapi.chatbot.elements.Location;
import cronapi.chatbot.elements.QuickReply;
import cronapi.chatbot.elements.WebView;
import cronapi.json.Operations;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class CronchatMessenger
implements Messenger {
    private static final String QUICK_REPLY = "quick_reply";
    private static final String SEND_TO_CLIENT = "send-to-client";
    private static final String CONTENT = "content";
    private static final String REGISTER = "register";
    private final String token;
    private final String url;
    private final String urlCronchatApi;
    private final String botGender;
    private final String botName;
    private final String startPostMessage;
    private final String title;
    private final String subtitle;
    private final String urlAvatar;
    private final String titleColor;
    private final String titleFont;
    private final String titleFontSize;
    private final String titleFontColor;
    private final String subtitleFont;
    private final String subtitleFontSize;
    private final String subtitleFontColor;
    private final String carouselQrButtonColor;
    private final String carouselQrButtonFontColor;
    private final String carouselQrButtonColorHover;
    private final String carouselQrButtonFontColorHover;
    private final String carouselQrButtonClickedColor;
    private final String carouselQrButtonFontClickedColor;
    private final String ballonFont;
    private final String ballonFontSize;
    private final String ballonFontColor;
    private final String ballonColor;
    private final String buttonStartChatColor;
    private final String buttonSendMsgColor;
    private final String inputFont;
    private final String inputFontSize;
    private final String chatColor;
    private final String carouselTitleFont;
    private final String carouselTitleFontSize;
    private final String carouselsubtitleFont;
    private final String carouselSubtitleFontSize;
    private final String carouselQrButtonFontSize;
    private final String carouselQrButtonFont;
    private final String carouselQrButtonFontSizeHover;
    private final String carouselQrButtonFontHover;
    private final String carouselQrButtonClickedFontSize;
    private final String carouselQrButtonClickedFont;
    private final String ballonUserColor;
    private final String ballonUserFontColor;
    private final String buttonStartImageBackground;
    private final String buttonStartImageBackgroundSize;
    private final String buttonStartWidth;
    private final String buttonStartHeight;
    private final Boolean typingIndicator;
    private final String buttonStartBorderRadius;

    public static CronchatMessenger create() {
        try {
            InputStream inputStream = CronchatMessenger.class.getResourceAsStream("/META-INF/chatbot.json");
            Var json = Operations.toJson((Var)Var.valueOf((Object)IOUtils.toString((InputStream)inputStream)));
            JsonObject jsonObject = json.getObjectAsJson().getAsJsonObject().get("chatbot").getAsJsonObject().get("cronchat").getAsJsonObject();
            String token = jsonObject.get("token").toString();
            String url = jsonObject.get("url").toString().replace("\"", "");
            String urlCallCronchat = jsonObject.get("urlCronchatApi").toString().replace("\"", "");
            String botName = jsonObject.get("botName").toString();
            String botGender = jsonObject.get("botGender").toString();
            String startPostMessage = jsonObject.get("startPostMessage").toString();
            String title = jsonObject.get("title").toString();
            String subtitle = jsonObject.get("subtitle").toString();
            String urlAvatar = jsonObject.get("urlAvatar").toString();
            String titleColor = jsonObject.get("titleColor").toString();
            String titleFont = jsonObject.get("titleFont").toString();
            String titleFontSize = jsonObject.get("titleFontSize").toString();
            String titleFontColor = jsonObject.get("titleFontColor").toString();
            String subtitleFont = jsonObject.get("subtitleFont").toString();
            String subtitleFontSize = jsonObject.get("subtitleFontSize").toString();
            String subtitleFontColor = jsonObject.get("subtitleFontColor").toString();
            String carouselQrButtonColor = jsonObject.get("carouselQrButtonColor").toString();
            String carouselQrButtonFontColor = jsonObject.get("carouselQrButtonFontColor").toString();
            String carouselQrButtonColorHover = jsonObject.get("carouselQrButtonColorHover").toString();
            String carouselQrButtonFontColorHover = jsonObject.get("carouselQrButtonFontColorHover").toString();
            String carouselQrButtonClickedColor = jsonObject.get("carouselQrButtonClickedColor").toString();
            String carouselQrButtonFontClickedColor = jsonObject.get("carouselQrButtonFontClickedColor").toString();
            String ballonFont = jsonObject.get("ballonFont").toString();
            String ballonFontSize = jsonObject.get("ballonFontSize").toString();
            String ballonFontColor = jsonObject.get("ballonFontColor").toString();
            String ballonColor = jsonObject.get("ballonColor").toString();
            String buttonStartChatColor = jsonObject.get("buttonStartChatColor").toString();
            String buttonSendMsgColor = jsonObject.get("buttonSendMsgColor").toString();
            String inputFont = jsonObject.get("inputFont").toString();
            String inputFontSize = jsonObject.get("inputFontSize").toString();
            String chatColor = jsonObject.get("chatColor").toString();
            String carouselTitleFont = jsonObject.get("carouselTitleFont").toString();
            String carouselTitleFontSize = jsonObject.get("carouselTitleFontSize").toString();
            String carouselsubtitleFont = jsonObject.get("carouselsubtitleFont").toString();
            String carouselSubtitleFontSize = jsonObject.get("carouselSubtitleFontSize").toString();
            String carouselQrButtonFontSize = jsonObject.get("carouselQrButtonFontSize").toString();
            String carouselQrButtonFont = jsonObject.get("carouselQrButtonFont").toString();
            String carouselQrButtonFontSizeHover = jsonObject.get("carouselQrButtonFontSizeHover").toString();
            String carouselQrButtonFontHover = jsonObject.get("carouselQrButtonFontHover").toString();
            String carouselQrButtonClickedFontSize = jsonObject.get("carouselQrButtonClickedFontSize").toString();
            String carouselQrButtonClickedFont = jsonObject.get("carouselQrButtonClickedFont").toString();
            String ballonUserColor = jsonObject.get("ballonUserColor").toString();
            String ballonUserFontColor = jsonObject.get("ballonUserFontColor").toString();
            String buttonStartImageBackground = jsonObject.get("buttonStartImageBackground").toString();
            String buttonStartImageBackgroundSize = jsonObject.get("buttonStartImageBackgroundSize").toString();
            String buttonStartWidth = jsonObject.get("buttonStartWidth").toString();
            String buttonStartHeight = jsonObject.get("buttonStartHeight").toString();
            Boolean typingIndicator = jsonObject.get("typingIndicator").getAsBoolean();
            String buttonStartBorderRadius = jsonObject.get("buttonStartBorderRadius").toString();
            return new CronchatMessenger(token, url, urlCallCronchat, botName, botGender, startPostMessage, title, subtitle, urlAvatar, titleColor, titleFont, titleFontSize, titleFontColor, subtitleFont, subtitleFontSize, subtitleFontColor, carouselQrButtonColor, carouselQrButtonFontColor, carouselQrButtonColorHover, carouselQrButtonFontColorHover, carouselQrButtonClickedColor, carouselQrButtonFontClickedColor, ballonFont, ballonFontSize, ballonFontColor, ballonColor, buttonStartChatColor, buttonSendMsgColor, inputFont, inputFontSize, chatColor, carouselTitleFont, carouselTitleFontSize, carouselsubtitleFont, carouselSubtitleFontSize, carouselQrButtonFontSize, carouselQrButtonFont, carouselQrButtonFontSizeHover, carouselQrButtonFontHover, carouselQrButtonClickedFontSize, carouselQrButtonClickedFont, ballonUserColor, ballonUserFontColor, buttonStartImageBackground, buttonStartImageBackgroundSize, buttonStartWidth, buttonStartHeight, typingIndicator, buttonStartBorderRadius);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @Autowired
    public CronchatMessenger(@Value(value="${chatbot.cronchat.token}") String token, @Value(value="${chatbot.cronchat.url}") String url, @Value(value="${chatbot.cronchat.urlCronchatApi}") String urlCallCronchat, @Value(value="${chatbot.cronchat.botName}") String botName, @Value(value="${chatbot.cronchat.botGender}") String botGender, @Value(value="${chatbot.cronchat.startPostMessage}") String startPostMessage, @Value(value="${chatbot.cronchat.title}") String title, @Value(value="${chatbot.cronchat.subtitle}") String subtitle, @Value(value="${chatbot.cronchat.urlAvatar}") String urlAvatar, @Value(value="${chatbot.cronchat.titleColor}") String titleColor, @Value(value="${chatbot.cronchat.titleFont}") String titleFont, @Value(value="${chatbot.cronchat.titleFontSize}") String titleFontSize, @Value(value="${chatbot.cronchat.titleFontColor}") String titleFontColor, @Value(value="${chatbot.cronchat.subtitleFont}") String subtitleFont, @Value(value="${chatbot.cronchat.subtitleFontSize}") String subtitleFontSize, @Value(value="${chatbot.cronchat.subtitleFontColor}") String subtitleFontColor, @Value(value="${chatbot.cronchat.carouselQrButtonColor}") String carouselQrButtonColor, @Value(value="${chatbot.cronchat.carouselQrButtonFontColor}") String carouselQrButtonFontColor, @Value(value="${chatbot.cronchat.carouselQrButtonColorHover}") String carouselQrButtonColorHover, @Value(value="${chatbot.cronchat.carouselQrButtonFontColorHover}") String carouselQrButtonFontColorHover, @Value(value="${chatbot.cronchat.carouselQrButtonClickedColor}") String carouselQrButtonClickedColor, @Value(value="${chatbot.cronchat.carouselQrButtonFontClickedColor}") String carouselQrButtonFontClickedColor, @Value(value="${chatbot.cronchat.ballonFont}") String ballonFont, @Value(value="${chatbot.cronchat.ballonFontSize}") String ballonFontSize, @Value(value="${chatbot.cronchat.ballonFontColor}") String ballonFontColor, @Value(value="${chatbot.cronchat.ballonColor}") String ballonColor, @Value(value="${chatbot.cronchat.buttonStartChatColor}") String buttonStartChatColor, @Value(value="${chatbot.cronchat.buttonSendMsgColor}") String buttonSendMsgColor, @Value(value="${chatbot.cronchat.inputFont}") String inputFont, @Value(value="${chatbot.cronchat.inputFontSize}") String inputFontSize, @Value(value="${chatbot.cronchat.chatColor}") String chatColor, @Value(value="${chatbot.cronchat.carouselTitleFont}") String carouselTitleFont, @Value(value="${chatbot.cronchat.carouselTitleFontSize}") String carouselTitleFontSize, @Value(value="${chatbot.cronchat.carouselsubtitleFont}") String carouselsubtitleFont, @Value(value="${chatbot.cronchat.carouselSubtitleFontSize}") String carouselSubtitleFontSize, @Value(value="${chatbot.cronchat.carouselQrButtonFontSize}") String carouselQrButtonFontSize, @Value(value="${chatbot.cronchat.carouselQrButtonFont}") String carouselQrButtonFont, @Value(value="${chatbot.cronchat.carouselQrButtonFontSizeHover}") String carouselQrButtonFontSizeHover, @Value(value="${chatbot.cronchat.carouselQrButtonFontHover}") String carouselQrButtonFontHover, @Value(value="${chatbot.cronchat.carouselQrButtonClickedFontSize}") String carouselQrButtonClickedFontSize, @Value(value="${chatbot.cronchat.carouselQrButtonClickedFont}") String carouselQrButtonClickedFont, @Value(value="${chatbot.cronchat.ballonUserColor}") String ballonUserColor, @Value(value="${chatbot.cronchat.ballonUserFontColor}") String ballonUserFontColor, @Value(value="${chatbot.cronchat.buttonStartImageBackground}") String buttonStartImageBackground, @Value(value="${chatbot.cronchat.buttonStartImageBackgroundSize}") String buttonStartImageBackgroundSize, @Value(value="${chatbot.cronchat.buttonStartWidth}") String buttonStartWidth, @Value(value="${chatbot.cronchat.buttonStartHeight}") String buttonStartHeight, @Value(value="${chatbot.cronchat.typingIndicator}") Boolean typingIndicator, @Value(value="${chatbot.cronchat.buttonStartBorderRadius}") String buttonStartBorderRadius) {
        this.token = token;
        this.url = url;
        this.urlCronchatApi = urlCallCronchat.endsWith("/") ? urlCallCronchat + "webhook/" : urlCallCronchat + "/webhook/";
        this.botGender = StringUtils.isEmpty((String)botGender) ? "male" : botGender;
        this.botName = StringUtils.isEmpty((String)botName) ? "Tiago" : botName;
        this.startPostMessage = startPostMessage;
        this.title = title;
        this.subtitle = subtitle;
        this.urlAvatar = urlAvatar;
        this.titleColor = titleColor;
        this.titleFont = titleFont;
        this.titleFontSize = titleFontSize;
        this.titleFontColor = titleFontColor;
        this.subtitleFont = subtitleFont;
        this.subtitleFontSize = subtitleFontSize;
        this.subtitleFontColor = subtitleFontColor;
        this.carouselQrButtonColor = carouselQrButtonColor;
        this.carouselQrButtonFontColor = carouselQrButtonFontColor;
        this.carouselQrButtonColorHover = carouselQrButtonColorHover;
        this.carouselQrButtonFontColorHover = carouselQrButtonFontColorHover;
        this.carouselQrButtonClickedColor = carouselQrButtonClickedColor;
        this.carouselQrButtonFontClickedColor = carouselQrButtonFontClickedColor;
        this.ballonFont = ballonFont;
        this.ballonFontSize = ballonFontSize;
        this.ballonFontColor = ballonFontColor;
        this.ballonColor = ballonColor;
        this.buttonStartChatColor = buttonStartChatColor;
        this.buttonSendMsgColor = buttonSendMsgColor;
        this.inputFont = inputFont;
        this.inputFontSize = inputFontSize;
        this.chatColor = chatColor;
        this.carouselTitleFont = carouselTitleFont;
        this.carouselTitleFontSize = carouselTitleFontSize;
        this.carouselsubtitleFont = carouselsubtitleFont;
        this.carouselSubtitleFontSize = carouselSubtitleFontSize;
        this.carouselQrButtonFontSize = carouselQrButtonFontSize;
        this.carouselQrButtonFont = carouselQrButtonFont;
        this.carouselQrButtonFontSizeHover = carouselQrButtonFontSizeHover;
        this.carouselQrButtonFontHover = carouselQrButtonFontHover;
        this.carouselQrButtonClickedFontSize = carouselQrButtonClickedFontSize;
        this.carouselQrButtonClickedFont = carouselQrButtonClickedFont;
        this.ballonUserColor = ballonUserColor;
        this.ballonUserFontColor = ballonUserFontColor;
        this.buttonStartImageBackground = buttonStartImageBackground;
        this.buttonStartImageBackgroundSize = buttonStartImageBackgroundSize;
        this.buttonStartWidth = buttonStartWidth;
        this.buttonStartHeight = buttonStartHeight;
        this.typingIndicator = typingIndicator;
        this.buttonStartBorderRadius = buttonStartBorderRadius;
        this.setWebhook();
    }

    private void callCronchat(String webhookMethod, JSONObject content) {
        try (CloseableHttpClient httpclient = HttpClientBuilder.create().build();){
            String requestUrl = this.urlCronchatApi + webhookMethod;
            HttpPost httppost = new HttpPost(requestUrl);
            httppost.setHeader("Accept", "application/json");
            httppost.setHeader("Content-type", "application/json");
            StringEntity entity = new StringEntity(content.toString(), "utf-8");
            httppost.setEntity((HttpEntity)entity);
            try (CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httppost);){
                HttpEntity ht = response.getEntity();
                BufferedHttpEntity buf = new BufferedHttpEntity(ht);
                String responseContent = EntityUtils.toString((HttpEntity)buf, (Charset)StandardCharsets.UTF_8);
                JSONObject result = new JSONObject(responseContent);
                if (!result.getBoolean("success")) {
                    throw new ChatBotException(result.getString("errorMessage"));
                }
            }
        }
        catch (JSONException e) {
            throw new ChatBotException("Error deserializing setWebhook method response", e);
        }
        catch (IOException e) {
            throw new ChatBotException("Error executing setWebook method", e);
        }
    }

    private void setWebhook() {
        try {
            JSONObject content = new JSONObject();
            content.put("token", (Object)this.token);
            content.put("url", (Object)this.url);
            content.put("botGender", (Object)this.botGender);
            content.put("botName", (Object)this.botName);
            content.put("startPostMessage", (Object)this.startPostMessage);
            content.put("title", (Object)this.title);
            content.put("subtitle", (Object)this.subtitle);
            content.put("urlAvatar", (Object)this.urlAvatar);
            content.put("titleColor", (Object)this.titleColor);
            content.put("titleFont", (Object)this.titleFont);
            content.put("titleFontSize", (Object)this.titleFontSize);
            content.put("titleFontColor", (Object)this.titleFontColor);
            content.put("subtitleFont", (Object)this.subtitleFont);
            content.put("subtitleFontSize", (Object)this.subtitleFontSize);
            content.put("subtitleFontColor", (Object)this.subtitleFontColor);
            content.put("carouselQrButtonColor", (Object)this.carouselQrButtonColor);
            content.put("carouselQrButtonFontColor", (Object)this.carouselQrButtonFontColor);
            content.put("carouselQrButtonColorHover", (Object)this.carouselQrButtonColorHover);
            content.put("carouselQrButtonFontColorHover", (Object)this.carouselQrButtonFontColorHover);
            content.put("carouselQrButtonClickedColor", (Object)this.carouselQrButtonClickedColor);
            content.put("carouselQrButtonFontClickedColor", (Object)this.carouselQrButtonFontClickedColor);
            content.put("ballonFont", (Object)this.ballonFont);
            content.put("ballonFontSize", (Object)this.ballonFontSize);
            content.put("ballonFontColor", (Object)this.ballonFontColor);
            content.put("ballonColor", (Object)this.ballonColor);
            content.put("buttonStartChatColor", (Object)this.buttonStartChatColor);
            content.put("buttonSendMsgColor", (Object)this.buttonSendMsgColor);
            content.put("inputFont", (Object)this.inputFont);
            content.put("inputFontSize", (Object)this.inputFontSize);
            content.put("chatColor", (Object)this.chatColor);
            content.put("carouselTitleFont", (Object)this.carouselTitleFont);
            content.put("carouselTitleFontSize", (Object)this.carouselTitleFontSize);
            content.put("carouselsubtitleFont", (Object)this.carouselsubtitleFont);
            content.put("carouselSubtitleFontSize", (Object)this.carouselSubtitleFontSize);
            content.put("carouselQrButtonFontSize", (Object)this.carouselQrButtonFontSize);
            content.put("carouselQrButtonFont", (Object)this.carouselQrButtonFont);
            content.put("carouselQrButtonFontSizeHover", (Object)this.carouselQrButtonFontSizeHover);
            content.put("carouselQrButtonFontHover", (Object)this.carouselQrButtonFontHover);
            content.put("carouselQrButtonClickedFontSize", (Object)this.carouselQrButtonClickedFontSize);
            content.put("carouselQrButtonClickedFont", (Object)this.carouselQrButtonClickedFont);
            content.put("ballonUserColor", (Object)this.ballonUserColor);
            content.put("ballonUserFontColor", (Object)this.ballonUserFontColor);
            content.put("buttonStartImageBackground", (Object)this.buttonStartImageBackground);
            content.put("buttonStartImageBackgroundSize", (Object)this.buttonStartImageBackgroundSize);
            content.put("buttonStartWidth", (Object)this.buttonStartWidth);
            content.put("buttonStartHeight", (Object)this.buttonStartHeight);
            content.put("typingIndicator", (Object)this.typingIndicator);
            content.put("buttonStartBorderRadius", (Object)this.buttonStartBorderRadius);
            this.callCronchat(REGISTER, content);
        }
        catch (Exception e) {
            throw new ChatBotException(e);
        }
    }

    private void setJsonCallCronChat(String conversationId, JSONObject jsonObject, String webHookMethod) throws JSONException {
        JSONObject result = new JSONObject();
        result.put("token", (Object)this.token);
        result.put("conversationId", (Object)conversationId);
        result.put(CONTENT, (Object)jsonObject);
        this.callCronchat(webHookMethod, result);
    }

    @Override
    public String getPlatform() {
        return "Cronchat";
    }

    @Override
    public void sendLocation(String conversationId, Location location) {
        String called = "ok";
    }

    private JSONArray translateQuickReply(List<QuickReply> quickReply) {
        JSONArray buttons = new JSONArray();
        if (quickReply != null) {
            quickReply.forEach(qr -> {
                try {
                    JSONObject button = new JSONObject();
                    button.put("type", (Object)"postBack");
                    button.put("title", (Object)qr.getText());
                    button.put("value", (Object)(qr.getData() != null ? qr.getData().toString() : qr.getUrl()));
                    buttons.put((Object)button);
                }
                catch (Exception e) {
                    throw new ChatBotException(e);
                }
            });
        }
        return buttons;
    }

    @Override
    public void sendCarousel(String conversationId, List<Carousel> carouselList) {
        try {
            JSONArray attachments = new JSONArray();
            carouselList.forEach(c -> {
                try {
                    JSONObject content = new JSONObject();
                    content.put("title", (Object)c.getMessage());
                    content.put("subtitle", (Object)c.getMessage());
                    content.put("images", (Object)new JSONArray().put((Object)new JSONObject().put("url", (Object)c.getImage())));
                    content.put("buttons", (Object)this.translateQuickReply(c.getQuickReply()));
                    JSONObject attachment = new JSONObject();
                    attachment.put("contentType", (Object)"heroCard");
                    attachment.put(CONTENT, (Object)content);
                    attachments.put((Object)attachment);
                }
                catch (Exception e) {
                    throw new ChatBotException(e);
                }
            });
            JSONObject carousel = new JSONObject();
            carousel.put("attachmentLayout", (Object)"carousel");
            carousel.put("attachments", (Object)attachments);
            this.setJsonCallCronChat(conversationId, new JSONObject().put("carousel", (Object)carousel), SEND_TO_CLIENT);
        }
        catch (Exception e) {
            throw new ChatBotException(e);
        }
    }

    @Override
    public void sendQuickReply(String conversationId, String text, List<QuickReply> quickReply) {
        if (StringUtils.isNotEmpty((String)text)) {
            this.sendTextMessage(conversationId, text);
        }
        try {
            this.setJsonCallCronChat(conversationId, new JSONObject().put(QUICK_REPLY, (Object)this.translateQuickReply(quickReply)), SEND_TO_CLIENT);
        }
        catch (Exception e) {
            throw new ChatBotException(e);
        }
    }

    @Override
    public void sendTextMessage(String conversationId, String text) {
        try {
            this.setJsonCallCronChat(conversationId, new JSONObject().put("text", (Object)text), SEND_TO_CLIENT);
        }
        catch (Exception e) {
            throw new ChatBotException(e);
        }
    }

    @Override
    public void sendTypingOn(String conversationId) {
    }

    @Override
    public void sendTypingOff(String conversationId) {
    }

    @Override
    public void sendButtonMessage(String conversationId, GroupedButton groupedButton) {
        try {
            JSONArray buttons = new JSONArray();
            groupedButton.getButtons().forEach(qr -> {
                try {
                    JSONObject button = new JSONObject();
                    button.put("type", (Object)"postBack");
                    button.put("title", (Object)qr.getLabel());
                    button.put("value", (Object)qr.getUrl());
                    buttons.put((Object)button);
                }
                catch (Exception e) {
                    throw new ChatBotException(e);
                }
            });
            JSONObject content = new JSONObject();
            content.put(QUICK_REPLY, (Object)buttons);
            content.put("text", (Object)groupedButton.getMessage());
            this.setJsonCallCronChat(conversationId, content, SEND_TO_CLIENT);
        }
        catch (Exception e) {
            throw new ChatBotException(e);
        }
    }

    @Override
    public void sendFileMessage(String conversationId, List<LabelUrl> labelUrlList) {
        try {
            JSONArray buttons = new JSONArray();
            labelUrlList.forEach(qr -> {
                try {
                    String[] urlSplited = qr.getUrl().split("/");
                    String label = urlSplited[urlSplited.length - 1];
                    JSONObject button = new JSONObject();
                    button.put("type", (Object)"postBack");
                    button.put("title", (Object)("\u00f0\u0178\u201c\u0192 " + label));
                    button.put("value", (Object)qr.getUrl());
                    buttons.put((Object)button);
                }
                catch (Exception e) {
                    throw new ChatBotException(e);
                }
            });
            this.setJsonCallCronChat(conversationId, new JSONObject().put(QUICK_REPLY, (Object)buttons), SEND_TO_CLIENT);
        }
        catch (Exception e) {
            throw new ChatBotException(e);
        }
    }

    @Override
    public void sendImageMessage(String conversationId, List<LabelUrl> labelUrlList) {
        JSONArray attachments = new JSONArray();
        labelUrlList.forEach(c -> {
            try {
                JSONObject content = new JSONObject();
                content.put("images", (Object)new JSONArray().put((Object)new JSONObject().put("url", (Object)c.getUrl())));
                JSONObject attachment = new JSONObject();
                attachment.put("contentType", (Object)"heroCard");
                attachment.put(CONTENT, (Object)content);
                attachments.put((Object)attachment);
                JSONObject carousel = new JSONObject();
                carousel.put("attachmentLayout", (Object)"none");
                carousel.put("attachments", (Object)attachments);
                this.setJsonCallCronChat(conversationId, new JSONObject().put("carousel", (Object)carousel), SEND_TO_CLIENT);
            }
            catch (Exception e) {
                throw new ChatBotException(e);
            }
        });
    }

    @Override
    public void sendWebView(String conversationId, WebView webView) {
        try {
            JSONArray attachments = new JSONArray();
            webView.getButtons().forEach(c -> {
                try {
                    JSONObject content = new JSONObject();
                    content.put("title", (Object)webView.getMessage());
                    content.put("subtitle", (Object)webView.getMessage());
                    content.put("webviewhtml", (Object)new JSONArray().put((Object)new JSONObject().put("url", (Object)webView.getUrl())));
                    JSONObject attachment = new JSONObject();
                    attachment.put("contentType", (Object)"heroCard");
                    attachment.put(CONTENT, (Object)content);
                    attachments.put((Object)attachment);
                }
                catch (Exception e) {
                    throw new ChatBotException(e);
                }
            });
            JSONObject carousel = new JSONObject();
            carousel.put("attachmentLayout", (Object)"webview");
            carousel.put("attachments", (Object)attachments);
            this.setJsonCallCronChat(conversationId, new JSONObject().put("webview", (Object)carousel), SEND_TO_CLIENT);
        }
        catch (Exception e) {
            throw new ChatBotException(e);
        }
    }
}

