/*
 * Decompiled with CFR 0.152.
 */
package cronapi.chatbot.assistant;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.ibm.cloud.sdk.core.util.GsonSingleton;
import com.ibm.watson.assistant.v1.Assistant;
import com.ibm.watson.assistant.v1.model.Context;
import com.ibm.watson.assistant.v1.model.MessageInput;
import com.ibm.watson.assistant.v1.model.MessageOptions;
import com.ibm.watson.assistant.v1.model.MessageResponse;
import cronapi.Var;
import cronapi.chatbot.ChatBotException;
import cronapi.chatbot.Messenger;
import cronapi.chatbot.elements.UserProfile;
import java.io.IOException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.h2.jdbcx.JdbcConnectionPool;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class WatsonAssistant {
    private static final Logger LOGGER = Logger.getLogger(WatsonAssistant.class.getName());
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final String CONNECTION_STRING = "jdbc:h2:~/chatbot.h2;MVCC=TRUE";
    private static final String DDL_SESSION = "CREATE TABLE IF NOT EXISTS SESSION\n(\n    ID INT AUTO_INCREMENT PRIMARY KEY NOT NULL,\n    WORKSPACE VARCHAR NOT NULL,\n    PLATFORM VARCHAR NOT NULL,\n    CHAT VARCHAR NOT NULL,\n    CONTEXT VARCHAR NOT NULL,\n)";
    private static final String COLUMN_ID = "ID";
    private static final String COLUMN_WORKSPACE = "WORKSPACE";
    private static final String COLUMN_PLATFORM = "PLATFORM";
    private static final String COLUMN_CHAT = "CHAT";
    private static final String COLUMN_CONTEXT = "CONTEXT";
    private static final String QRY_SESSION = "SELECT ID, CONTEXT FROM SESSION WHERE WORKSPACE = ? AND PLATFORM = ? AND CHAT = ? FOR UPDATE";
    private static final String INS_SESSION = "INSERT INTO SESSION(WORKSPACE, PLATFORM, CHAT, CONTEXT) VALUES (?, ?, ?, ?)";
    private static final String UPD_SESSION = "UPDATE SESSION SET CONTEXT = ? WHERE ID = ?";
    private Boolean logWatson;
    private final JdbcConnectionPool connectionPool;
    private final ExecutorService executor = Executors.newCachedThreadPool();
    private final String workspace;
    private final String error;
    private final Assistant assistant;

    @Autowired
    public WatsonAssistant(@Value(value="${chatbot.watson.workspace}") String workspace, @Value(value="${chatbot.watson.error}") String error, Assistant assistant, @Value(value="${chatbot.watson.log}") boolean logWatson) {
        this.workspace = workspace;
        this.error = error;
        this.assistant = assistant;
        this.connectionPool = JdbcConnectionPool.create((String)CONNECTION_STRING, (String)"sa", (String)"sa");
        this.connectionPool.setMaxConnections(256);
        this.setLogWatson(logWatson);
        try (Connection connection = this.getConnection();
             PreparedStatement statement = connection.prepareStatement(DDL_SESSION);){
            statement.execute();
        }
        catch (SQLException e) {
            throw new ChatBotException(e);
        }
    }

    private Connection getConnection() {
        try {
            return this.connectionPool.getConnection();
        }
        catch (SQLException e) {
            throw new ChatBotException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Context getContext(String workspace, String platform, String chat) {
        try (Connection connection = this.getConnection();){
            try (PreparedStatement statement = connection.prepareStatement(QRY_SESSION);){
                statement.setString(1, workspace);
                statement.setString(2, platform);
                statement.setString(3, chat);
                try (ResultSet resultSet = statement.executeQuery();){
                    if (resultSet.next()) {
                        Context ctx = (Context)GsonSingleton.getGson().fromJson(resultSet.getString(COLUMN_CONTEXT), Context.class);
                        LOGGER.info(ctx.toString());
                        Context context = ctx;
                        return context;
                    }
                }
            }
            Context context = null;
            return context;
        }
        catch (Exception e) {
            throw new ChatBotException(e);
        }
    }

    private void updateContext(String workspace, String platform, String chat, Context context) {
        block35: {
            try (Connection connection = this.getConnection();){
                Integer id = null;
                String contextString = GsonSingleton.getGson().toJson((Object)context);
                try (PreparedStatement statement = connection.prepareStatement(QRY_SESSION);){
                    statement.setString(1, workspace);
                    statement.setString(2, platform);
                    statement.setString(3, chat);
                    try (ResultSet resultSet = statement.executeQuery();){
                        if (resultSet.next()) {
                            id = resultSet.getInt(COLUMN_ID);
                        }
                    }
                }
                if (id == null) {
                    statement = connection.prepareStatement(INS_SESSION);
                    try {
                        statement.setString(1, workspace);
                        statement.setString(2, platform);
                        statement.setString(3, chat);
                        statement.setString(4, contextString);
                        statement.execute();
                        break block35;
                    }
                    finally {
                        if (statement != null) {
                            statement.close();
                        }
                    }
                }
                statement = connection.prepareStatement(UPD_SESSION);
                try {
                    statement.setString(1, contextString);
                    statement.setInt(2, id);
                    statement.execute();
                }
                finally {
                    if (statement != null) {
                        statement.close();
                    }
                }
            }
            catch (Exception e) {
                throw new ChatBotException(e);
            }
        }
    }

    public void handleTextMessage(String conversationId, String text, Messenger messenger, UserProfile user) {
        if (this.getLogWatson().booleanValue()) {
            LOGGER.warning(() -> String.format("[%s] Handling text message: %s", conversationId, text));
        }
        this.executor.execute(() -> {
            String inputText;
            Map incomingContext = null;
            if (text.startsWith("{")) {
                try {
                    Map incomingMap = (Map)OBJECT_MAPPER.readValue(text, Map.class);
                    if (incomingMap.containsKey("context")) {
                        incomingContext = (Map)incomingMap.get("context");
                    }
                    if (incomingMap.containsKey("message")) {
                        inputText = incomingMap.get("message").toString();
                    }
                    inputText = text;
                }
                catch (IOException e) {
                    throw new ChatBotException(e);
                }
            } else {
                inputText = text;
            }
            MessageInput input = new MessageInput();
            input.setText(inputText.replaceAll("\\r\\n|\\r|\\n", " "));
            Context context = this.getContext(this.workspace, messenger.getPlatform(), conversationId);
            if (incomingContext != null) {
                for (Object incomingContextKey : incomingContext.keySet()) {
                    context.put(incomingContextKey.toString(), incomingContext.get(incomingContextKey));
                }
            }
            MessageOptions messageOptions = new MessageOptions.Builder().context(context).workspaceId(this.workspace).input(input).build();
            MessageResponse message = (MessageResponse)this.assistant.message(messageOptions).execute().getResult();
            if (this.getLogWatson().booleanValue()) {
                LOGGER.warning(String.format("[%s] Sending context to Messenger: %s", conversationId, message.getContext()));
                LOGGER.warning(String.format("[%s] Sending output to Messenger: %s", conversationId, message.getOutput()));
            }
            messenger.sendWatsonMessage(conversationId, message);
            context = message.getContext();
            List entities = message.getEntities();
            List intents = message.getIntents();
            try {
                String extraParams = conversationId.split("_extraparam_")[1];
                context.put("extraParams", (Object)extraParams);
                LOGGER.info(() -> String.format("EXTRA PARAMS VALUE: [%s]", extraParams));
            }
            catch (Exception err) {
                LOGGER.info(() -> "extraParam not informed on conversationID");
            }
            if (context.get("blockly") != null) {
                MessageInput messageInput;
                try {
                    String blocklyClassName = context.get("blockly").toString();
                    Class<?> blocklyClass = Class.forName(blocklyClassName);
                    Method executeMethod = blocklyClass.getMethod("Executar", Var.class, Var.class, Var.class);
                    executeMethod.invoke(null, Var.valueOf((Object)context), Var.valueOf((Object)intents), Var.valueOf((Object)entities));
                    context.removeProperty("blockly");
                    messageInput = new MessageInput();
                    messageInput.setText(blocklyClassName + ".Done");
                    messageOptions = new MessageOptions.Builder().context(context).workspaceId(this.workspace).input(messageInput).build();
                    message = (MessageResponse)this.assistant.message(messageOptions).execute().getResult();
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, e.getMessage(), e);
                    context.removeProperties();
                    messageInput = new MessageInput();
                    messageInput.setText(this.error);
                    messageOptions = new MessageOptions.Builder().context(context).workspaceId(this.workspace).input(messageInput).build();
                    message = (MessageResponse)this.assistant.message(messageOptions).execute().getResult();
                }
                messenger.sendWatsonMessage(conversationId, message);
                context = message.getContext();
            }
            context.put("userProfile", (Object)user);
            context.removeProperty("location");
            context.removeProperty("quick_reply");
            context.removeProperty("carousel");
            context.removeProperty("send_file");
            context.removeProperty("send_image");
            context.removeProperty("send_button");
            this.updateContext(this.workspace, messenger.getPlatform(), conversationId, context);
        });
    }

    public Boolean getLogWatson() {
        return this.logWatson != null && this.logWatson != false;
    }

    public void setLogWatson(Boolean logWatson) {
        this.logWatson = logWatson;
    }

    static {
        OBJECT_MAPPER.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        OBJECT_MAPPER.setVisibility(OBJECT_MAPPER.getSerializationConfig().getDefaultVisibilityChecker().withFieldVisibility(JsonAutoDetect.Visibility.ANY).withGetterVisibility(JsonAutoDetect.Visibility.NONE).withSetterVisibility(JsonAutoDetect.Visibility.NONE).withCreatorVisibility(JsonAutoDetect.Visibility.NONE));
        OBJECT_MAPPER.setPropertyNamingStrategy(PropertyNamingStrategy.SnakeCaseStrategy.SNAKE_CASE);
        try {
            Class.forName("org.h2.Driver");
        }
        catch (ClassNotFoundException e) {
            throw new ChatBotException(e);
        }
    }
}

