/*
 * Decompiled with CFR 0.152.
 */
package cronapi.chatbot.assistant;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.ibm.watson.developer_cloud.assistant.v1.Assistant;
import com.ibm.watson.developer_cloud.assistant.v1.model.Context;
import com.ibm.watson.developer_cloud.assistant.v1.model.InputData;
import com.ibm.watson.developer_cloud.assistant.v1.model.MessageOptions;
import com.ibm.watson.developer_cloud.assistant.v1.model.MessageResponse;
import com.ibm.watson.developer_cloud.http.ServiceCall;
import cronapi.CronapiMetaData;
import cronapi.Var;
import cronapi.chatbot.ChatBotException;
import cronapi.chatbot.Messenger;
import cronapi.chatbot.elements.UserProfile;
import cronapi.json.Operations;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.h2.jdbcx.JdbcConnectionPool;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@CronapiMetaData
@Component
public class WatsonAssistant {
    private static final Logger LOGGER = Logger.getLogger(WatsonAssistant.class.getName());
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final String CONNECTION_STRING = "jdbc:h2:~/chatbot.h2;MVCC=TRUE";
    private static final String DDL_SESSION = "CREATE TABLE IF NOT EXISTS SESSION\n(\n    ID INT AUTO_INCREMENT PRIMARY KEY NOT NULL,\n    WORKSPACE VARCHAR NOT NULL,\n    PLATFORM VARCHAR NOT NULL,\n    CHAT VARCHAR NOT NULL,\n    CONTEXT VARCHAR NOT NULL,\n)";
    private static final String COLUMN_ID = "ID";
    private static final String COLUMN_WORKSPACE = "WORKSPACE";
    private static final String COLUMN_PLATFORM = "PLATFORM";
    private static final String COLUMN_CHAT = "CHAT";
    private static final String COLUMN_CONTEXT = "CONTEXT";
    private static final String QRY_SESSION = "SELECT ID, CONTEXT FROM SESSION WHERE WORKSPACE = ? AND PLATFORM = ? AND CHAT = ? FOR UPDATE";
    private static final String INS_SESSION = "INSERT INTO SESSION(WORKSPACE, PLATFORM, CHAT, CONTEXT) VALUES (?, ?, ?, ?)";
    private static final String UPD_SESSION = "UPDATE SESSION SET CONTEXT = ? WHERE ID = ?";
    private Boolean logWatson;
    private final JdbcConnectionPool connectionPool;
    private final ExecutorService executor = Executors.newCachedThreadPool();
    private final String workspace;
    private final String error;
    private final Assistant assistant;
    private final String blocklyPre;
    private final String blocklyPos;

    @Autowired
    public WatsonAssistant(@Value(value="${chatbot.watson.workspace}") String workspace, @Value(value="${chatbot.watson.error}") String error, Assistant assistant, @Value(value="${chatbot.watson.log}") boolean logWatson, @Value(value="${chatbot.watson.blocklyPre}") String blocklyPre, @Value(value="${chatbot.watson.blocklyPos}") String blocklyPos) {
        this.workspace = workspace;
        this.error = error;
        this.assistant = assistant;
        this.connectionPool = JdbcConnectionPool.create((String)CONNECTION_STRING, (String)"sa", (String)"sa");
        this.connectionPool.setMaxConnections(256);
        this.blocklyPre = blocklyPre;
        this.blocklyPos = blocklyPos;
        this.setLogWatson(logWatson);
        try (Connection connection = this.getConnection();
             PreparedStatement statement = connection.prepareStatement(DDL_SESSION);){
            statement.execute();
        }
        catch (SQLException e) {
            throw new ChatBotException(e);
        }
    }

    private Connection getConnection() {
        try {
            return this.connectionPool.getConnection();
        }
        catch (SQLException e) {
            throw new ChatBotException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Context getContext(String workspace, String platform, String chat) {
        try (Connection connection = this.getConnection();){
            try (PreparedStatement statement = connection.prepareStatement(QRY_SESSION);){
                statement.setString(1, workspace);
                statement.setString(2, platform);
                statement.setString(3, chat);
                try (ResultSet resultSet = statement.executeQuery();){
                    if (resultSet.next()) {
                        Context context = (Context)OBJECT_MAPPER.readValue(resultSet.getString(COLUMN_CONTEXT), Context.class);
                        return context;
                    }
                }
            }
            Context context = null;
            return context;
        }
        catch (IOException | SQLException e) {
            throw new ChatBotException(e);
        }
    }

    private void updateContext(String workspace, String platform, String chat, Context context) {
        block65: {
            try (Connection connection = this.getConnection();){
                Integer id = null;
                String contextString = OBJECT_MAPPER.writeValueAsString((Object)context);
                try (PreparedStatement statement = connection.prepareStatement(QRY_SESSION);){
                    statement.setString(1, workspace);
                    statement.setString(2, platform);
                    statement.setString(3, chat);
                    try (ResultSet resultSet = statement.executeQuery();){
                        if (resultSet.next()) {
                            id = resultSet.getInt(COLUMN_ID);
                        }
                    }
                }
                if (id == null) {
                    statement = connection.prepareStatement(INS_SESSION);
                    var10_13 = null;
                    try {
                        statement.setString(1, workspace);
                        statement.setString(2, platform);
                        statement.setString(3, chat);
                        statement.setString(4, contextString);
                        statement.execute();
                        break block65;
                    }
                    catch (Throwable throwable) {
                        var10_13 = throwable;
                        throw throwable;
                    }
                    finally {
                        if (statement != null) {
                            if (var10_13 != null) {
                                try {
                                    statement.close();
                                }
                                catch (Throwable throwable) {
                                    var10_13.addSuppressed(throwable);
                                }
                            } else {
                                statement.close();
                            }
                        }
                    }
                }
                statement = connection.prepareStatement(UPD_SESSION);
                var10_13 = null;
                try {
                    statement.setString(1, contextString);
                    statement.setInt(2, id);
                    statement.execute();
                }
                catch (Throwable throwable) {
                    var10_13 = throwable;
                    throw throwable;
                }
                finally {
                    if (statement != null) {
                        if (var10_13 != null) {
                            try {
                                statement.close();
                            }
                            catch (Throwable throwable) {
                                var10_13.addSuppressed(throwable);
                            }
                        } else {
                            statement.close();
                        }
                    }
                }
            }
            catch (IOException | SQLException e) {
                throw new ChatBotException(e);
            }
        }
    }

    public void handleTextMessage(String conversationId, String text, Messenger messenger, UserProfile user) {
        if (this.getLogWatson().booleanValue()) {
            LOGGER.warning(() -> String.format("[%s] Handling text message: %s", conversationId, text));
        }
        this.executor.execute(() -> {
            Object objectPreSend;
            Map incomingContext = null;
            Map incomingMap = null;
            if (text.startsWith("{")) {
                try {
                    incomingMap = (Map)OBJECT_MAPPER.readValue(text, Map.class);
                }
                catch (IOException e) {
                    throw new ChatBotException(e);
                }
            } else {
                incomingMap = new HashMap<String, String>();
                incomingMap.putIfAbsent("message", text);
            }
            Object object = objectPreSend = Objects.nonNull(this.blocklyPre) && !this.blocklyPre.isEmpty() ? this.preSend(conversationId, text, messenger, incomingMap, this.blocklyPre, user) : null;
            if (incomingMap.containsKey("context")) {
                incomingContext = (Map)incomingMap.get("context");
            }
            String inputText = incomingMap.containsKey("message") ? incomingMap.get("message").toString() : text;
            InputData input = new InputData.Builder().text(inputText.replaceAll("\\r\\n|\\r|\\n", " ")).build();
            Context context = this.getContext(this.workspace, messenger.getPlatform(), conversationId);
            if (incomingContext != null) {
                for (Object incomingContextKey : incomingContext.keySet()) {
                    context.put((Object)incomingContextKey.toString(), incomingContext.get(incomingContextKey));
                }
            }
            MessageOptions messageOptions = new MessageOptions.Builder().context(context).workspaceId(this.workspace).input(input).build();
            if (Objects.nonNull(this.blocklyPre) && !this.blocklyPre.isEmpty() && Objects.nonNull(this.blocklyPos)) {
                this.previousExecution(conversationId, messenger, user, messageOptions, objectPreSend);
            } else {
                this.nextExecution(conversationId, messenger, user, messageOptions);
            }
        });
    }

    private Object preSend(String conversationId, String text, Messenger messenger, Map incomingMap, String blocklyExecute, UserProfile user) {
        if (this.getLogWatson().booleanValue()) {
            LOGGER.warning(String.format("[%s] Sending pre Watson", conversationId));
        }
        if (Objects.nonNull(blocklyExecute) && !blocklyExecute.isEmpty()) {
            try {
                System.out.println(Operations.toJson((Var)Var.valueOf((Object)user)));
                String json = "{ \"firstName\" : \"" + user.getFirstName() + "\",\n   \"lastName\" : \"" + user.getLastName() + "\" \n}";
                Object newIncomingMap = this.sendBlockly(conversationId, blocklyExecute, Arrays.asList(Var.valueOf((Object)conversationId), Var.valueOf((Object)messenger.getPlatform()), Var.valueOf((Object)incomingMap), Var.valueOf((Object)json)), Var.class, Var.class, Var.class, Var.class).getObject();
                return Objects.nonNull(newIncomingMap) ? newIncomingMap : null;
            }
            catch (Exception e) {
                return incomingMap;
            }
        }
        return incomingMap;
    }

    private MessageResponse posSend(String conversationId, MessageResponse message, Messenger messenger, String blocklyExecute) {
        if (this.getLogWatson().booleanValue()) {
            LOGGER.warning(String.format("[%s] Sending pos Watson", conversationId));
        }
        if (Objects.nonNull(blocklyExecute) && !blocklyExecute.isEmpty()) {
            MessageResponse newMessageResponse = (MessageResponse)this.sendBlockly(conversationId, this.blocklyPos, Arrays.asList(Var.valueOf((Object)conversationId), Var.valueOf((Object)messenger), Var.valueOf((Object)messenger)), Var.class, Var.class, Var.class).getObject();
            return Objects.nonNull(newMessageResponse) ? newMessageResponse : message;
        }
        return message;
    }

    private Var sendBlockly(String conversationId, String blocklyClassName, List args, Class<?> ... parameterTypes) {
        try {
            Class<?> blocklyClass = Class.forName(blocklyClassName);
            Method executeMethod = blocklyClass.getMethod("Executar", parameterTypes);
            Object obj = executeMethod.invoke(null, args.toArray());
            return Var.valueOf((Object)obj);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new ChatBotException(e);
        }
    }

    private void nextExecution(String conversationId, Messenger messenger, UserProfile user, MessageOptions messageOptions) {
        ServiceCall serviceCall = this.assistant.message(messageOptions);
        MessageResponse message = (MessageResponse)serviceCall.execute();
        if (this.getLogWatson().booleanValue()) {
            LOGGER.warning(String.format("[%s] Sending context to Messenger: %s", conversationId, message.getContext()));
            LOGGER.warning(String.format("[%s] Sending output to Messenger: %s", conversationId, message.getOutput()));
        }
        messenger.sendWatsonMessage(conversationId, message);
        Context context = message.getContext();
        List entities = message.getEntities();
        List intents = message.getIntents();
        if (context.containsKey((Object)"blockly")) {
            try {
                String blocklyClassName = context.get((Object)"blockly").toString();
                this.sendBlockly(null, blocklyClassName, Arrays.asList(context, intents, entities), Var.class, Var.class, Var.class);
                context.remove((Object)"blockly");
                messageOptions = new MessageOptions.Builder().context(context).workspaceId(this.workspace).input(new InputData.Builder().text(blocklyClassName + ".Done").build()).build();
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, e.getMessage(), e);
                context.clear();
                messageOptions = new MessageOptions.Builder().context(context).workspaceId(this.workspace).input(new InputData.Builder().text(this.error).build()).build();
            }
            message = (MessageResponse)this.assistant.message(messageOptions).execute();
            message = this.posSend(conversationId, message, messenger, this.blocklyPos);
            messenger.sendWatsonMessage(conversationId, message);
            context = message.getContext();
        }
        this.updateContextPutRemove(user, context);
        this.updateContext(this.workspace, messenger.getPlatform(), conversationId, context);
    }

    private void previousExecution(String conversationId, Messenger messenger, UserProfile user, MessageOptions messageOptions, Object sendWatson) {
        Boolean execute = Objects.nonNull(sendWatson);
        if (execute.booleanValue()) {
            MessageResponse message = (MessageResponse)this.assistant.message(messageOptions).execute();
            if (this.getLogWatson().booleanValue()) {
                LOGGER.warning(String.format("[%s] Sending context to Messenger: %s", conversationId, message.getContext()));
                LOGGER.warning(String.format("[%s] Sending output to Messenger: %s", conversationId, message.getOutput()));
            }
            messenger.sendWatsonMessage(conversationId, message);
            Context context = message.getContext();
            List entities = message.getEntities();
            List intents = message.getIntents();
            if (context.containsKey((Object)"blockly")) {
                try {
                    String blocklyClassName = context.get((Object)"blockly").toString();
                    Class<?> blocklyClass = Class.forName(blocklyClassName);
                    Method executeMethod = blocklyClass.getMethod("Executar", Var.class, Var.class, Var.class);
                    executeMethod.invoke(null, Var.valueOf((Object)context), Var.valueOf((Object)intents), Var.valueOf((Object)entities));
                    context.remove((Object)"blockly");
                    messageOptions = new MessageOptions.Builder().context(context).workspaceId(this.workspace).input(new InputData.Builder().text(blocklyClassName + ".Done").build()).build();
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, e.getMessage(), e);
                    context.clear();
                    messageOptions = new MessageOptions.Builder().context(context).workspaceId(this.workspace).input(new InputData.Builder().text(this.error).build()).build();
                }
                message = (MessageResponse)this.assistant.message(messageOptions).execute();
                messenger.sendWatsonMessage(conversationId, message);
                context = message.getContext();
            }
            this.updateContextPutRemove(user, context);
            this.updateContext(this.workspace, messenger.getPlatform(), conversationId, context);
        }
    }

    private void updateContextPutRemove(UserProfile user, Context context) {
        context.put((Object)"userProfile", (Object)user);
        context.remove((Object)"location");
        context.remove((Object)"quick_reply");
        context.remove((Object)"carousel");
        context.remove((Object)"send_file");
        context.remove((Object)"send_image");
        context.remove((Object)"send_button");
        context.remove((Object)"send_webview");
    }

    public Boolean getLogWatson() {
        return this.logWatson != null && this.logWatson != false;
    }

    public void setLogWatson(Boolean logWatson) {
        this.logWatson = logWatson;
    }

    static {
        OBJECT_MAPPER.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        OBJECT_MAPPER.setVisibility(OBJECT_MAPPER.getSerializationConfig().getDefaultVisibilityChecker().withFieldVisibility(JsonAutoDetect.Visibility.ANY).withGetterVisibility(JsonAutoDetect.Visibility.NONE).withSetterVisibility(JsonAutoDetect.Visibility.NONE).withCreatorVisibility(JsonAutoDetect.Visibility.NONE));
        OBJECT_MAPPER.setPropertyNamingStrategy(PropertyNamingStrategy.SnakeCaseStrategy.SNAKE_CASE);
        try {
            Class.forName("org.h2.Driver");
        }
        catch (ClassNotFoundException e) {
            throw new ChatBotException(e);
        }
    }
}

