/*
 * Decompiled with CFR 0.152.
 */
package cronapi.chatbot;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.github.messenger4j.Messenger;
import com.ibm.watson.developer_cloud.assistant.v1.Assistant;
import cronapi.chatbot.elements.Carousel;
import cronapi.chatbot.elements.GroupedButton;
import cronapi.chatbot.elements.LabelUrl;
import cronapi.chatbot.elements.QuickReply;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.support.EncodedResource;
import org.springframework.core.io.support.PropertySourceFactory;
import org.springframework.util.StringUtils;

@Configuration
@org.springframework.context.annotation.PropertySource(value={"classpath:/META-INF/chatbot.json"}, factory=JsonLoader.class)
public class ChatBotConfiguration {
    public static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    public static final TypeReference<List<QuickReply>> TYPE_LIST_QUICKREPLY = new TypeReference<List<QuickReply>>(){};
    public static final TypeReference<List<Carousel>> TYPE_LIST_CAROUSEL = new TypeReference<List<Carousel>>(){};
    public static final TypeReference<List<LabelUrl>> TYPE_LIST_LABELURL = new TypeReference<List<LabelUrl>>(){};
    public static final TypeReference<List<GroupedButton>> TYPE_LIST_GROUPEDBUTTON = new TypeReference<List<GroupedButton>>(){};

    @Bean
    public Messenger facebook(@Value(value="${chatbot.facebook.page}") String pageAccessToken, @Value(value="${chatbot.facebook.app}") String appSecret, @Value(value="${chatbot.facebook.verify}") String verifyToken) {
        return Messenger.create((String)pageAccessToken, (String)appSecret, (String)verifyToken);
    }

    @Bean
    public Assistant assistant(@Value(value="${chatbot.watson.username}") String username, @Value(value="${chatbot.watson.password}") String password) {
        Assistant assistant = new Assistant("2018-02-16");
        assistant.setUsernameAndPassword(username, password);
        return assistant;
    }

    static {
        OBJECT_MAPPER.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        OBJECT_MAPPER.setVisibility(OBJECT_MAPPER.getSerializationConfig().getDefaultVisibilityChecker().withFieldVisibility(JsonAutoDetect.Visibility.ANY).withGetterVisibility(JsonAutoDetect.Visibility.NONE).withSetterVisibility(JsonAutoDetect.Visibility.NONE).withCreatorVisibility(JsonAutoDetect.Visibility.NONE));
        OBJECT_MAPPER.setPropertyNamingStrategy(PropertyNamingStrategy.SnakeCaseStrategy.SNAKE_CASE);
    }

    public static class JsonLoader
    implements PropertySourceFactory {
        public PropertySource<?> createPropertySource(String s, EncodedResource resource) throws IOException {
            Map readValue = (Map)new ObjectMapper().readValue(resource.getInputStream(), Map.class);
            return new MapPropertySource("chatbot", this.flatten(readValue));
        }

        private final Map<String, Object> flatten(Map<String, Object> source) {
            LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
            this.flatten(result, source, null);
            return result;
        }

        private void flatten(Map<String, Object> result, Map<String, Object> source, String path) {
            for (Map.Entry<String, Object> entry : source.entrySet()) {
                Object value;
                String key = entry.getKey();
                if (StringUtils.hasText((String)path)) {
                    key = key.startsWith("[") ? path + key : path + "." + key;
                }
                if ((value = entry.getValue()) instanceof String) {
                    result.put(key, value);
                    continue;
                }
                if (value instanceof Map) {
                    Map map = (Map)value;
                    this.flatten(result, map, key);
                    continue;
                }
                if (value instanceof Collection) {
                    Collection collection = (Collection)value;
                    int count = 0;
                    for (Object object : collection) {
                        this.flatten(result, Collections.singletonMap("[" + count++ + "]", object), key);
                    }
                    continue;
                }
                result.put(key, value == null ? "" : value);
            }
        }
    }
}

