/*
 * Decompiled with CFR 0.152.
 */
package cronapi.chatbot.cronchat;

import cronapi.chatbot.Messenger;
import cronapi.chatbot.assistant.WatsonAssistant;
import cronapi.chatbot.cronchat.CronchatMessenger;
import cronapi.chatbot.elements.UserProfile;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/cronapi/chatbot/cronchat"})
public class CronchatWebhook {
    private final Messenger messenger;
    private final WatsonAssistant assistant;
    private UserProfile user;

    @Autowired
    public CronchatWebhook(CronchatMessenger messenger, WatsonAssistant assistant) {
        this.messenger = messenger;
        this.assistant = assistant;
    }

    @RequestMapping(method={RequestMethod.POST})
    public ResponseEntity<Void> handleCallback(@RequestBody String payload) {
        JSONObject json = new JSONObject(payload);
        String conversationId = json.getString("conversationId");
        String text = json.getString("text");
        this.assistant.handleTextMessage(conversationId, text, this.messenger, this.user);
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).build();
    }

    @RequestMapping(method={RequestMethod.GET})
    public ResponseEntity<String> verifyWebhook() {
        return ResponseEntity.ok((Object)"");
    }
}

