/*
 * Decompiled with CFR 0.152.
 */
package cronapi.chatbot.cronchat;

import cronapi.chatbot.ChatBotException;
import cronapi.chatbot.Messenger;
import cronapi.chatbot.elements.Carousel;
import cronapi.chatbot.elements.Location;
import cronapi.chatbot.elements.QuickReply;
import cronapi.chatbot.elements.TypeUrl;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class CronchatMessenger
implements Messenger {
    private final String token;
    private final String url;
    private final String urlCronchatApi;
    private final String botGender;
    private final String botName;

    @Autowired
    public CronchatMessenger(@Value(value="${chatbot.cronchat.token}") String token, @Value(value="${chatbot.cronchat.url}") String url, @Value(value="${chatbot.cronchat.urlCronchatApi}") String urlCallCronchat, @Value(value="${chatbot.cronchat.botName}") String botName, @Value(value="${chatbot.cronchat.botGender}") String botGender) {
        this.token = token;
        this.url = url;
        this.urlCronchatApi = urlCallCronchat.endsWith("/") ? urlCallCronchat + "webhook/" : urlCallCronchat + "/webhook/";
        this.botGender = StringUtils.isEmpty((String)botGender) ? "male" : botGender;
        this.botName = StringUtils.isEmpty((String)botName) ? "Tiago" : botName;
        this.setWebhook();
    }

    private void callCronchat(String webhookMethod, JSONObject content) {
        try (CloseableHttpClient httpclient = HttpClientBuilder.create().build();){
            String requestUrl = this.urlCronchatApi + webhookMethod;
            HttpPost httppost = new HttpPost(requestUrl);
            httppost.setHeader("Accept", "application/json");
            httppost.setHeader("Content-type", "application/json");
            StringEntity entity = new StringEntity(content.toString(), "utf-8");
            httppost.setEntity((HttpEntity)entity);
            try (CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httppost);){
                HttpEntity ht = response.getEntity();
                BufferedHttpEntity buf = new BufferedHttpEntity(ht);
                String responseContent = EntityUtils.toString((HttpEntity)buf, (Charset)StandardCharsets.UTF_8);
                JSONObject result = new JSONObject(responseContent);
                if (!result.getBoolean("success")) {
                    throw new ChatBotException(result.getString("errorMessage"));
                }
            }
        }
        catch (JSONException e) {
            throw new ChatBotException("Error deserializing setWebhook method response", e);
        }
        catch (IOException e) {
            throw new ChatBotException("Error executing setWebook method", e);
        }
    }

    private void setWebhook() {
        JSONObject content = new JSONObject();
        content.put("token", (Object)this.token);
        content.put("url", (Object)this.url);
        content.put("botGender", (Object)this.botGender);
        content.put("botName", (Object)this.botName);
        this.callCronchat("register", content);
    }

    @Override
    public String getPlatform() {
        return "Cronchat";
    }

    @Override
    public void sendLocation(String conversationId, Location location) {
        String called = "ok";
    }

    private JSONArray translateQuickReply(List<QuickReply> quickReply) {
        JSONArray buttons = new JSONArray();
        if (quickReply != null) {
            quickReply.forEach(qr -> {
                JSONObject button = new JSONObject();
                button.put("type", (Object)"postBack");
                button.put("title", (Object)qr.getText());
                button.put("value", (Object)(qr.getData() != null ? qr.getData().toString() : qr.getUrl()));
                buttons.put((Object)button);
            });
        }
        return buttons;
    }

    @Override
    public void sendCarousel(String conversationId, List<Carousel> carouselList) {
        try {
            JSONArray attachments = new JSONArray();
            carouselList.forEach(c -> {
                JSONObject content = new JSONObject();
                content.put("title", (Object)c.getMessage());
                content.put("subtitle", (Object)c.getMessage());
                content.put("images", (Object)new JSONArray().put((Object)new JSONObject().put("url", (Object)c.getImage())));
                content.put("buttons", (Object)this.translateQuickReply(c.getQuickReply()));
                JSONObject attachment = new JSONObject();
                attachment.put("contentType", (Object)"heroCard");
                attachment.put("content", (Object)content);
                attachments.put((Object)attachment);
            });
            JSONObject carousel = new JSONObject();
            carousel.put("attachmentLayout", (Object)"carousel");
            carousel.put("attachments", (Object)attachments);
            JSONObject result = new JSONObject();
            result.put("token", (Object)this.token);
            result.put("conversationId", (Object)conversationId);
            result.put("content", (Object)new JSONObject().put("carousel", (Object)carousel));
            this.callCronchat("send-to-client", result);
        }
        catch (Exception e) {
            throw new ChatBotException(e);
        }
    }

    @Override
    public void sendQuickReply(String conversationId, String text, List<QuickReply> quickReply) {
        try {
            JSONObject result = new JSONObject();
            result.put("token", (Object)this.token);
            result.put("conversationId", (Object)conversationId);
            result.put("content", (Object)new JSONObject().put("quick_reply", (Object)this.translateQuickReply(quickReply)));
            this.callCronchat("send-to-client", result);
        }
        catch (Exception e) {
            throw new ChatBotException(e);
        }
    }

    @Override
    public void sendTextMessage(String conversationId, String text) {
        try {
            JSONObject result = new JSONObject();
            result.put("token", (Object)this.token);
            result.put("conversationId", (Object)conversationId);
            result.put("content", (Object)new JSONObject().put("text", (Object)text));
            this.callCronchat("send-to-client", result);
        }
        catch (Exception e) {
            throw new ChatBotException(e);
        }
    }

    @Override
    public String getUrlFromLocation(Location location, TypeUrl typeUrl) {
        return null;
    }
}

